/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.io.Serializable;
import javax.transaction.Synchronization;
import org.hibernate.Transaction;
import org.hibernate.event.EventSource;
import org.hibernate.event.FlushEventListener;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class EventSourceTransactionContext
implements TransactionContext,
Serializable {
    private static final Logger log = LoggerFactory.make();
    private final EventSource eventSource;
    private transient FullTextIndexEventListener flushListener;
    private Boolean realTxInProgress = null;

    public EventSourceTransactionContext(EventSource eventSource) {
        this.eventSource = eventSource;
        this.flushListener = this.getIndexWorkFlushEventListener();
    }

    public Object getTransactionIdentifier() {
        if (this.isRealTransactionInProgress()) {
            return this.eventSource.getTransaction();
        }
        return this.eventSource;
    }

    public void registerSynchronization(Synchronization synchronization) {
        if (this.isRealTransactionInProgress()) {
            Transaction transaction = this.eventSource.getTransaction();
            transaction.registerSynchronization(synchronization);
        } else {
            this.flushListener = this.getIndexWorkFlushEventListener();
            if (this.flushListener != null) {
                this.flushListener.addSynchronization(this.eventSource, synchronization);
            } else {
                throw new SearchException("AssertionFailure: flushListener not registered any more.");
            }
        }
    }

    private FullTextIndexEventListener getIndexWorkFlushEventListener() {
        FlushEventListener[] flushEventListeners;
        if (this.flushListener != null) {
            return this.flushListener;
        }
        for (FlushEventListener listener : flushEventListeners = this.eventSource.getListeners().getFlushEventListeners()) {
            if (!listener.getClass().equals(FullTextIndexEventListener.class)) continue;
            return (FullTextIndexEventListener)listener;
        }
        log.debug("No FullTextIndexEventListener was registered");
        return null;
    }

    public boolean isTransactionInProgress() {
        return this.getIndexWorkFlushEventListener() != null || this.isRealTransactionInProgress();
    }

    private boolean isRealTransactionInProgress() {
        if (this.realTxInProgress == null) {
            this.realTxInProgress = this.eventSource.isTransactionInProgress();
        }
        return this.realTxInProgress;
    }
}

