/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.Properties;
import javax.transaction.Synchronization;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.impl.BatchedQueueingProcessor;
import org.hibernate.search.backend.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.WeakIdentityHashMap;
import org.slf4j.Logger;

public class TransactionalWorker
implements Worker {
    private static final Logger log = LoggerFactory.make();
    protected final WeakIdentityHashMap<Object, Synchronization> synchronizationPerTransaction = new WeakIdentityHashMap();
    private QueueingProcessor queueingProcessor;

    public void performWork(Work work, TransactionContext transactionContext) {
        if (transactionContext.isTransactionInProgress()) {
            Object transactionIdentifier = transactionContext.getTransactionIdentifier();
            PostTransactionWorkQueueSynchronization txSync = (PostTransactionWorkQueueSynchronization)this.synchronizationPerTransaction.get(transactionIdentifier);
            if (txSync == null || txSync.isConsumed()) {
                txSync = new PostTransactionWorkQueueSynchronization(this.queueingProcessor, this.synchronizationPerTransaction);
                transactionContext.registerSynchronization(txSync);
                this.synchronizationPerTransaction.put(transactionIdentifier, txSync);
            }
            txSync.add(work);
        } else {
            log.warn("It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!");
            WorkQueue queue = new WorkQueue(2);
            this.queueingProcessor.add(work, queue);
            this.queueingProcessor.prepareWorks(queue);
            this.queueingProcessor.performWorks(queue);
        }
    }

    public void initialize(Properties props, SearchFactoryImplementor searchFactory) {
        this.queueingProcessor = new BatchedQueueingProcessor(searchFactory, props);
    }

    public void close() {
        this.queueingProcessor.close();
    }

    public void flushWorks(TransactionContext transactionContext) {
        Object transaction;
        PostTransactionWorkQueueSynchronization txSync;
        if (transactionContext.isTransactionInProgress() && (txSync = (PostTransactionWorkQueueSynchronization)this.synchronizationPerTransaction.get(transaction = transactionContext.getTransactionIdentifier())) != null && !txSync.isConsumed()) {
            txSync.flushWorks();
        }
    }
}

