/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.integration.jboss5;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.identity.idm.api.IdentitySessionFactory;
import org.jboss.identity.idm.api.cfg.IdentityConfiguration;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.common.transaction.Transactions;
import org.jboss.identity.idm.impl.configuration.IdentityConfigurationImpl;
import org.jboss.identity.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.jboss.identity.idm.integration.jboss5.HibernatePopulator;
import org.jboss.identity.idm.integration.jboss5.IDMMetadata;
import org.jboss.identity.idm.integration.jboss5.SQLPopulator;
import org.jboss.identity.idm.integration.jboss5.jaxb2.HibernateDeployerType;
import org.jboss.identity.idm.integration.jboss5.jaxb2.HibernateInitializerType;
import org.jboss.identity.idm.integration.jboss5.jaxb2.JbossIDMDeployerType;
import org.jboss.identity.idm.integration.jboss5.jaxb2.SqlInitializerType;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDMDeployer
extends AbstractSimpleVFSRealDeployer<IDMMetadata> {
    private static final Logger logger = Logger.getLogger(IDMDeployer.class.getName());
    private static final String HIBERNATE_CONFIGFILE = "hibernateConfiguration";
    private IdentitySessionFactory idSF;
    private SessionFactory hibernateSF;
    private TransactionManager transactionManager;
    private IdentityConfiguration identityConfiguration;

    public IDMDeployer() {
        super(IDMMetadata.class);
    }

    public void deploy(VFSDeploymentUnit deploymentUnit, IDMMetadata metadata) throws DeploymentException {
        JbossIDMDeployerType config = metadata.getDeploperType();
        try {
            InputStream is = deploymentUnit.getClassLoader().getResourceAsStream(config.getIdmConfigFile());
            IdentityConfigurationMetaData identityMetadata = JAXB2IdentityConfiguration.createConfigurationMetaData((InputStream)is);
            this.identityConfiguration = new IdentityConfigurationImpl().configure(identityMetadata);
            if (config.getHibernateDeployer() != null) {
                this.deployHibernateConfigurationFile(config, this.identityConfiguration);
            }
            if (config.getInitializers() != null) {
                this.initializeDB(config, identityMetadata, this.identityConfiguration);
            }
            try {
                Transactions.required((TransactionManager)this.transactionManager, (Transactions.Runnable)new Transactions.Runnable(){

                    public Object run() throws Exception {
                        IDMDeployer.this.idSF = IDMDeployer.this.identityConfiguration.buildIdentitySessionFactory();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new Exception("Cannot create IdentitySessionFactory", e);
            }
            InitialContext context = new InitialContext();
            context.bind(config.getJNDIName(), (Object)this.idSF);
            logger.info("Started [" + metadata.getDeployerFileName() + "]  IDM SessionFactory at JNDI [" + config.getJNDIName() + "]");
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void initializeDB(JbossIDMDeployerType config, IdentityConfigurationMetaData identityMetadata, IdentityConfiguration identityConfiguration) throws Exception {
        logger.fine("starting to populate the schema into db");
        String datasource = config.getInitializers().getDatasource();
        this.checkTargetDB(config.getInitializers().getDatasource());
        HibernateInitializerType hibernateInitializer = config.getInitializers().getHibernateInitializer();
        SqlInitializerType sqlInitializer = config.getInitializers().getSqlInitializer();
        if (hibernateInitializer != null) {
            for (IdentityStoreConfigurationMetaData store : identityMetadata.getIdentityStores()) {
                String hibernateConfigFile = store.getOptionSingleValue(HIBERNATE_CONFIGFILE);
                if (hibernateConfigFile == null || "".equals(hibernateConfigFile.trim())) continue;
                logger.fine("starting to populate the schema from file [" + hibernateConfigFile + "]");
                HibernatePopulator hibernatePopulator = new HibernatePopulator(hibernateInitializer, identityConfiguration);
                hibernatePopulator.populateSchema();
            }
        } else if (sqlInitializer != null) {
            logger.fine("starting to populate the schema from script file [" + sqlInitializer.getSqlFile() + "]");
            SQLPopulator sqlPopulator = new SQLPopulator(datasource, sqlInitializer.getSqlFile(), sqlInitializer.getExitSQL());
            sqlPopulator.populateSchema();
        }
    }

    private void deployHibernateConfigurationFile(JbossIDMDeployerType config, IdentityConfiguration identityConfiguration) throws NamingException, IdentityException {
        HibernateDeployerType hibernateConfig = config.getHibernateDeployer();
        this.hibernateSF = new AnnotationConfiguration().configure(hibernateConfig.getHibernateConfiguration()).buildSessionFactory();
        if (hibernateConfig.getHibernateSessionFactoryJNDIName() != null) {
            InitialContext context = new InitialContext();
            context.bind(hibernateConfig.getHibernateSessionFactoryJNDIName(), (Object)this.hibernateSF);
            logger.fine("Registered the Hibernate Session Factory in JNDI of " + hibernateConfig.getHibernateSessionFactoryJNDIName());
        }
        if (hibernateConfig.getHibernateSessionFactoryRegistryName() != null) {
            identityConfiguration.getIdentityConfigurationRegistry().register((Object)this.hibernateSF, hibernateConfig.getHibernateSessionFactoryRegistryName());
            logger.fine("Registered the Hibernate Session Factory in Identity Registration of " + hibernateConfig.getHibernateSessionFactoryRegistryName());
        }
    }

    public void undeploy(VFSDeploymentUnit deploymentUnit, IDMMetadata metadata) {
        if (this.idSF != null) {
            this.idSF.close();
        }
        try {
            InitialContext context = new InitialContext();
            context.unbind(metadata.getDeploperType().getJNDIName());
            if (metadata.getDeploperType().getHibernateDeployer() != null) {
                HibernateDeployerType hibernateDeployer;
                if (this.hibernateSF != null) {
                    this.hibernateSF.close();
                }
                if ((hibernateDeployer = metadata.getDeploperType().getHibernateDeployer()).getHibernateSessionFactoryJNDIName() != null) {
                    context.unbind(hibernateDeployer.getHibernateSessionFactoryJNDIName());
                }
                if (hibernateDeployer.getHibernateSessionFactoryRegistryName() != null) {
                    this.identityConfiguration.getIdentityConfigurationRegistry().unregister(hibernateDeployer.getHibernateSessionFactoryRegistryName());
                }
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            throw new RuntimeException(e);
        }
        logger.info("Stopped [" + metadata.getDeployerFileName() + "] IDM SessionFactory at JNDI [" + metadata.getDeploperType().getJNDIName() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTargetDB(String datasource) {
        Connection conn = null;
        Dialect dialectName = null;
        try {
            DataSource ds = (DataSource)new InitialContext().lookup(datasource);
            conn = ds.getConnection();
            DatabaseMetaData meta = conn.getMetaData();
            String databaseName = meta.getDatabaseProductName();
            int databaseMajorVersion = this.getDatabaseMajorVersion(meta);
            dialectName = DialectFactory.determineDialect((String)databaseName, (int)databaseMajorVersion);
            logger.fine("Detected dialect " + dialectName + ", database is (" + databaseName + "," + databaseMajorVersion + ")");
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.log(Level.SEVERE, "error in closing the connection", e);
                }
            }
        }
    }

    private int getDatabaseMajorVersion(DatabaseMetaData meta) {
        try {
            Method gdbmvMethod = DatabaseMetaData.class.getMethod("getDatabaseMajorVersion", null);
            return (Integer)gdbmvMethod.invoke((Object)meta, (Object[])null);
        }
        catch (NoSuchMethodException nsme) {
            return 0;
        }
        catch (Throwable t) {
            logger.fine("could not get database version from JDBC metadata");
            return 0;
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

