/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.query.UnsupportedQueryCriterium;
import org.jboss.identity.idm.api.query.UserQuery;
import org.jboss.identity.idm.api.query.UserQueryBuilder;
import org.jboss.identity.idm.impl.api.IdentitySearchCriteriaImpl;
import org.jboss.identity.idm.impl.api.query.AbstractQueryBuilder;
import org.jboss.identity.idm.impl.api.query.UserQueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserQueryBuilderImpl
extends AbstractQueryBuilder
implements UserQueryBuilder {
    private String userId;
    private Set<Group> groupsAssociatedWith = new HashSet<Group>();
    private Set<Group> groupsConnectedWithRole = new HashSet<Group>();
    private Set<Group> groupsRelated = new HashSet<Group>();

    public UserQuery createQuery() {
        return new UserQueryImpl(this.searchCriteria, this.userId, this.groupsAssociatedWith, this.groupsConnectedWithRole, this.groupsRelated);
    }

    public UserQueryBuilder reset() {
        this.searchCriteria = new IdentitySearchCriteriaImpl();
        this.userId = null;
        this.groupsAssociatedWith = new HashSet<Group>();
        this.groupsConnectedWithRole = new HashSet<Group>();
        this.groupsRelated = new HashSet<Group>();
        return this;
    }

    public UserQueryBuilder withUserId(String id) {
        this.checkNotNullArgument(id, "User id");
        this.userId = id;
        return this;
    }

    public UserQueryBuilder addAssociatedGroup(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsAssociatedWith.add(group);
        return this;
    }

    public UserQueryBuilder addAssociatedGroup(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.groupsAssociatedWith.add(this.createGroupFromId(id));
        return this;
    }

    public UserQueryBuilder addAssociatedGroups(Collection<Group> groups) {
        this.checkNotNullArgument(groups, "Groups");
        this.groupsAssociatedWith.addAll(groups);
        return this;
    }

    public UserQueryBuilder addAssociatedGroupsIds(Collection<String> groups) {
        this.checkNotNullArgument(groups, "Groups");
        for (String groupId : groups) {
            this.groupsAssociatedWith.add(this.createGroupFromId(groupId));
        }
        return this;
    }

    public UserQueryBuilder addGroupConnectedWithRole(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsConnectedWithRole.add(group);
        return this;
    }

    public UserQueryBuilder addGroupConnectedWithRole(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.groupsConnectedWithRole.add(this.createGroupFromId(id));
        return this;
    }

    public UserQueryBuilder addGroupsConnectedWithRole(Collection<Group> groups) {
        this.checkNotNullArgument(groups, "Groups");
        this.groupsConnectedWithRole.addAll(groups);
        return this;
    }

    public UserQueryBuilder addGroupsIdsConnectedWithRole(Collection<String> groups) {
        this.checkNotNullArgument(groups, "Groups");
        for (String groupId : groups) {
            this.groupsConnectedWithRole.add(this.createGroupFromId(groupId));
        }
        return this;
    }

    public UserQueryBuilder addRelatedGroup(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsRelated.add(group);
        return this;
    }

    public UserQueryBuilder addRelatedGroup(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.groupsRelated.add(this.createGroupFromId(id));
        return this;
    }

    public UserQueryBuilder addRelatedGroups(Collection<Group> group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsRelated.addAll(group);
        return this;
    }

    public UserQueryBuilder addRelatedGroupsIds(Collection<String> ids) {
        this.checkNotNullArgument(ids, "Groups ids");
        for (String id : ids) {
            this.groupsRelated.add(this.createGroupFromId(id));
        }
        return this;
    }

    public UserQueryBuilder sort(SortOrder order) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.sort(order);
    }

    public UserQueryBuilder sortAttributeName(String name) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.sortAttributeName(name);
    }

    public UserQueryBuilder page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.page(firstResult, maxResults);
    }

    public UserQueryBuilder attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.attributeValuesFilter(attributeName, attributeValue);
    }

    public UserQueryBuilder idFilter(String idFilter) throws UnsupportedQueryCriterium {
        return (UserQueryBuilder)super.idFilter(idFilter);
    }
}

