/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentitySearchCriteria;
import org.jboss.identity.idm.api.IdentitySearchCriteriumType;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.RelationshipManager;
import org.jboss.identity.idm.api.RelationshipManagerFeaturesDescription;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.api.IdentitySearchCriteriaImpl;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.store.IdentityObjectSearchCriteriaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipManagerImpl
extends AbstractManager
implements RelationshipManager,
Serializable {
    RelationshipManagerFeaturesDescription featuresDescription = new RelationshipManagerFeaturesDescription(){

        public boolean isIdentityAssociationSupported(String fromGroupType) {
            IdentityObjectType identityOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            IdentityObjectType groupIdentityOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(fromGroupType);
            try {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipTypeSupported(groupIdentityOT, identityOT, MEMBER);
            }
            catch (IdentityException e) {
                return false;
            }
        }

        public boolean isGroupAssociationSupported(String fromGroupType, String toGroupType) {
            IdentityObjectType toGroupOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(toGroupType);
            IdentityObjectType fromGroupOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(fromGroupType);
            try {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipTypeSupported(fromGroupOT, toGroupOT, MEMBER);
            }
            catch (IdentityException e) {
                return false;
            }
        }

        public boolean isIdentitiesSearchCriteriumTypeSupported(IdentitySearchCriteriumType constraintType) {
            IdentityObjectType objectType = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf((String)constraintType.name());
            if (constraint != null) {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isSearchCriteriaTypeSupported(objectType, constraint);
            }
            return false;
        }

        public boolean isGroupsSearchCriteriumTypeSupported(String groupType, IdentitySearchCriteriumType constraintType) {
            IdentityObjectType objectType = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf((String)constraintType.name());
            if (constraint != null) {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isSearchCriteriaTypeSupported(objectType, constraint);
            }
            return false;
        }
    };
    public static final IdentityObjectRelationshipType MEMBER = new IdentityObjectRelationshipType(){

        public String getName() {
            return "JBOSS_IDENTITY_MEMBERSHIP";
        }
    };
    private static final long serialVersionUID = -1054805796187123311L;

    public RelationshipManagerImpl(IdentitySession session) {
        super(session);
    }

    public RelationshipManagerFeaturesDescription getFeaturesDescription() {
        return this.featuresDescription;
    }

    public void associateGroups(Collection<Group> parents, Collection<Group> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (Group parent : parents) {
            for (Group member : members) {
                this.associateGroups(parent, member);
            }
        }
    }

    public void associateGroups(Group parent, Collection<Group> members) throws IdentityException {
        this.checkNotNullArgument(parent, "parent");
        this.checkNotNullArgument(members, "members");
        this.associateGroups(Arrays.asList(parent), members);
    }

    public void associateGroupsByIds(Collection<String> parentIds, Collection<String> memberIds) throws IdentityException {
        this.checkNotNullArgument(parentIds, "Parents Ids");
        this.checkNotNullArgument(memberIds, "Members Ids");
        for (String parentId : parentIds) {
            for (String memberId : memberIds) {
                this.associateGroupsByIds(parentId, memberId);
            }
        }
    }

    public void associateGroupsByIds(String parentId, Collection<String> memberIds) throws IdentityException {
        this.checkNotNullArgument(parentId, "Parent Id");
        this.associateGroupsByIds(Arrays.asList(parentId), memberIds);
    }

    public void associateGroups(Group parent, Group member) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent group");
        this.checkNotNullArgument(member, "Member group");
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null, true);
    }

    public void associateGroupsByIds(String parentId, String memberId) throws IdentityException {
        this.checkNotNullArgument(parentId, "Parent Id");
        this.checkNotNullArgument(memberId, "Member Id");
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObjectForGroupId(parentId), this.createIdentityObjectForGroupId(memberId), MEMBER, null, true);
    }

    public void associateUsers(Collection<Group> parents, Collection<User> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (Group parent : parents) {
            for (User member : members) {
                this.associateUser(parent, member);
            }
        }
    }

    public void associateUser(Group parent, Collection<User> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent group");
        this.associateUsers(Arrays.asList(parent), members);
    }

    public void associateUsersByIds(Collection<String> parents, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (String parent : parents) {
            for (String member : members) {
                this.associateUserByIds(parent, member);
            }
        }
    }

    public void associateUsersByIds(String parentId, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parentId, "Parent Id");
        this.associateUsersByIds(Arrays.asList(parentId), members);
    }

    public void associateUser(Group parent, User member) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent group");
        this.checkNotNullArgument(member, "Member user");
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null, true);
    }

    public void associateUserByIds(String parentId, String memberId) throws IdentityException {
        this.checkNotNullArgument(parentId, "Parent group Id");
        this.checkNotNullArgument(memberId, "Member user Id");
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObjectForGroupId(parentId), this.createIdentityObjectForUserName(memberId), MEMBER, null, true);
    }

    public void disassociateGroups(Collection<Group> parents, Collection<Group> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (Group parent : parents) {
            for (Group member : members) {
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null);
            }
        }
    }

    public void disassociateGroups(Group parent, Collection<Group> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent");
        this.disassociateGroups(Arrays.asList(parent), members);
    }

    public void disassociateGroupsByIds(Collection<String> parents, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (String parent : parents) {
            for (String member : members) {
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObjectForGroupId(parent), this.createIdentityObjectForGroupId(member), MEMBER, null);
            }
        }
    }

    public void disassociateGroupsByIds(String parent, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent Id");
        this.disassociateGroupsByIds(Arrays.asList(parent), members);
    }

    public void disassociateUsers(Collection<Group> parents, Collection<User> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (Group parent : parents) {
            for (User member : members) {
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null);
            }
        }
    }

    public void disassociateUsers(Group parent, Collection<User> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent group");
        this.disassociateUsers(Arrays.asList(parent), members);
    }

    public void disassociateUsersByIds(Collection<String> parents, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (String parent : parents) {
            for (String member : members) {
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObjectForGroupId(parent), this.createIdentityObjectForUserName(member), MEMBER, null);
            }
        }
    }

    public void disassociateUsersByIds(String parent, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent Id");
        this.disassociateUsersByIds(Arrays.asList(parent), members);
    }

    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(Collection<G> parents, Collection<I> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (IdentityType parent : parents) {
            for (IdentityType member : members) {
                Set relationships = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER);
                if (relationships.size() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAssociatedByIds(Collection<String> parents, Collection<String> members) throws IdentityException {
        this.checkNotNullArgument(parents, "parents");
        this.checkNotNullArgument(members, "members");
        for (String parent : parents) {
            for (String member : members) {
                Set relationships = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER);
                if (relationships.size() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(G parent, I member) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent IdentityType");
        this.checkNotNullArgument(member, "Member IdentityType");
        HashSet<G> parents = new HashSet<G>();
        parents.add(parent);
        HashSet<I> members = new HashSet<I>();
        members.add(member);
        return this.isAssociated((G)parents, (I)members);
    }

    public boolean isAssociatedByIds(String parent, String member) throws IdentityException {
        this.checkNotNullArgument(parent, "Parent Id");
        this.checkNotNullArgument(member, "Member Id");
        Set relationships = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER);
        return relationships.size() != 0;
    }

    private Collection<Group> findAssociatedGroupsCascaded(Collection<Group> previous, Group group, String groupType, boolean parent, IdentitySearchCriteria criteria) throws IdentityException {
        Collection<Group> results = this.findAssociatedGroups(group, groupType, parent, false, criteria);
        LinkedList<Group> newResults = new LinkedList<Group>();
        for (Group result : results) {
            if (previous.contains(result)) continue;
            newResults.add(result);
            previous.add(result);
            newResults.addAll(this.findAssociatedGroupsCascaded(previous, result, groupType, parent, criteria));
        }
        return newResults;
    }

    public Collection<Group> findAssociatedGroups(Group group, String groupType, boolean parent, boolean cascade, IdentitySearchCriteria criteria) throws IdentityException {
        IdentityObjectType iot;
        this.checkNotNullArgument(group, "Group");
        LinkedList<Group> identities = new LinkedList();
        IdentityObjectType identityObjectType = iot = groupType != null ? this.getIdentityObjectType(groupType) : null;
        if (cascade) {
            HashSet<Group> prev = new HashSet<Group>();
            prev.add(group);
            identities = (List)this.findAssociatedGroupsCascaded(prev, group, groupType, parent, criteria);
            try {
                if (criteria != null) {
                    IdentitySearchCriteriaImpl.applyCriteria(this.identitySession, this.convertSearchControls(criteria), identities);
                }
            }
            catch (Exception e) {
                throw new IdentityException("Failed to apply criteria", (Throwable)e);
            }
            return identities;
        }
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(group), MEMBER, parent, this.convertSearchControls(criteria));
        for (IdentityObject io : ios) {
            if ((iot != null || io.getIdentityType().getName().equals(this.getUserObjectType().getName())) && (iot == null || !io.getIdentityType().getName().equals(iot.getName()))) continue;
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findAssociatedGroups(String groupId, String groupType, boolean parent, boolean cascade, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        Group group = this.createGroupFromId(groupId);
        return this.findAssociatedGroups(group, groupType, parent, cascade, criteria);
    }

    public Collection<Group> findAssociatedGroups(Group group, String groupType, boolean parent, boolean cascade) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        return this.findAssociatedGroups(group, groupType, parent, cascade, null);
    }

    public Collection<Group> findAssociatedGroups(User user, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        LinkedList<Group> identities = new LinkedList<Group>();
        IdentityObjectType iot = groupType != null ? this.getIdentityObjectType(groupType) : null;
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(user), MEMBER, false, this.convertSearchControls(criteria));
        for (IdentityObject io : ios) {
            if (iot != null && !io.getIdentityType().getName().equals(iot.getName())) continue;
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findAssociatedGroups(String userName, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findAssociatedGroups(user, groupType, criteria);
    }

    public Collection<Group> findAssociatedGroups(User user, String groupType) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        return this.findAssociatedGroups(user, groupType, null);
    }

    public Collection<Group> findAssociatedGroups(User user, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        LinkedList<Group> identities = new LinkedList<Group>();
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(user), MEMBER, false, this.convertSearchControls(criteria));
        String userTypeName = this.getUserObjectType().getName();
        for (IdentityObject io : ios) {
            if (io.getIdentityType().getName().equals(userTypeName)) continue;
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findAssociatedGroups(String userName, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findAssociatedGroups(user, criteria);
    }

    public Collection<Group> findAssociatedGroups(User user) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        return this.findAssociatedGroups(user, (IdentitySearchCriteria)null);
    }

    public Collection<User> findAssociatedUsers(Group group, boolean cascade, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        LinkedList<User> identities = new LinkedList<User>();
        if (cascade) {
            identities.addAll(this.findAssociatedUsers(group, false, criteria));
            Collection<Group> groups = this.findAssociatedGroups(group, null, true, true, criteria);
            for (Group asociatedGroup : groups) {
                identities.addAll(this.findAssociatedUsers(asociatedGroup, false, criteria));
            }
            try {
                if (criteria != null) {
                    IdentitySearchCriteriaImpl.applyCriteria(this.identitySession, this.convertSearchControls(criteria), identities);
                }
            }
            catch (Exception e) {
                throw new IdentityException("Failed to apply criteria", (Throwable)e);
            }
            return identities;
        }
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(group), MEMBER, true, this.convertSearchControls(criteria));
        String userTypeName = this.getUserObjectType().getName();
        for (IdentityObject io : ios) {
            if (!io.getIdentityType().getName().equals(userTypeName)) continue;
            identities.add(this.createUser(io));
        }
        return identities;
    }

    public Collection<User> findAssociatedUsers(String groupId, boolean cascade, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        Group group = this.createGroupFromId(groupId);
        return this.findAssociatedUsers(group, cascade, criteria);
    }

    public Collection<User> findAssociatedUsers(Group group, boolean cascade) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        return this.findAssociatedUsers(group, cascade, null);
    }

    public Collection<Group> findRelatedGroups(User user, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        LinkedList<Group> identities = new LinkedList<Group>();
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(user), null, false, this.convertSearchControls(criteria));
        String userTypeName = this.getUserObjectType().getName();
        for (IdentityObject io : ios) {
            if (io.getIdentityType().getName().equals(userTypeName)) continue;
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findRelatedGroups(String userName, String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findRelatedGroups(user, groupType, criteria);
    }

    public Collection<User> findRelatedUsers(Group group, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        LinkedList<User> identities = new LinkedList<User>();
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(group), null, true, this.convertSearchControls(criteria));
        String userTypeName = this.getUserObjectType().getName();
        for (IdentityObject io : ios) {
            User user;
            if (!io.getIdentityType().getName().equals(userTypeName) || identities.contains(user = this.createUser(io))) continue;
            identities.add(this.createUser(io));
        }
        return identities;
    }

    public Collection<User> findRelatedUsers(String groupId, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        Group group = this.createGroupFromId(groupId);
        return this.findRelatedUsers(group, criteria);
    }
}

