/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.cache.JBossCacheAttributeStoreWrapper;
import org.jboss.identity.idm.spi.cache.IdentityStoreCacheProvider;
import org.jboss.identity.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.jboss.identity.idm.spi.exception.OperationNotSupportedException;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectCredential;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.search.IdentityObjectSearchCriteria;
import org.jboss.identity.idm.spi.store.AttributeStore;
import org.jboss.identity.idm.spi.store.FeaturesMetaData;
import org.jboss.identity.idm.spi.store.IdentityStore;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheIdentityStoreWrapper
extends JBossCacheAttributeStoreWrapper
implements IdentityStore {
    private static Logger log = Logger.getLogger(JBossCacheIdentityStoreWrapper.class.getName());
    private final IdentityStore identityStore;

    public JBossCacheIdentityStoreWrapper(IdentityStore identityStore, IdentityStoreCacheProvider cacheSupport) throws IdentityException {
        super((AttributeStore)identityStore, cacheSupport);
        this.identityStore = identityStore;
        cacheSupport.initResidentNodes(identityStore.getSupportedFeatures().getSupportedIdentityObjectTypes(), identityStore.getSupportedFeatures().getSupportedRelationshipTypes());
        log.fine("------------------------------------------------------");
        log.fine("JBossCacheIdentityStoreWrapper created .....(IdentityStore: " + identityStore.getId() + ")");
        log.fine("------------------------------------------------------");
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        this.identityStore.bootstrap(configurationContext);
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.identityStore.getSupportedFeatures();
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        IdentityObject io = this.identityStore.createIdentityObject(invocationCtx, name, identityObjectType);
        if (io != null) {
            this.cacheSupport.invalidateCachedIdentityObjectSearches(io);
            this.cacheSupport.invalidateCachedIdentityObjectCount(identityObjectType);
            this.cacheSupport.putIntoCache(io);
        }
        return io;
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        IdentityObject io = this.identityStore.createIdentityObject(invocationCtx, name, identityObjectType, attributes);
        if (io != null) {
            this.cacheSupport.invalidateCachedIdentityObjectSearches(io);
            this.cacheSupport.putIntoCache(io, this.identityStore.getAttributes(invocationCtx, io));
        }
        return io;
    }

    public void removeIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity) throws IdentityException {
        this.identityStore.removeIdentityObject(invocationCtx, identity);
        this.cacheSupport.removeFromCache(identity);
        this.cacheSupport.invalidateCachedIdentityObjectSearches(identity);
        this.cacheSupport.invalidateCachedIdentityObjectCount(identity.getIdentityType());
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType) throws IdentityException {
        int count = this.cacheSupport.getIdentityObjectCountFromCache(identityType);
        if (count == -1) {
            count = this.identityStore.getIdentityObjectsCount(invocationCtx, identityType);
            this.cacheSupport.putIdentityObjectCountIntoCache(identityType, count);
        }
        return count;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String name, IdentityObjectType identityObjectType) throws IdentityException {
        IdentityObject io = this.cacheSupport.getFromCache(name, identityObjectType);
        if (io == null) {
            io = this.identityStore.findIdentityObject(invocationContext, name, identityObjectType);
            this.cacheSupport.putIntoCache(io);
            return io;
        }
        return io;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String id) throws IdentityException {
        IdentityObject io = this.cacheSupport.getFromCache(id);
        if (io == null) {
            io = this.identityStore.findIdentityObject(invocationContext, id);
            this.cacheSupport.putIntoCache(io);
            return io;
        }
        return io;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        Collection results = this.cacheSupport.getIdentityObjectSearchFromCache(identityType, criteria);
        if (results == null) {
            results = this.identityStore.findIdentityObject(invocationCtx, identityType, criteria);
            this.cacheSupport.putIdentityObjectSearchIntoCache(identityType, criteria, results);
            for (IdentityObject result : results) {
                this.cacheSupport.putIntoCache(result);
            }
        }
        return results;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        Collection results = this.cacheSupport.getIdentityObjectSearchFromCache(identity, relationshipType, parent, criteria);
        if (results == null) {
            results = this.identityStore.findIdentityObject(invocationCtx, identity, relationshipType, parent, criteria);
            this.cacheSupport.putIdentityObjectSearchToCache(identity, relationshipType, parent, criteria, results);
            for (IdentityObject result : results) {
                this.cacheSupport.putIntoCache(result);
            }
        }
        return results;
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName, boolean createNames) throws IdentityException {
        this.cacheSupport.invalidateCachedRelationshipSearches(fromIdentity, toIdentity, relationshipType, relationshipName);
        return this.identityStore.createRelationship(invocationCxt, fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
    }

    public void removeRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName) throws IdentityException {
        this.identityStore.removeRelationship(invocationCxt, fromIdentity, toIdentity, relationshipType, relationshipName);
        this.cacheSupport.invalidateCachedRelationshipSearches(fromIdentity, toIdentity, relationshipType, relationshipName);
    }

    public void removeRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        this.identityStore.removeRelationships(invocationCtx, identity1, identity2, named);
        this.cacheSupport.invalidateCachedRelationshipSearches(identity1, identity2, named);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        Set results = this.cacheSupport.getRelationshipsSearchFromCache(fromIdentity, toIdentity, relationshipType);
        if (results == null) {
            results = this.identityStore.resolveRelationships(invocationCxt, fromIdentity, toIdentity, relationshipType);
            this.cacheSupport.putRelationshipsSearchIntoCache(fromIdentity, toIdentity, relationshipType, results);
        }
        return results;
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name) throws IdentityException {
        Set results = this.cacheSupport.getRelationshipsSearchFromCache(identity, relationshipType, parent, named, name);
        if (results == null) {
            results = this.identityStore.resolveRelationships(invocationCtx, identity, relationshipType, parent, named, name);
            this.cacheSupport.putRelationshipSearchIntoCache(identity, relationshipType, parent, named, name, results);
        }
        return results;
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        this.cacheSupport.invalidateRelationshipNameSearches(name);
        return this.identityStore.createRelationshipName(ctx, name);
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        this.cacheSupport.invalidateRelationshipNameSearches(name);
        return this.identityStore.removeRelationshipName(ctx, name);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        Set results = this.cacheSupport.getRelationshipNamesSearchFromCache(criteria);
        if (results == null) {
            results = this.identityStore.getRelationshipNames(ctx, criteria);
            this.cacheSupport.putRelationshipNamesSearchIntoCache(criteria, results);
        }
        return results;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        Set results = this.cacheSupport.getRelationshipNamesSearchFromCache(identity, criteria);
        if (results == null) {
            results = this.identityStore.getRelationshipNames(ctx, identity, criteria);
            this.cacheSupport.putRelationshipNamesSearchIntoCache(identity, criteria, results);
        }
        return results;
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        return this.identityStore.getRelationshipNameProperties(ctx, name);
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        this.identityStore.setRelationshipNameProperties(ctx, name, properties);
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        this.identityStore.removeRelationshipNameProperties(ctx, name, properties);
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        return this.identityStore.getRelationshipProperties(ctx, relationship);
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        this.identityStore.setRelationshipProperties(ctx, relationship, properties);
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        this.identityStore.removeRelationshipProperties(ctx, relationship, properties);
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        return this.identityStore.validateCredential(ctx, identityObject, credential);
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        this.identityStore.updateCredential(ctx, identityObject, credential);
    }

    @Override
    public String toString() {
        return "JBossCacheIdentityStoreWrapper (IdentityStore=" + this.identityStore.getId() + ")";
    }
}

