/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.integration.jboss5;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.DialectFactory;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.jboss.identity.idm.api.IdentitySessionFactory;
import org.jboss.identity.idm.api.cfg.IdentityConfiguration;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.common.transaction.TransactionManagerProvider;
import org.jboss.identity.idm.common.transaction.Transactions;
import org.jboss.identity.idm.impl.configuration.IdentityConfigurationImpl;
import org.jboss.identity.idm.integration.jboss5.IDMServiceMBean;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.common.util.CLResourceLoader;
import org.jboss.portal.common.util.LoaderResource;

public class IDMService
implements IDMServiceMBean {
    public static final String DEFAULT_JNDI = "java:/IdentitySessionFactory";
    private static Logger logger = Logger.getLogger(IDMService.class.getName());
    private static final int RESULT_NONE = 0;
    private static final int RESULT_UPDATE = 1;
    private static final int RESULT_CREATE = 2;
    private String hibernateConfigLocation;
    private String hibernateSessionFactoryRegistryName;
    private String hibernateSessionFactoryJNDIName;
    private String setupLocation;
    private boolean doChecking;
    private String idmConfigFile;
    private String idmSessionFactoryJNDI;
    private String SQLScript;
    private IdentitySessionFactory identitySessionFactory;
    private SessionFactory hibernateSessionFactory;
    private String exitSQL;
    private String datasource;
    private String objectName;
    private MBeanServer mbeanServer;
    protected Configuration config;

    public IDMService(String idmConfigFile, MBeanServer mbeanServer) {
        this.idmConfigFile = idmConfigFile;
        this.mbeanServer = mbeanServer;
        this.idmSessionFactoryJNDI = DEFAULT_JNDI;
        this.objectName = "org.jboss.identity.idm:service=IDMService";
    }

    public String getIdmConfigFile() {
        return this.idmConfigFile;
    }

    public String getIdmSessionFactoryJNDI() {
        return this.idmSessionFactoryJNDI;
    }

    public String getSQLScript() {
        return this.SQLScript;
    }

    public void setIdmSessionFactoryJNDI(String idmSessionFactoryJNDI) {
        this.idmSessionFactoryJNDI = idmSessionFactoryJNDI;
    }

    public void setSQLScript(String script) {
        this.SQLScript = script;
    }

    public String getHibernateConfigLocation() {
        return this.hibernateConfigLocation;
    }

    public void setHibernateConfigLocation(String hibernateConfigLocation) {
        this.hibernateConfigLocation = hibernateConfigLocation;
    }

    public String getSetupLocation() {
        return this.setupLocation;
    }

    public void setSetupLocation(String setupLocation) {
        this.setupLocation = setupLocation;
    }

    public boolean isDoChecking() {
        return this.doChecking;
    }

    public void setDoChecking(boolean doChecking) {
        this.doChecking = doChecking;
    }

    public String getHibernateSessionFactoryRegistryName() {
        return this.hibernateSessionFactoryRegistryName;
    }

    public void setHibernateSessionFactoryRegistryName(String hibernateSessionFactoryRegistryName) {
        this.hibernateSessionFactoryRegistryName = hibernateSessionFactoryRegistryName;
    }

    public String getHibernateSessionFactoryJNDIName() {
        return this.hibernateSessionFactoryJNDIName;
    }

    public void setHibernateSessionFactoryJNDIName(String hibernateSessionFactoryJNDIName) {
        this.hibernateSessionFactoryJNDIName = hibernateSessionFactoryJNDIName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void start() throws Exception {
        logger.info("Starting the JBoss Identity Management Service");
        if (this.needToInitializeDBFromScript()) {
            this.initializeDBFromScript();
        }
        InitialContext context = new InitialContext();
        final IdentityConfiguration identityConfiguration = new IdentityConfigurationImpl().configure(this.getIdmConfigFile());
        if (this.hibernateConfigLocation != null) {
            this.initializeDBFromHibernateConfiguration(context, identityConfiguration);
        }
        try {
            TransactionManager tm = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
            Transactions.required((TransactionManager)tm, (Transactions.Runnable)new Transactions.Runnable(){

                public Object run() throws Exception {
                    IDMService.this.identitySessionFactory = identityConfiguration.buildIdentitySessionFactory();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new Exception("Cannot create IdentitySessionFactory", e);
        }
        context.bind(this.getIdmSessionFactoryJNDI(), (Object)this.identitySessionFactory);
        this.mbeanServer.registerMBean(this, ObjectNameFactory.create((String)this.getObjectName()));
        logger.info("Started the JBoss Identity Management Service");
    }

    private void initializeDBFromHibernateConfiguration(InitialContext context, IdentityConfiguration identityConfiguration) throws Exception, IdentityException {
        int check = 0;
        URL configURL = Thread.currentThread().getContextClassLoader().getResource(this.hibernateConfigLocation);
        if (configURL == null) {
            throw new Exception("The config " + this.hibernateConfigLocation + " does not exist");
        }
        if (!URLTools.exists((URL)configURL)) {
            throw new Exception("The config " + configURL + " does not exist");
        }
        this.config = new AnnotationConfiguration().configure(configURL);
        this.createHibernateSessionFactory();
        if (this.getHibernateSessionFactoryJNDIName() != null) {
            try {
                context.bind(this.getHibernateSessionFactoryJNDIName(), (Object)this.hibernateSessionFactory);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        if (this.getHibernateSessionFactoryRegistryName() != null) {
            identityConfiguration.getIdentityConfigurationRegistry().register((Object)this.hibernateSessionFactory, this.getHibernateSessionFactoryRegistryName());
        }
        if (this.doChecking) {
            check = this.doCheck();
            switch (check) {
                case 0: {
                    break;
                }
                case 1: {
                    this.updateSchema();
                    break;
                }
                case 2: {
                    this.createSchema();
                    this.createContent();
                }
            }
        }
    }

    public void stop() throws Exception {
        logger.info("Stopping the JBoss Identity Management Service");
    }

    public void destroy() throws Exception {
        InitialContext context = new InitialContext();
        try {
            if (this.identitySessionFactory != null) {
                this.identitySessionFactory.close();
                if (this.getIdmSessionFactoryJNDI() != null) {
                    context.unbind(this.getIdmSessionFactoryJNDI());
                }
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            e.printStackTrace();
        }
        if (this.hibernateSessionFactory != null) {
            try {
                if (this.getHibernateSessionFactoryJNDIName() != null) {
                    context.unbind(this.getHibernateSessionFactoryJNDIName());
                }
                this.hibernateSessionFactory.close();
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
                e.printStackTrace();
            }
        }
        this.mbeanServer.unregisterMBean(ObjectNameFactory.create((String)this.getObjectName()));
        logger.info("Stopped the JBoss Identity Management Service");
    }

    public String getExitSQL() {
        return this.exitSQL;
    }

    public void setExitSQL(String exitSQL) {
        this.exitSQL = exitSQL;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    private boolean needToInitializeDBFromScript() {
        return this.getDatasource() != null && this.getSQLScript() != null && this.getExitSQL() != null;
    }

    private void initializeDBFromScript() throws Exception {
        String[] list;
        DataSource ds = (DataSource)new InitialContext().lookup(this.datasource);
        Connection conn = ds.getConnection();
        boolean load = false;
        Statement st = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(this.exitSQL.trim());
            rs.close();
        }
        catch (SQLException e) {
            load = true;
        }
        st.close();
        if (!load) {
            logger.info(this.datasource + " datasource is already initialized");
            return;
        }
        logger.info("Initializing " + this.datasource + " from listed sql files");
        for (String sql : list = this.SQLScript.split(",")) {
            this.executeSql(sql.trim(), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(String resource, Connection conn) throws Exception {
        String[] statements;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        String sql = new String(this.readStream(url.openStream()), "UTF-8");
        sql = sql.replaceAll("(?m)^SessionFactory --([^\n]+)?$", "");
        for (String statement : statements = sql.split(";")) {
            if (statement == null || "".equals(statement.trim())) continue;
            Statement sqlStatement = conn.createStatement();
            try {
                sqlStatement.executeUpdate(statement);
            }
            finally {
                sqlStatement.close();
            }
        }
    }

    private byte[] readStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("null 'stream' arg passed in method call.");
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int readCount = 0;
        try {
            while ((readCount = stream.read(buffer)) != -1) {
                outBuffer.write(buffer, 0, readCount);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading stream.", e);
        }
        return outBuffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHibernateSessionFactory() throws Exception {
        String dialectName;
        if (this.getHibernateSessionFactoryJNDIName() != null) {
            this.setPropertyIfAbsent("hibernate.session_factory_name", this.getHibernateSessionFactoryJNDIName());
        }
        if ((dialectName = this.config.getProperty("hibernate.dialect")) == null) {
            String dataSourceJNDI = this.config.getProperty("hibernate.connection.datasource");
            logger.fine("Detecting dialect with datasource " + dataSourceJNDI + " ...");
            DataSource ds = (DataSource)new InitialContext().lookup(dataSourceJNDI);
            Connection conn = null;
            try {
                conn = ds.getConnection();
                DatabaseMetaData meta = conn.getMetaData();
                String databaseName = meta.getDatabaseProductName();
                int databaseMajorVersion = this.getDatabaseMajorVersion(meta);
                dialectName = DialectFactory.determineDialect((String)databaseName, (int)databaseMajorVersion).getClass().getName();
                this.config.setProperty("hibernate.dialect", dialectName);
                logger.fine("Detected dialect " + dialectName + ", database is (" + databaseName + "," + databaseMajorVersion + ")");
            }
            finally {
                IOTools.safeClose((Object)conn);
            }
        }
        logger.fine("Using dialect " + dialectName);
        if ("org.hibernate.dialect.HSQLDialect".equals(dialectName)) {
            logger.info("You are using the file based HSQL database, this is not recommended on a production environment and will not work properly on a clustered environment.");
        }
        this.hibernateSessionFactory = this.config.buildSessionFactory();
    }

    private void setPropertyIfAbsent(String name, String value) {
        if (this.config.getProperty(name) == null) {
            this.config.setProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCheck() {
        Session session = null;
        int numOfChecks = 0;
        int bad = 0;
        try {
            session = this.hibernateSessionFactory.openSession();
            Collection values = this.hibernateSessionFactory.getAllClassMetadata().values();
            numOfChecks = values.size();
            for (ClassMetadata cmd : values) {
                Query query = session.createQuery("from " + cmd.getEntityName());
                query.setFirstResult(0);
                query.setMaxResults(0);
                try {
                    query.list();
                }
                catch (SQLGrammarException e) {
                    ++bad;
                }
            }
        }
        finally {
            IOTools.safeClose((Object)session);
        }
        if (bad == 0) {
            logger.fine("The schema was checked as valid");
            return 0;
        }
        if (bad == numOfChecks) {
            logger.fine("The schema was checked as not exists");
            return 2;
        }
        if (bad < numOfChecks) {
            logger.fine("The schema was checked as need updates");
            return 1;
        }
        logger.fine("The schema was checked as need to be created");
        return 2;
    }

    private void createSchema() {
        logger.fine("Creating database schema");
        try {
            SchemaExport export = new SchemaExport(this.config);
            export.create(false, true);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot create schema:", e);
        }
    }

    private void destroySchema() {
        logger.fine("Destroying database schema");
        try {
            SchemaExport export = new SchemaExport(this.config);
            export.drop(false, true);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot destroy schema:", e);
        }
    }

    private void createContent() {
        LoaderResource setupResource = null;
        if (this.setupLocation != null && setupResource == null) {
            setupResource = new CLResourceLoader().getResource(this.setupLocation);
        }
        if (setupResource != null) {
            if (setupResource.exists()) {
                try {
                    logger.info("Creating database content");
                    final String script = setupResource.asString("UTF-8");
                    final Interpreter interpreter = new Interpreter();
                    interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
                    interpreter.setOut(System.out);
                    interpreter.set("SessionFactory", (Object)this.hibernateSessionFactory);
                    TransactionManager tm = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
                    Transactions.required((TransactionManager)tm, (Transactions.Runnable)new Transactions.Runnable(){

                        public Object run() throws Exception {
                            interpreter.eval(script);
                            return null;
                        }
                    });
                }
                catch (EvalError e) {
                    logger.log(Level.SEVERE, "Error in the bsh script:", e);
                }
                catch (IllegalStateException e) {
                    logger.log(Level.SEVERE, "Error in the bsh script:", e);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in the bsh script:", e);
                }
            } else {
                logger.info("There is a setup URL but the not valid " + setupResource);
            }
        }
    }

    private void updateSchema() {
        logger.info("Updating database schema");
        SchemaUpdate update = new SchemaUpdate(this.config);
        update.execute(false, true);
    }

    private int getDatabaseMajorVersion(DatabaseMetaData meta) {
        try {
            Method gdbmvMethod = DatabaseMetaData.class.getMethod("getDatabaseMajorVersion", null);
            return (Integer)gdbmvMethod.invoke((Object)meta, null);
        }
        catch (NoSuchMethodException nsme) {
            return 0;
        }
        catch (Throwable t) {
            logger.info("could not get database version from JDBC metadata");
            return 0;
        }
    }
}

