/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentitySearchCriteria;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.query.QueryException;
import org.jboss.identity.idm.impl.NotYetImplementedException;
import org.jboss.identity.idm.impl.api.IdentitySearchCriteriaImpl;
import org.jboss.identity.idm.impl.api.query.AbstractQueryExecutor;
import org.jboss.identity.idm.impl.api.query.GroupQueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupQueryExecutorImpl
extends AbstractQueryExecutor
implements Serializable {
    private static final long serialVersionUID = -6202216015171375769L;

    public GroupQueryExecutorImpl(IdentitySession identitySession) {
        super(identitySession);
    }

    public Collection<Group> execute(GroupQueryImpl q) throws QueryException {
        LinkedList<Group> mainResults = new LinkedList<Group>();
        try {
            Group uniqueResult = null;
            LinkedList<Group> resultsAssociatedParentGroups = new LinkedList<Group>();
            LinkedList<Group> resultsAssociatedChildGroups = new LinkedList<Group>();
            LinkedList<Group> resultsUsersAssociated = new LinkedList<Group>();
            LinkedList<Group> resultsUsersRelated = new LinkedList<Group>();
            LinkedList<Group> resultsUsersConnectedByRole = new LinkedList<Group>();
            if (q.groupId == null && q.groupName == null && q.groupType == null && q.associatedParentGroups.size() == 0 && q.associatedChildGroups.size() == 0 && q.usersAssociated.size() == 0 && q.usersConnectedByRole.size() == 0 && q.usersRelated.size() == 0) {
                throw new QueryException("Not enought information to perform a query. Cannot query groups without at least group type");
            }
            if (q.groupId != null) {
                uniqueResult = this.identitySession.getPersistenceManager().findGroup(q.groupId.getName(), q.groupId.getType());
            }
            if (q.associatedParentGroups.size() > 0) {
                for (Group group : q.associatedParentGroups) {
                    this.addAllPreservingDuplicates(resultsAssociatedParentGroups, this.identitySession.getRelationshipManager().findAssociatedGroups(group, q.groupType, true, false, (IdentitySearchCriteria)q.searchCriteria));
                }
            }
            if (q.associatedChildGroups.size() > 0) {
                for (Group group : q.associatedChildGroups) {
                    this.addAllPreservingDuplicates(resultsAssociatedChildGroups, this.identitySession.getRelationshipManager().findAssociatedGroups(group, q.groupType, false, false, (IdentitySearchCriteria)q.searchCriteria));
                }
            }
            if (q.usersAssociated.size() > 0) {
                for (User user : q.usersAssociated) {
                    this.addAllPreservingDuplicates(resultsUsersAssociated, this.identitySession.getRelationshipManager().findAssociatedGroups(user, q.groupType, (IdentitySearchCriteria)q.searchCriteria));
                }
            }
            if (q.usersRelated.size() > 0) {
                for (User user : q.usersRelated) {
                    this.addAllPreservingDuplicates(resultsUsersRelated, this.identitySession.getRelationshipManager().findRelatedGroups(user, q.groupType, (IdentitySearchCriteria)q.searchCriteria));
                }
            }
            if (q.usersConnectedByRole.size() > 0) {
                for (User user : q.usersConnectedByRole) {
                    this.addAllPreservingDuplicates(resultsUsersConnectedByRole, this.identitySession.getRoleManager().findGroupsWithRelatedRole(user, q.groupType, (IdentitySearchCriteria)q.searchCriteria));
                }
            }
            if (q.groupId == null && uniqueResult == null && q.associatedChildGroups.size() == 0 && resultsAssociatedChildGroups.size() == 0 && q.associatedParentGroups.size() == 0 && resultsAssociatedParentGroups.size() == 0 && q.usersAssociated.size() == 0 && resultsUsersAssociated.size() == 0 && q.usersConnectedByRole.size() == 0 && resultsUsersConnectedByRole.size() == 0 && q.usersRelated.size() == 0 && resultsUsersRelated.size() == 0) {
                return mainResults;
            }
            if (q.groupId != null && uniqueResult != null && q.associatedChildGroups.size() == 0 && resultsAssociatedChildGroups.size() == 0 && q.associatedParentGroups.size() == 0 && resultsAssociatedParentGroups.size() == 0 && q.usersAssociated.size() == 0 && resultsUsersAssociated.size() == 0 && q.usersConnectedByRole.size() == 0 && resultsUsersConnectedByRole.size() == 0 && q.usersRelated.size() == 0 && resultsUsersRelated.size() == 0) {
                mainResults.add(uniqueResult);
                IdentitySearchCriteriaImpl.applyCriteria(this.identitySession, q.searchCriteria, mainResults);
                return mainResults;
            }
            if (q.groupId == null && uniqueResult == null && q.associatedChildGroups.size() != 0 && resultsAssociatedChildGroups.size() != 0 && q.associatedParentGroups.size() == 0 && resultsAssociatedParentGroups.size() == 0 && q.usersAssociated.size() == 0 && resultsUsersAssociated.size() == 0 && q.usersConnectedByRole.size() == 0 && resultsUsersConnectedByRole.size() == 0 && q.usersRelated.size() == 0 && resultsUsersRelated.size() == 0) {
                return resultsAssociatedChildGroups;
            }
            if (q.groupId == null && uniqueResult == null && q.associatedChildGroups.size() == 0 && resultsAssociatedChildGroups.size() == 0 && q.associatedParentGroups.size() != 0 && resultsAssociatedParentGroups.size() != 0 && q.usersAssociated.size() == 0 && resultsUsersAssociated.size() == 0 && q.usersConnectedByRole.size() == 0 && resultsUsersConnectedByRole.size() == 0 && q.usersRelated.size() == 0 && resultsUsersRelated.size() == 0) {
                return resultsAssociatedParentGroups;
            }
            if (q.groupId == null && uniqueResult == null && q.associatedChildGroups.size() == 0 && resultsAssociatedChildGroups.size() == 0 && q.associatedParentGroups.size() == 0 && resultsAssociatedParentGroups.size() == 0 && q.usersAssociated.size() != 0 && resultsUsersAssociated.size() != 0 && q.usersConnectedByRole.size() == 0 && resultsUsersConnectedByRole.size() == 0 && q.usersRelated.size() == 0 && resultsUsersRelated.size() == 0) {
                return resultsUsersAssociated;
            }
            if (q.groupId == null && uniqueResult == null && q.associatedChildGroups.size() == 0 && resultsAssociatedChildGroups.size() == 0 && q.associatedParentGroups.size() == 0 && resultsAssociatedParentGroups.size() == 0 && q.usersAssociated.size() == 0 && resultsUsersAssociated.size() == 0 && q.usersConnectedByRole.size() != 0 && resultsUsersConnectedByRole.size() != 0 && q.usersRelated.size() == 0 && resultsUsersRelated.size() == 0) {
                return resultsUsersConnectedByRole;
            }
            if (q.groupId == null && uniqueResult == null && q.associatedChildGroups.size() == 0 && resultsAssociatedChildGroups.size() == 0 && q.associatedParentGroups.size() == 0 && resultsAssociatedParentGroups.size() == 0 && q.usersAssociated.size() == 0 && resultsUsersAssociated.size() == 0 && q.usersConnectedByRole.size() == 0 && resultsUsersConnectedByRole.size() == 0 && q.usersRelated.size() != 0 && resultsUsersRelated.size() != 0) {
                return resultsUsersRelated;
            }
            boolean first = true;
            if (q.groupId != null) {
                first = false;
                mainResults.add(uniqueResult);
            }
            if (q.associatedChildGroups.size() > 0) {
                if (first) {
                    first = false;
                    mainResults = resultsAssociatedChildGroups;
                } else {
                    mainResults = this.mergeIdentityTypeWithAND(mainResults, resultsAssociatedChildGroups);
                }
            }
            if (q.associatedParentGroups.size() > 0) {
                if (first) {
                    first = false;
                    mainResults = resultsAssociatedParentGroups;
                } else {
                    mainResults = this.mergeIdentityTypeWithAND(mainResults, resultsAssociatedParentGroups);
                }
            }
            if (q.usersAssociated.size() > 0) {
                if (first) {
                    first = false;
                    mainResults = resultsUsersAssociated;
                } else {
                    mainResults = this.mergeIdentityTypeWithAND(mainResults, resultsUsersAssociated);
                }
            }
            if (q.usersConnectedByRole.size() > 0) {
                if (first) {
                    first = false;
                    mainResults = resultsUsersConnectedByRole;
                } else {
                    mainResults = this.mergeIdentityTypeWithAND(mainResults, resultsUsersConnectedByRole);
                }
            }
            if (q.usersRelated.size() > 0) {
                if (first) {
                    first = false;
                    mainResults = resultsUsersRelated;
                } else {
                    mainResults = this.mergeIdentityTypeWithAND(mainResults, resultsUsersRelated);
                }
            }
            IdentitySearchCriteriaImpl.applyCriteria(this.identitySession, q.searchCriteria, mainResults);
        }
        catch (Exception e) {
            throw new QueryException("Failed to execute query", e);
        }
        return mainResults;
    }

    public Group uniqueResult(GroupQueryImpl groupQuery) throws QueryException {
        Collection<Group> results = this.execute(groupQuery);
        if (results.size() > 1) {
            throw new QueryException("More than one result returned");
        }
        if (results.size() == 1) {
            return results.iterator().next();
        }
        return null;
    }

    public List<Group> list(GroupQueryImpl groupQuery) throws QueryException {
        Collection<Group> results = this.execute(groupQuery);
        if (results instanceof List) {
            return (List)results;
        }
        throw new NotYetImplementedException();
    }
}

