/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.cache;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.identity.idm.spi.cache.IdentityStoreCacheProvider;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.search.IdentityObjectSearchCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityStoreCacheProviderImpl
implements IdentityStoreCacheProvider {
    private static Logger log = Logger.getLogger(IdentityStoreCacheProvider.class.getName());
    public static final String JBID_ROOT_NODE = "/jboss_id_idm";
    public static final String OBJECT_TYPES_NODE = "/jboss_id_idm/object_types";
    public static final String OBJECT_TYPES_IDS_NODE = "/jboss_id_idm/object_types/by_ids";
    public static final String OBJECT_TYPES_NAMES_NODE = "/jboss_id_idm/object_types/by_names";
    public static final String OBJECT_TYPES_SEARCH_BY_TYPE_NODE = "/jboss_id_idm/object_types/search_by_type";
    public static final String OBJECT_TYPES_SEARCH_NODE = "/jboss_id_idm/object_types/search";
    public static final String OBJECT_TYPES_COUNT_NODE = "/jboss_id_idm/object_types/count";
    public static final String RELATIONSHIPS_SEARCH_NODE = "/jboss_id_idm/relationship_types_names";
    public static final String RELATIONSHIPS_SEARCH_SIMPLE_NODE = "/jboss_id_idm/relationship_types_names/simple";
    public static final String RELATIONSHIPS_SEARCH_COMPLEX_NODE = "/jboss_id_idm/relationship_types_names/complex";
    public static final String RELATIONSHIP_NAMES_SEARCH_NODE = "/jboss_id_idm/relationship_names_search";
    public static final String RELATIONSHIP_NAMES_SEARCH_IO_NODE = "/jboss_id_idm/relationship_names_search/identity_object";
    public static final String RELATIONSHIP_NAMES_SEARCH_ALL_NODE = "/jboss_id_idm/relationship_names_search/all";
    public static final String NODE_OBJECT_KEY = "object";
    public static final String NODE_ATTRIBUTES_KEY = "attributes";
    public static final String NODE_REL_NAME_KEY = "relationship_name";
    public static final String NODE_REL_TYPE_KEY = "relationship_type";
    public static final String NODE_REL_FROM_KEY = "relationship_from";
    public static final String NODE_REL_TO_KEY = "relationship_to";
    public static final String NODE_SEARCH_RESULTS_KEY = "search_results";
    public static final Fqn FQN_OBJECT_TYPES = Fqn.fromString((String)"/jboss_id_idm/object_types");
    public static final Fqn FQN_OBJECT_TYPES_NAMES = Fqn.fromString((String)"/jboss_id_idm/object_types/by_names");
    public static final Fqn FQN_OBJECT_TYPES_IDS = Fqn.fromString((String)"/jboss_id_idm/object_types/by_ids");
    public static final Fqn FQN_OBJECT_TYPES_SEARCH_BY_TYPE = Fqn.fromString((String)"/jboss_id_idm/object_types/search_by_type");
    public static final Fqn FQN_OBJECT_TYPES_SEARCH = Fqn.fromString((String)"/jboss_id_idm/object_types/search");
    public static final Fqn FQN_OBJECT_TYPES_COUNT = Fqn.fromString((String)"/jboss_id_idm/object_types/count");
    public static final Fqn FQN_RELATIONSHIPS = Fqn.fromString((String)"/jboss_id_idm/relationship_types_names");
    public static final Fqn FQN_RELATIONSHIPS_COMPLEX = Fqn.fromString((String)"/jboss_id_idm/relationship_types_names/complex");
    public static final Fqn FQN_RELATIONSHIPS_SIMPLE = Fqn.fromString((String)"/jboss_id_idm/relationship_types_names/simple");
    protected final Cache cache;

    public IdentityStoreCacheProviderImpl(InputStream cacheConfigInputStream) {
        DefaultCacheFactory factory = new DefaultCacheFactory();
        this.cache = factory.createCache(cacheConfigInputStream);
        this.cache.start();
    }

    private Fqn createIONameNodeFQN(String ioTypeName, String ioName) {
        return Fqn.fromElements((Object[])new String[]{OBJECT_TYPES_NAMES_NODE, ioTypeName, ioName});
    }

    private Fqn createIONameNodeFQN(IdentityObject io) {
        return Fqn.fromElements((Object[])new String[]{OBJECT_TYPES_NAMES_NODE, io.getIdentityType().getName(), io.getName()});
    }

    private Fqn createIOIdNodeFQN(IdentityObject io) {
        return Fqn.fromElements((Object[])new String[]{OBJECT_TYPES_IDS_NODE, io.getIdentityType().getName(), io.getId()});
    }

    private Fqn createIOTypeCountNodeFQN(IdentityObjectType iot) {
        return Fqn.fromElements((Object[])new String[]{OBJECT_TYPES_COUNT_NODE, iot.getName()});
    }

    private Fqn createIOTypeSearchNodeFQN(IdentityObjectType iot, Object searchId) {
        return Fqn.fromElements((Object[])new Object[]{OBJECT_TYPES_SEARCH_BY_TYPE_NODE, iot.getName(), searchId});
    }

    private Fqn createIOSearchNodeFQN(IdentityObject io, IdentityObjectRelationshipType relationshipType, boolean parent, Object searchId) {
        return Fqn.fromElements((Object[])new Object[]{OBJECT_TYPES_SEARCH_NODE, io.getIdentityType().getName(), relationshipType == null ? "null" : relationshipType.getName(), io.getName() + "_" + parent, searchId});
    }

    private Fqn createRelationshipNamesIdentityObjectSearchFqn(IdentityObject identityObject, Object searchId) {
        return Fqn.fromElements((Object[])new Object[]{RELATIONSHIP_NAMES_SEARCH_IO_NODE, identityObject.getIdentityType() + "_" + identityObject.getName(), searchId});
    }

    private Fqn createRelationshipNamesAllSearchFqn(Object searchId) {
        return Fqn.fromElements((Object[])new Object[]{RELATIONSHIP_NAMES_SEARCH_ALL_NODE, searchId});
    }

    private Fqn createRelationshipsSimpleSearchFqn(IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) {
        return Fqn.fromElements((Object[])new Object[]{RELATIONSHIPS_SEARCH_SIMPLE_NODE, fromIdentity.getIdentityType().getName() + "_" + toIdentity.getName(), toIdentity.getIdentityType().getName() + "_" + toIdentity.getName(), relationshipType == null ? "null" : relationshipType});
    }

    private Fqn createRelationshipsComplexSearchFqn(IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name) {
        return Fqn.fromElements((Object[])new Object[]{RELATIONSHIPS_SEARCH_COMPLEX_NODE, identity.getIdentityType().getName() + "_" + identity.getName(), parent, relationshipType, named + "_" + name});
    }

    public static boolean isSchemaFqn(Fqn fqn) {
        return fqn.equals((Object)JBID_ROOT_NODE) || fqn.equals((Object)OBJECT_TYPES_NODE) || fqn.equals((Object)OBJECT_TYPES_IDS_NODE) || fqn.equals((Object)OBJECT_TYPES_NAMES_NODE) || fqn.equals((Object)RELATIONSHIPS_SEARCH_NODE);
    }

    public static boolean isFqnObjectTypeChild(Fqn fqn) {
        return fqn.isChildOf(FQN_OBJECT_TYPES);
    }

    public static boolean isFqnObjectTypeIdsChild(Fqn fqn) {
        return fqn.isChildOf(FQN_OBJECT_TYPES_IDS);
    }

    public static boolean isFqnObjectTypeNamesChild(Fqn fqn) {
        return fqn.isChildOf(FQN_OBJECT_TYPES_NAMES);
    }

    public static boolean isFqnObjectTypeSearchChild(Fqn fqn) {
        return fqn.isChildOf(FQN_OBJECT_TYPES_SEARCH_BY_TYPE);
    }

    public static boolean isFqnRelationshipsChild(Fqn fqn) {
        return fqn.isChildOf(FQN_RELATIONSHIPS);
    }

    private void removeNodeChildren(String path) {
        Fqn fqn = Fqn.fromString((String)path);
        Node node = this.getCache().getRoot().getChild(fqn);
        if (node != null) {
            Set names = node.getChildrenNames();
            for (Object name : names) {
                node.removeChild(name);
            }
        }
    }

    protected Logger getLog() {
        return log;
    }

    protected Cache getCache() {
        return this.cache;
    }

    @Override
    public void initResidentNodes(Set<String> supportedIdentityObjectTypes, Set<String> supportedRelationshipTypes) {
        this.getCache().getRoot().addChild(Fqn.fromString((String)JBID_ROOT_NODE)).setResident(true);
        this.getCache().getRoot().addChild(Fqn.fromString((String)OBJECT_TYPES_NODE)).setResident(true);
        this.getCache().getRoot().addChild(FQN_OBJECT_TYPES_IDS).setResident(true);
        this.getCache().getRoot().addChild(FQN_OBJECT_TYPES_NAMES).setResident(true);
        this.getCache().getRoot().addChild(FQN_OBJECT_TYPES_SEARCH).setResident(true);
        this.getCache().getRoot().addChild(FQN_OBJECT_TYPES_SEARCH_BY_TYPE).setResident(true);
        this.getCache().getRoot().addChild(FQN_OBJECT_TYPES_COUNT).setResident(true);
        this.getCache().getRoot().addChild(Fqn.fromString((String)RELATIONSHIP_NAMES_SEARCH_ALL_NODE)).setResident(true);
        this.getCache().getRoot().addChild(Fqn.fromString((String)RELATIONSHIP_NAMES_SEARCH_IO_NODE)).setResident(true);
        this.getCache().getRoot().addChild(Fqn.fromString((String)RELATIONSHIPS_SEARCH_COMPLEX_NODE)).setResident(true);
        this.getCache().getRoot().addChild(Fqn.fromString((String)RELATIONSHIPS_SEARCH_SIMPLE_NODE)).setResident(true);
        for (String objectTypeName : supportedIdentityObjectTypes) {
            Fqn nodeFqn = Fqn.fromRelativeElements((Fqn)FQN_OBJECT_TYPES_NAMES, (Object[])new String[]{"/" + objectTypeName});
            this.getCache().getRoot().addChild(nodeFqn).setResident(true);
            nodeFqn = Fqn.fromRelativeElements((Fqn)FQN_OBJECT_TYPES_IDS, (Object[])new String[]{"/" + objectTypeName});
            this.getCache().getRoot().addChild(nodeFqn).setResident(true);
        }
    }

    @Override
    public void putIntoCache(IdentityObject io) {
        Fqn nodeFqn = this.createIONameNodeFQN(io);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (!ioNode.getKeys().contains(NODE_OBJECT_KEY)) {
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)io);
        }
        nodeFqn = this.createIOIdNodeFQN(io);
        ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (!ioNode.getKeys().contains(NODE_OBJECT_KEY)) {
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)io);
        }
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObject stored in cache: " + io.getName() + "; " + io.getId());
        }
    }

    @Override
    public void putIntoCache(IdentityObject io, Map<String, IdentityObjectAttribute> attributesMap) {
        Fqn nodeFqn = this.createIONameNodeFQN(io);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (!ioNode.getKeys().contains(NODE_OBJECT_KEY)) {
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)io);
        }
        if (!ioNode.getKeys().contains(NODE_ATTRIBUTES_KEY)) {
            ioNode.put((Object)NODE_ATTRIBUTES_KEY, attributesMap);
        }
        nodeFqn = this.createIOIdNodeFQN(io);
        ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (!ioNode.getKeys().contains(NODE_OBJECT_KEY)) {
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)io);
        }
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObject stored in cache with attributes map: " + io.getName() + "; " + io.getId() + "; type=" + io.getIdentityType().getName());
        }
    }

    @Override
    public void removeFromCache(IdentityObject io) {
        Fqn nodeFqn = this.createIONameNodeFQN(io);
        this.getCache().getRoot().removeChild(nodeFqn);
        nodeFqn = this.createIOIdNodeFQN(io);
        this.getCache().getRoot().removeChild(nodeFqn);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObject removed from cache: " + io.getName() + "; " + io.getId() + "; type=" + io.getIdentityType().getName());
        }
    }

    @Override
    public void removeAttributesFromCache(IdentityObject io) {
        Fqn nodeFqn = this.createIONameNodeFQN(io);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        ioNode.remove((Object)NODE_ATTRIBUTES_KEY);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObject attributes removed from cache: name=" + io.getName() + "; id=" + io.getId() + "; type=" + io.getIdentityType().getName());
        }
    }

    @Override
    public IdentityObject getFromCache(String name, IdentityObjectType identityObjectType) {
        Fqn nodeFqn = Fqn.fromElements((Object[])new String[]{OBJECT_TYPES_NODE, identityObjectType.getName(), name});
        Node ioNode = this.getCache().getRoot().getChild(nodeFqn);
        if (ioNode != null) {
            IdentityObject io = (IdentityObject)ioNode.get((Object)NODE_OBJECT_KEY);
            if (this.getLog().isLoggable(Level.FINER)) {
                this.getLog().finer(this.toString() + "IdentityObject found in cache: name=" + io.getName() + "; id=" + io.getId());
            }
            return io;
        }
        return null;
    }

    @Override
    public Map<String, IdentityObjectAttribute> getAttributesFromCache(String name, IdentityObjectType identityObjectType) {
        Fqn nodeFqn = Fqn.fromElements((Object[])new String[]{OBJECT_TYPES_NODE, identityObjectType.getName(), name});
        Node ioNode = this.getCache().getRoot().getChild(nodeFqn);
        if (ioNode != null) {
            Map attrs = (Map)ioNode.get((Object)NODE_ATTRIBUTES_KEY);
            if (attrs != null && this.getLog().isLoggable(Level.FINER)) {
                this.getLog().finer(this.toString() + "IdentityObject attributes found in cache: name=" + name + "; type=" + identityObjectType.getName());
            }
            return attrs;
        }
        return null;
    }

    @Override
    public IdentityObject getFromCache(String id) {
        Node idsNode = this.getCache().getRoot().getChild((Object)OBJECT_TYPES_IDS_NODE);
        for (Node typeNode : idsNode.getChildren()) {
            for (Object name : typeNode.getChildrenNames()) {
                if (!name.toString().equals(id)) continue;
                IdentityObject io = (IdentityObject)typeNode.getChild(name).get((Object)NODE_OBJECT_KEY);
                if (this.getLog().isLoggable(Level.FINER)) {
                    this.getLog().finer(this.toString() + "IdentityObject found in cache: name" + io.getName() + "; type" + io.getIdentityType().getName());
                }
                return io;
            }
        }
        return null;
    }

    @Override
    public void putIdentityObjectSearchIntoCache(IdentityObjectType identityType, IdentityObjectSearchCriteria criteria, Collection<IdentityObject> results) {
        Fqn nodeFqn = this.createIOTypeSearchNodeFQN(identityType, this.getControlsHash(criteria));
        Node searchNode = this.getCache().getRoot().addChild(nodeFqn);
        searchNode.put((Object)NODE_SEARCH_RESULTS_KEY, results);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObject search results stored in cache: type" + identityType.getName());
        }
    }

    @Override
    public Collection<IdentityObject> getIdentityObjectSearchFromCache(IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) {
        Fqn nodeFqn = this.createIOTypeSearchNodeFQN(identityType, this.getControlsHash(criteria));
        Node searchNode = this.getCache().getRoot().getChild(nodeFqn);
        Collection results = null;
        if (searchNode != null && (results = (Collection)searchNode.get((Object)NODE_SEARCH_RESULTS_KEY)) != null && this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObject search results found in cache: type" + identityType.getName());
        }
        return results;
    }

    @Override
    public void putIdentityObjectSearchToCache(IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria, Collection<IdentityObject> results) {
        Fqn nodeFqn = this.createIOSearchNodeFQN(identity, relationshipType, parent, this.getControlsHash(criteria));
        Node searchNode = this.getCache().getRoot().addChild(nodeFqn);
        searchNode.put((Object)NODE_SEARCH_RESULTS_KEY, results);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObject search results stored in cache: IdentityObject name= " + identity.getName() + "; IdentityObject type= " + identity.getIdentityType().getName() + "; IdentityObjectRelationshipType= " + relationshipType + "; parent= " + parent);
        }
    }

    @Override
    public Collection<IdentityObject> getIdentityObjectSearchFromCache(IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) {
        Fqn nodeFqn = this.createIOSearchNodeFQN(identity, relationshipType, parent, this.getControlsHash(criteria));
        Node searchNode = this.getCache().getRoot().getChild(nodeFqn);
        Collection results = null;
        if (searchNode != null && (results = (Collection)searchNode.get((Object)NODE_SEARCH_RESULTS_KEY)) != null && this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObject search results found in cache: IdentityObject name= " + identity.getName() + "; IdentityObject type= " + identity.getIdentityType().getName() + "; IdentityObjectRelationshipType= " + relationshipType + "; parent= " + parent);
        }
        return results;
    }

    @Override
    public void putRelationshipsSearchIntoCache(IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, Set<IdentityObjectRelationship> results) {
        Fqn fqn = this.createRelationshipsSimpleSearchFqn(fromIdentity, toIdentity, relationshipType);
        Node node = this.getCache().getRoot().addChild(fqn);
        node.put((Object)NODE_SEARCH_RESULTS_KEY, results);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectRelationship search stored in cache: fromIdentity" + fromIdentity.toString() + "; toIdentity=" + toIdentity.toString() + "; relationshipType=" + relationshipType.getName());
        }
    }

    @Override
    public Set<IdentityObjectRelationship> getRelationshipsSearchFromCache(IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) {
        Fqn fqn = this.createRelationshipsSimpleSearchFqn(fromIdentity, toIdentity, relationshipType);
        Node node = this.getCache().getRoot().getChild(fqn);
        if (node != null) {
            if (node.getKeys().contains(NODE_SEARCH_RESULTS_KEY) && this.getLog().isLoggable(Level.FINER)) {
                this.getLog().finer(this.toString() + "IdentityObjectRelationship search found in cache: fromIdentity" + fromIdentity.toString() + "; toIdentity=" + toIdentity.toString() + "; relationshipType=" + relationshipType.getName());
            }
            return (Set)node.get((Object)NODE_SEARCH_RESULTS_KEY);
        }
        return null;
    }

    @Override
    public void putRelationshipSearchIntoCache(IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name, Set<IdentityObjectRelationship> results) {
        Fqn fqn = this.createRelationshipsComplexSearchFqn(identity, relationshipType, parent, named, name);
        Node node = this.getCache().getRoot().addChild(fqn);
        node.put((Object)NODE_SEARCH_RESULTS_KEY, results);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectRelationship search stored in cache: " + "identity" + identity.toString() + "; relationshipType=" + relationshipType.getName() + "; parent=" + parent + "; named=" + named + "; name=" + name);
        }
    }

    @Override
    public Set<IdentityObjectRelationship> getRelationshipsSearchFromCache(IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name) {
        Fqn fqn = this.createRelationshipsComplexSearchFqn(identity, relationshipType, parent, named, name);
        Node node = this.getCache().getRoot().getChild(fqn);
        Set results = null;
        if (node != null && (results = (Set)node.get((Object)NODE_SEARCH_RESULTS_KEY)) != null && this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectRelationship search found in cache: " + "identity" + identity.toString() + "; relationshipType=" + relationshipType.getName() + "; parent=" + parent + "; named=" + named + "; name=" + name);
        }
        return results;
    }

    @Override
    public void invalidateCachedIdentityObjectSearches(IdentityObject io) {
        Fqn fqn = Fqn.fromElements((Object[])new String[]{OBJECT_TYPES_SEARCH_BY_TYPE_NODE, io.getIdentityType().getName()});
        this.getCache().getRoot().removeChild(fqn);
        this.removeNodeChildren(OBJECT_TYPES_SEARCH_NODE);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObject searches invalidated in cache: identityObject=" + io.toString());
        }
    }

    @Override
    public void putIdentityObjectCountIntoCache(IdentityObjectType identityType, int count) {
        Fqn fqn = this.createIOTypeCountNodeFQN(identityType);
        Node node = this.getCache().getRoot().addChild(fqn);
        node.put((Object)NODE_OBJECT_KEY, (Object)count);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectType count search strored in cache: " + "identityObjectType=" + identityType.getName() + "; count=" + count);
        }
    }

    @Override
    public int getIdentityObjectCountFromCache(IdentityObjectType identityType) {
        Fqn fqn = this.createIOTypeCountNodeFQN(identityType);
        Node node = this.getCache().getRoot().getChild(fqn);
        if (node != null && node.getKeys().contains(NODE_OBJECT_KEY)) {
            int count = (Integer)node.get((Object)NODE_OBJECT_KEY);
            if (this.getLog().isLoggable(Level.FINER)) {
                this.getLog().finer(this.toString() + "IdentityObjectType count search result found in cache: " + "identityObjectType=" + identityType.getName() + "; count=" + count);
            }
            return count;
        }
        return -1;
    }

    @Override
    public void invalidateCachedIdentityObjectCount(IdentityObjectType identityType) {
        Fqn fqn = this.createIOTypeCountNodeFQN(identityType);
        Node node = this.getCache().getRoot().addChild(fqn);
        node.remove((Object)NODE_OBJECT_KEY);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectType count search result invalidated in cache: " + "identityObjectType=" + identityType.getName());
        }
    }

    @Override
    public void invalidateCachedRelationshipSearches(IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName) {
        String fromName = fromIdentity.getIdentityType().getName() + "_" + fromIdentity.getName();
        String toName = toIdentity.getIdentityType().getName() + "_" + toIdentity.getName();
        Fqn fqn = this.createRelationshipsSimpleSearchFqn(fromIdentity, toIdentity, relationshipType);
        this.getCache().getRoot().removeChild(fqn);
        String relNameElement = relationshipName != null ? true + relationshipName : false + relationshipName;
        fqn = Fqn.fromElements((Object[])new Serializable[]{RELATIONSHIPS_SEARCH_COMPLEX_NODE, fromName, Boolean.valueOf(true), relationshipType.getName(), relNameElement});
        this.getCache().getRoot().removeChild(fqn);
        fqn = Fqn.fromElements((Object[])new Serializable[]{RELATIONSHIPS_SEARCH_COMPLEX_NODE, toName, Boolean.valueOf(false), relationshipType.getName(), relNameElement});
        this.getCache().getRoot().removeChild(fqn);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectRelationship search result invalidated in cache: fromIdentity" + fromIdentity.toString() + "; toIdentity=" + toIdentity.toString() + "; relationshipType=" + relationshipType.getName());
        }
    }

    @Override
    public void invalidateCachedRelationshipSearches(IdentityObject identity1, IdentityObject identity2, boolean named) {
        String name1 = identity1.getIdentityType().getName() + "_" + identity1.getName();
        String name2 = identity2.getIdentityType().getName() + "_" + identity2.getName();
        Fqn fqn = Fqn.fromElements((Object[])new String[]{RELATIONSHIPS_SEARCH_COMPLEX_NODE, name1});
        this.getCache().getRoot().removeChild(fqn);
        fqn = Fqn.fromElements((Object[])new String[]{RELATIONSHIPS_SEARCH_COMPLEX_NODE, name2});
        this.getCache().getRoot().removeChild(fqn);
        this.getCache().getRoot().removeChild(Fqn.fromElements((Object[])new String[]{RELATIONSHIPS_SEARCH_SIMPLE_NODE, name1}));
        this.getCache().getRoot().removeChild(Fqn.fromElements((Object[])new String[]{RELATIONSHIPS_SEARCH_SIMPLE_NODE, name2}));
        fqn = Fqn.fromElements((Object[])new String[]{RELATIONSHIPS_SEARCH_SIMPLE_NODE});
        Set names = this.getCache().getRoot().getChildrenNames();
        for (String childName : names) {
            this.getCache().getRoot().removeChild(Fqn.fromElements((Object[])new Serializable[]{fqn, childName, name1}));
            this.getCache().getRoot().removeChild(Fqn.fromElements((Object[])new Serializable[]{fqn, childName, name2}));
        }
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectRelationship search result invalidated in cache for: identity1" + identity1.toString() + "; identity2=" + identity2.toString() + "; named=" + named);
        }
    }

    @Override
    public void invalidateRelationshipNameSearches(String name) {
        this.removeNodeChildren(RELATIONSHIP_NAMES_SEARCH_ALL_NODE);
        this.removeNodeChildren(RELATIONSHIP_NAMES_SEARCH_IO_NODE);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectRelationshipName search results invalidated in cache: name" + name);
        }
    }

    @Override
    public void putRelationshipNamesSearchIntoCache(IdentityObjectSearchCriteria criteria, Set<String> results) {
        Fqn fqn = this.createRelationshipNamesAllSearchFqn(this.getControlsHash(criteria));
        Node node = this.getCache().getRoot().addChild(fqn);
        node.put((Object)NODE_SEARCH_RESULTS_KEY, results);
        if (this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectRelationshipName search results invalidated in cache: criteria hash=" + this.getControlsHash(criteria));
        }
    }

    @Override
    public Set<String> getRelationshipNamesSearchFromCache(IdentityObjectSearchCriteria criteria) {
        Fqn fqn = this.createRelationshipNamesAllSearchFqn(this.getControlsHash(criteria));
        Node node = this.getCache().getRoot().getChild(fqn);
        if (node != null) {
            Set results = (Set)node.get((Object)NODE_SEARCH_RESULTS_KEY);
            if (results != null && this.getLog().isLoggable(Level.FINER)) {
                this.getLog().finer(this.toString() + "IdentityObjectRelationshipName search result found in cache: criteria hash=" + this.getControlsHash(criteria));
            }
            return results;
        }
        return null;
    }

    @Override
    public void putRelationshipNamesSearchIntoCache(IdentityObject identity, IdentityObjectSearchCriteria criteria, Set<String> results) {
        Fqn fqn = this.createRelationshipNamesIdentityObjectSearchFqn(identity, this.getControlsHash(criteria));
        Node node = this.getCache().getRoot().addChild(fqn);
        node.put((Object)NODE_SEARCH_RESULTS_KEY, results);
        if (results != null && this.getLog().isLoggable(Level.FINER)) {
            this.getLog().finer(this.toString() + "IdentityObjectRelationshipName search result stored in cache: " + "criteria hash=" + this.getControlsHash(criteria) + "identity=" + identity.toString());
        }
    }

    @Override
    public Set<String> getRelationshipNamesSearchFromCache(IdentityObject identity, IdentityObjectSearchCriteria criteria) {
        Fqn fqn = this.createRelationshipNamesIdentityObjectSearchFqn(identity, this.getControlsHash(criteria));
        Node node = this.getCache().getRoot().getChild(fqn);
        if (node != null) {
            Set results = (Set)node.get((Object)NODE_SEARCH_RESULTS_KEY);
            if (results != null && this.getLog().isLoggable(Level.FINER)) {
                this.getLog().finer(this.toString() + "IdentityObjectRelationshipName search result found in cache: " + "criteria hash=" + this.getControlsHash(criteria) + "identity=" + identity.toString());
            }
            return results;
        }
        return null;
    }

    private int getControlsHash(IdentityObjectSearchCriteria criteria) {
        int hashcode = 0;
        if (criteria != null) {
            hashcode = criteria.hashCode();
        }
        return hashcode;
    }
}

