/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.reveng.dialect.JDBCMetaDataDialect;
import org.hibernate.cfg.reveng.dialect.ResultSetIterator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;

public class H2MetaDataDialect
extends JDBCMetaDataDialect {
    private static boolean understandsCatalogName = true;

    public H2MetaDataDialect() {
        try {
            Class constants = ReflectHelper.classForName((String)"org.h2.engine.Constants");
            Integer build = (Integer)constants.getDeclaredField("BUILD_ID").get(null);
            if (build < 55) {
                understandsCatalogName = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void putTablePart(Map element, ResultSet tableRs) throws SQLException {
        super.putTablePart(element, tableRs);
        if (!understandsCatalogName) {
            element.put("TABLE_CAT", null);
        }
    }

    @Override
    protected void putExportedKeysPart(Map element, ResultSet rs) throws SQLException {
        super.putExportedKeysPart(element, rs);
        if (!understandsCatalogName) {
            element.put("PKTABLE_CAT", null);
        }
    }

    @Override
    public Iterator getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String table) {
        try {
            catalog = this.caseForSearch(catalog);
            schema = this.caseForSearch(schema);
            table = this.caseForSearch(table);
            this.log.debug("geSuggestedPrimaryKeyStrategyName(" + catalog + "." + schema + "." + table + ")");
            String sql = "SELECT idx.TABLE_CATALOG TABLE_CAT, idx.TABLE_SCHEMA TABLE_SCHEM, idx.TABLE_NAME, idx.COLUMN_NAME, cols.COLUMN_DEFAULT COLUMN_DEFAULT FROM INFORMATION_SCHEMA.INDEXES idx, INFORMATION_SCHEMA.COLUMNS cols WHERE idx.TABLE_CATALOG = cols.TABLE_CATALOG and idx.TABLE_SCHEMA = cols.TABLE_SCHEMA and idx.TABLE_NAME = cols.TABLE_NAME AND idx.PRIMARY_KEY = TRUE AND COLUMN_DEFAULT like '%NEXT VALUE FOR%' ";
            if (catalog != null) {
                sql = sql + "AND idx.TABLE_CATALOG like '" + catalog + "' ";
            }
            if (schema != null) {
                sql = sql + "AND idx.TABLE_SCHEMA like '" + schema + "' ";
            }
            if (table != null) {
                sql = sql + "AND idx.TABLE_NAME like '" + table + "' ";
            }
            PreparedStatement statement = this.getConnection().prepareStatement(sql);
            return new ResultSetIterator(statement.executeQuery(), this.getSQLExceptionConverter()){
                Map element;
                {
                    this.element = new HashMap();
                }

                @Override
                protected Object convertRow(ResultSet tableRs) throws SQLException {
                    this.element.clear();
                    H2MetaDataDialect.this.putTablePart(this.element, tableRs);
                    String string = tableRs.getString("COLUMN_DEFAULT");
                    this.element.put("HIBERNATE_STRATEGY", StringHelper.isEmpty((String)string) ? null : "identity");
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Could not get list of suggested identity strategies from database. Probably a JDBC driver problem. ", null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Could not get list of suggested identity strategies from database. Probably a JDBC driver problem.", null);
        }
    }
}

