/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.json.JsonInspectorConfig;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonInspector
implements DomInspector<Element> {
    private JsonObject mRoot;

    public JsonInspector(JsonInspectorConfig config) {
        InputStream inputStream = config.getInputStream();
        if (inputStream == null) {
            throw InspectorException.newException("No JSON input stream specified");
        }
        this.mRoot = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(inputStream));
    }

    @Override
    public final String inspect(Object toInspect, String type, String ... names) {
        Element element = this.inspectAsDom(toInspect, type, names);
        if (element == null) {
            return null;
        }
        return XmlUtils.nodeToString((Node)element, false);
    }

    @Override
    public Element inspectAsDom(Object toInspect, String type, String ... names) {
        JsonObject root = this.getRoot();
        for (String name : names) {
            if (!root.has(name)) {
                return null;
            }
            root = root.getAsJsonObject(name);
        }
        Document document = XmlUtils.newDocument();
        Element documentRoot = document.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
        documentRoot.setAttribute("version", "1.0");
        document.appendChild(documentRoot);
        Element entity = document.createElementNS("http://metawidget.org/inspection-result", "entity");
        entity.setAttribute("type", type);
        documentRoot.appendChild(entity);
        for (Map.Entry entry : root.entrySet()) {
            JsonElement element = (JsonElement)entry.getValue();
            Element child = document.createElementNS("http://metawidget.org/inspection-result", "property");
            child.setAttribute("name", (String)entry.getKey());
            if (element.isJsonPrimitive()) {
                JsonPrimitive primitive = (JsonPrimitive)element;
                if (primitive.isNumber()) {
                    child.setAttribute("type", Integer.TYPE.getName());
                } else if (primitive.isBoolean()) {
                    child.setAttribute("type", Boolean.TYPE.getName());
                } else {
                    child.setAttribute("type", String.class.getName());
                }
            } else if (element.isJsonArray()) {
                child.setAttribute("type", "array");
            } else {
                child.setAttribute("type", Object.class.getName());
            }
            entity.appendChild(child);
        }
        return documentRoot;
    }

    protected JsonObject getRoot() {
        return this.mRoot;
    }
}

