/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.pipeline.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.metawidget.inspectionresultprocessor.iface.DomInspectionResultProcessor;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.Layout;
import org.metawidget.widgetbuilder.iface.AdvancedWidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePipeline<W, C extends W, E, M extends C> {
    private static final int DEFAULT_MAXIMUM_INSPECTION_DEPTH = 10;
    private boolean mReadOnly;
    private int mMaximumInspectionDepth = 10;
    private boolean mNeedsConfiguring = true;
    private Inspector mInspector;
    private List<InspectionResultProcessor<M>> mInspectionResultProcessors;
    private WidgetBuilder<W, M> mWidgetBuilder;
    private List<WidgetProcessor<W, M>> mWidgetProcessors;
    private Layout<W, C, M> mLayout;

    public void setReadOnly(boolean readOnly) {
        this.mReadOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public int getMaximumInspectionDepth() {
        return this.mMaximumInspectionDepth;
    }

    public void setMaximumInspectionDepth(int maximumInspectionDepth) {
        this.mMaximumInspectionDepth = maximumInspectionDepth;
    }

    public void setNeedsConfiguring() {
        this.mNeedsConfiguring = true;
    }

    public void configureOnce() {
        if (!this.mNeedsConfiguring) {
            return;
        }
        this.mNeedsConfiguring = false;
        this.configure();
    }

    public void setInspector(Inspector inspector) {
        this.mInspector = inspector;
    }

    public Inspector getInspector() {
        this.configureOnce();
        return this.mInspector;
    }

    public List<InspectionResultProcessor<M>> getInspectionResultProcessors() {
        this.configureOnce();
        return this.mInspectionResultProcessors;
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<M> ... inspectionResultProcessors) {
        this.mInspectionResultProcessors = inspectionResultProcessors == null ? null : new ArrayList<InspectionResultProcessor<M>>(Arrays.asList(inspectionResultProcessors));
    }

    public void addInspectionResultProcessor(InspectionResultProcessor<M> inspectionResultProcessor) {
        this.configureOnce();
        if (this.mInspectionResultProcessors == null) {
            this.mInspectionResultProcessors = new ArrayList<InspectionResultProcessor<M>>();
        } else if (this.mInspectionResultProcessors.contains(inspectionResultProcessor)) {
            throw InspectionResultProcessorException.newException("List of InspectionResultProcessors already contains " + inspectionResultProcessor.getClass());
        }
        this.mInspectionResultProcessors.add(inspectionResultProcessor);
    }

    public void removeInspectionResultProcessor(InspectionResultProcessor<M> inspectionResultProcessors) {
        this.configureOnce();
        if (this.mInspectionResultProcessors == null) {
            return;
        }
        this.mInspectionResultProcessors.remove(inspectionResultProcessors);
    }

    public void setWidgetBuilder(WidgetBuilder<W, M> widgetBuilder) {
        this.mWidgetBuilder = widgetBuilder;
    }

    public WidgetBuilder<W, M> getWidgetBuilder() {
        this.configureOnce();
        return this.mWidgetBuilder;
    }

    public List<WidgetProcessor<W, M>> getWidgetProcessors() {
        this.configureOnce();
        return this.mWidgetProcessors;
    }

    public void setWidgetProcessors(WidgetProcessor<W, M> ... widgetProcessors) {
        this.mWidgetProcessors = widgetProcessors == null ? null : new ArrayList<WidgetProcessor<W, M>>(Arrays.asList(widgetProcessors));
    }

    public void addWidgetProcessor(WidgetProcessor<W, M> widgetProcessor) {
        this.configureOnce();
        if (this.mWidgetProcessors == null) {
            this.mWidgetProcessors = new ArrayList<WidgetProcessor<W, M>>();
        } else if (this.mWidgetProcessors.contains(widgetProcessor)) {
            throw WidgetProcessorException.newException("List of WidgetProcessors already contains " + widgetProcessor.getClass());
        }
        this.mWidgetProcessors.add(widgetProcessor);
    }

    public void removeWidgetProcessor(WidgetProcessor<W, M> widgetProcessor) {
        this.configureOnce();
        if (this.mWidgetProcessors == null) {
            return;
        }
        this.mWidgetProcessors.remove(widgetProcessor);
    }

    public Layout<W, C, M> getLayout() {
        this.configureOnce();
        return this.mLayout;
    }

    public void setLayout(Layout<W, C, M> layout) {
        this.mLayout = layout;
    }

    public String inspect(Object toInspect, String type, String ... names) {
        E element = this.inspectAsDom(toInspect, type, names);
        return this.elementToString(element);
    }

    public E inspectAsDom(Object toInspect, String type, String ... names) {
        this.configureOnce();
        if (this.mInspector == null) {
            throw new NullPointerException("No inspector configured");
        }
        String inspectionResult = this.mInspector instanceof DomInspector ? ((DomInspector)this.mInspector).inspectAsDom(toInspect, type, names) : this.mInspector.inspect(toInspect, type, names);
        if (inspectionResult == null) {
            return null;
        }
        return this.processInspectionResult(inspectionResult, toInspect, type, names);
    }

    public void buildWidgets(E inspectionResult) throws Exception {
        this.configureOnce();
        this.startBuild();
        if (inspectionResult != null) {
            W widget;
            E entity = this.getFirstChildElement(inspectionResult);
            String elementName = this.getElementName(entity);
            if (!"entity".equals(elementName)) {
                throw new Exception("Top-level element name should be entity, not " + elementName);
            }
            E nextSiblingElement = this.getNextSiblingElement(entity);
            if (nextSiblingElement != null) {
                throw new Exception("Top-level entity element has a sibling " + this.getElementName(nextSiblingElement) + " element");
            }
            Map<String, String> attributes = this.getAttributesAsMap(entity);
            if (this.isReadOnly()) {
                attributes.put("read-only", "true");
            }
            if ((widget = this.buildWidget("entity", attributes)) == null) {
                this.buildCompoundWidget(entity);
            } else if ((widget = this.processWidget(widget, "entity", attributes)) != null) {
                this.layoutWidget(widget, "entity", attributes);
            }
        }
        this.endBuild();
    }

    public void initNestedPipeline(BasePipeline<W, C, E, M> nestedPipeline, Map<String, String> attributes) {
        nestedPipeline.setReadOnly(this.isReadOnly() || attributes != null && "true".equals(attributes.get("read-only")));
        nestedPipeline.setMaximumInspectionDepth(this.getMaximumInspectionDepth() - 1);
        nestedPipeline.setInspector(this.getInspector());
        nestedPipeline.setWidgetBuilder(this.getWidgetBuilder());
        nestedPipeline.setLayout(this.getLayout());
        nestedPipeline.mInspectionResultProcessors = this.mInspectionResultProcessors == null ? null : new ArrayList<InspectionResultProcessor<M>>(this.mInspectionResultProcessors);
        nestedPipeline.mWidgetProcessors = this.mWidgetProcessors == null ? null : new ArrayList<WidgetProcessor<W, M>>(this.mWidgetProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildCompoundWidget(E entity) throws Exception {
        E child = this.getFirstChildElement(entity);
        int loop = 0;
        while (child != null) {
            ++loop;
            String elementName = this.getElementName(child);
            if (!"property".equals(elementName) && !"action".equals(elementName)) {
                throw new Exception("Child element #" + loop + " should be " + "property" + " or " + "action" + ", not " + elementName);
            }
            Map<String, String> attributes = this.getAttributesAsMap(child);
            String childName = attributes.get("name");
            if (childName == null || "".equals(childName)) {
                throw new Exception("Child element #" + loop + " has no @" + "name");
            }
            boolean forcedReadOnly = false;
            if (!"true".equals(attributes.get("read-only")) && this.isReadOnly()) {
                attributes.put("read-only", "true");
                forcedReadOnly = true;
            }
            try {
                Map<String, String> additionalAttributes;
                Object widget = this.buildWidget(elementName, attributes);
                if (widget == null) {
                    if (this.mMaximumInspectionDepth <= 0) continue;
                    if (forcedReadOnly) {
                        attributes.remove("read-only");
                    }
                    widget = this.buildNestedMetawidget(attributes);
                }
                if ((additionalAttributes = this.getAdditionalAttributes(widget)) != null) {
                    attributes.putAll(additionalAttributes);
                }
                if ((widget = this.processWidget(widget, elementName, attributes)) == null) continue;
                this.layoutWidget(widget, elementName, attributes);
            }
            finally {
                child = this.getNextSiblingElement(child);
            }
        }
    }

    protected abstract E stringToElement(String var1);

    protected abstract String elementToString(E var1);

    protected abstract E getFirstChildElement(E var1);

    protected abstract E getNextSiblingElement(E var1);

    protected abstract String getElementName(E var1);

    protected abstract Map<String, String> getAttributesAsMap(E var1);

    protected abstract void configure();

    protected void startBuild() {
        M pipelineOwner = this.getPipelineOwner();
        if (this.mWidgetBuilder instanceof AdvancedWidgetBuilder) {
            ((AdvancedWidgetBuilder)this.mWidgetBuilder).onStartBuild(pipelineOwner);
        }
        if (this.mWidgetProcessors != null) {
            for (WidgetProcessor<W, M> widgetProcessor : this.mWidgetProcessors) {
                if (!(widgetProcessor instanceof AdvancedWidgetProcessor)) continue;
                ((AdvancedWidgetProcessor)widgetProcessor).onStartBuild(pipelineOwner);
            }
        }
        if (this.mLayout instanceof AdvancedLayout) {
            AdvancedLayout advancedLayout = (AdvancedLayout)this.mLayout;
            advancedLayout.onStartBuild(pipelineOwner);
            advancedLayout.startContainerLayout(pipelineOwner, pipelineOwner);
        }
    }

    protected E processInspectionResult(Object inspectionResult, Object toInspect, String type, String ... names) {
        Object inspectionResultToProcess = inspectionResult;
        if (this.mInspectionResultProcessors != null) {
            M pipelineOwner = this.getPipelineOwner();
            for (InspectionResultProcessor<M> inspectionResultProcessor : this.mInspectionResultProcessors) {
                if (inspectionResultProcessor instanceof DomInspectionResultProcessor) {
                    if (inspectionResultToProcess instanceof String) {
                        inspectionResultToProcess = this.stringToElement((String)inspectionResultToProcess);
                    }
                    DomInspectionResultProcessor domInspectionResultProcessor = (DomInspectionResultProcessor)inspectionResultProcessor;
                    Object inspectionResultToProcessElement = inspectionResultToProcess;
                    inspectionResultToProcess = domInspectionResultProcessor.processInspectionResultAsDom(inspectionResultToProcessElement, pipelineOwner, toInspect, type, names);
                } else {
                    if (!(inspectionResultToProcess instanceof String)) {
                        Object inspectionResultToProcessElement = inspectionResultToProcess;
                        inspectionResultToProcess = this.elementToString(inspectionResultToProcessElement);
                    }
                    inspectionResultToProcess = inspectionResultProcessor.processInspectionResult((String)inspectionResultToProcess, pipelineOwner, toInspect, type, names);
                }
                if (inspectionResultToProcess != null) continue;
                return null;
            }
        }
        if (inspectionResultToProcess instanceof String) {
            return this.stringToElement((String)inspectionResultToProcess);
        }
        Object processedInspectionResult = inspectionResultToProcess;
        return (E)processedInspectionResult;
    }

    protected abstract Map<String, String> getAdditionalAttributes(W var1);

    protected W buildWidget(String elementName, Map<String, String> attributes) {
        if (this.mWidgetBuilder == null) {
            return null;
        }
        return this.mWidgetBuilder.buildWidget(elementName, attributes, this.getPipelineOwner());
    }

    protected W processWidget(W widget, String elementName, Map<String, String> attributes) {
        W processedWidget = widget;
        if (this.mWidgetProcessors != null) {
            M pipelineOwner = this.getPipelineOwner();
            for (WidgetProcessor<W, M> widgetProcessor : this.mWidgetProcessors) {
                processedWidget = widgetProcessor.processWidget(processedWidget, elementName, attributes, pipelineOwner);
                if (processedWidget != null) continue;
                return null;
            }
        }
        return processedWidget;
    }

    protected abstract M buildNestedMetawidget(Map<String, String> var1) throws Exception;

    protected abstract M getPipelineOwner();

    protected void layoutWidget(W widget, String elementName, Map<String, String> attributes) {
        M pipelineOwner = this.getPipelineOwner();
        this.mLayout.layoutWidget(widget, elementName, attributes, pipelineOwner, pipelineOwner);
    }

    protected void endBuild() {
        M pipelineOwner = this.getPipelineOwner();
        if (this.mLayout instanceof AdvancedLayout) {
            AdvancedLayout advancedLayout = (AdvancedLayout)this.mLayout;
            advancedLayout.endContainerLayout(pipelineOwner, pipelineOwner);
            advancedLayout.onEndBuild(pipelineOwner);
        }
        if (this.mWidgetProcessors != null) {
            for (WidgetProcessor<W, M> widgetProcessor : this.mWidgetProcessors) {
                if (!(widgetProcessor instanceof AdvancedWidgetProcessor)) continue;
                ((AdvancedWidgetProcessor)widgetProcessor).onEndBuild(pipelineOwner);
            }
        }
        if (this.mWidgetBuilder instanceof AdvancedWidgetBuilder) {
            ((AdvancedWidgetBuilder)this.mWidgetBuilder).onEndBuild(pipelineOwner);
        }
    }
}

