/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.widgetbuilder;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextArea;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.vaadin.ui.widgetbuilder.LookupLabel;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyWidgetBuilder
implements WidgetBuilder<Component, VaadinMetawidget> {
    @Override
    public Component buildWidget(String elementName, Map<String, String> attributes, VaadinMetawidget metawidget) {
        if (!WidgetBuilderUtils.isReadOnly(attributes)) {
            return null;
        }
        if ("true".equals(attributes.get("hidden"))) {
            return null;
        }
        if ("action".equals(elementName)) {
            Button button = new Button(metawidget.getLabelString(attributes));
            button.setEnabled(false);
            return button;
        }
        if ("true".equals(attributes.get("masked"))) {
            return new Panel();
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            String lookupLabels = attributes.get("lookup-labels");
            if (lookupLabels != null && !"".equals(lookupLabels)) {
                return new LookupLabel(CollectionUtils.newHashMap(CollectionUtils.fromString(lookup), CollectionUtils.fromString(lookupLabels)));
            }
            return new Label();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class);
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                return new Label();
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("large"))) {
                    TextArea textarea = new TextArea();
                    textarea.setReadOnly(true);
                    return textarea;
                }
                return new Label();
            }
            if (Character.class.equals(clazz)) {
                return new Label();
            }
            if (Date.class.equals(clazz)) {
                return new Label();
            }
            if (Boolean.class.equals(clazz)) {
                return new Label();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return new Label();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return null;
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return new Label();
        }
        return null;
    }
}

