/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.sso.josso;

import java.util.Set;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.sso.josso.JOSSOIdentityService;

public class JOSSOIdentityServiceImpl
implements JOSSOIdentityService {
    private static Logger log = Logger.getLogger(JOSSOIdentityServiceImpl.class);
    private UserModule userModule = null;
    private UserProfileModule profileModule = null;
    private MembershipModule membershipModule = null;

    public void start() {
        try {
            InitialContext initialContext = new InitialContext();
            this.userModule = (UserModule)initialContext.lookup("java:/portal/UserModule");
            this.profileModule = (UserProfileModule)initialContext.lookup("java:/portal/UserProfileModule");
            this.membershipModule = (MembershipModule)initialContext.lookup("java:/portal/MembershipModule");
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            this.stop();
        }
    }

    public void stop() {
        this.userModule = null;
        this.profileModule = null;
        this.membershipModule = null;
    }

    public String[] getUserRoles(String username) {
        Session session = null;
        Transaction tx = null;
        try {
            String[] userRoles = null;
            InitialContext initialContext = new InitialContext();
            SessionFactory sessionFactory = (SessionFactory)initialContext.lookup("java:/portal/IdentitySessionFactory");
            session = sessionFactory.openSession();
            tx = session.beginTransaction();
            User user = this.userModule.findUserByUserName(username);
            if (user != null && user.getUserName().trim().equals(username.trim())) {
                Set roles = this.membershipModule.getRoles(user);
                userRoles = new String[roles.size() + 1];
                userRoles[0] = "Authenticated";
                int index = 1;
                for (Role role : roles) {
                    userRoles[index++] = role.getName();
                }
            }
            String[] stringArray = userRoles;
            return stringArray;
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            tx.commit();
            session.close();
        }
    }

    public boolean exists(String username) {
        Session session = null;
        Transaction tx = null;
        try {
            boolean exists = false;
            InitialContext initialContext = new InitialContext();
            SessionFactory sessionFactory = (SessionFactory)initialContext.lookup("java:/portal/IdentitySessionFactory");
            session = sessionFactory.openSession();
            tx = session.beginTransaction();
            User user = this.userModule.findUserByUserName(username);
            if (user != null && user.getUserName().trim().equals(username.trim())) {
                exists = true;
            }
            boolean bl = exists;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            tx.commit();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) {
        Session session = null;
        Transaction tx = null;
        try {
            Boolean enabled;
            boolean status = false;
            InitialContext initialContext = new InitialContext();
            SessionFactory sessionFactory = (SessionFactory)initialContext.lookup("java:/portal/IdentitySessionFactory");
            session = sessionFactory.openSession();
            tx = session.beginTransaction();
            User user = this.userModule.findUserByUserName(username);
            if (user != null && (enabled = (Boolean)this.profileModule.getProperty(user, "portal.user.enabled")) != null && enabled.booleanValue()) {
                status = user.validatePassword(password);
            }
            boolean bl = status;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            tx.commit();
            session.close();
        }
    }
}

