/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jci.compilers.AbstractJavaCompiler;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JaninoCompilationProblem;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.ClassFile;

public final class JaninoJavaCompiler
extends AbstractJavaCompiler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$compilers$JaninoJavaCompiler == null ? (class$org$apache$commons$jci$compilers$JaninoJavaCompiler = JaninoJavaCompiler.class$("org.apache.commons.jci.compilers.JaninoJavaCompiler")) : class$org$apache$commons$jci$compilers$JaninoJavaCompiler));
    static /* synthetic */ Class class$org$apache$commons$jci$compilers$JaninoJavaCompiler;

    public CompilationResult compile(String[] pClasses, ResourceReader pResourceReader, ResourceStore pStore, ClassLoader classLoader) {
        HashMap classFilesByName = new HashMap();
        CompilingIClassLoader icl = new CompilingIClassLoader(pResourceReader, classFilesByName, classLoader);
        for (int i = 0; i < pClasses.length; ++i) {
            log.debug((Object)("compiling " + pClasses[i]));
            icl.loadIClass(Descriptor.fromClassName((String)pClasses[i]));
        }
        Iterator i = classFilesByName.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            pStore.write((String)entry.getKey(), (byte[])entry.getValue());
        }
        Collection problems = icl.getProblems();
        CompilationProblem[] result = new CompilationProblem[problems.size()];
        problems.toArray(result);
        return new CompilationResult(result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CompilingIClassLoader
    extends IClassLoader {
        private final Map types = new HashMap();
        private final ResourceReader resourceReader;
        private final Map classes;
        private final Collection problems = new ArrayList();

        private CompilingIClassLoader(ResourceReader pResourceReader, Map pClasses, ClassLoader classLoader) {
            super((IClassLoader)new ClassLoaderIClassLoader(classLoader));
            this.resourceReader = pResourceReader;
            this.classes = pClasses;
            super.postConstruct();
        }

        protected Collection getProblems() {
            return this.problems;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IClass findIClass(String pType) {
            String className = Descriptor.toClassName((String)pType);
            if (this.types.containsKey(pType)) {
                return (IClass)this.types.get(pType);
            }
            String resourceNameFromClass = className.replace('.', '/') + ".java";
            byte[] content = this.resourceReader.getBytes(resourceNameFromClass);
            if (content == null) {
                return null;
            }
            BufferedReader reader = new BufferedReader(new StringReader(new String(content)));
            Scanner scanner = null;
            try {
                scanner = new Scanner(resourceNameFromClass, (Reader)reader);
                Java.CompilationUnit unit = new Parser(scanner).parseCompilationUnit();
                UnitCompiler uc = new UnitCompiler(unit, (IClassLoader)this);
                uc.setCompileErrorHandler(new UnitCompiler.ErrorHandler(){

                    public void handleError(String pMessage, Location pOptionalLocation) throws CompileException {
                        JaninoCompilationProblem problem = new JaninoCompilationProblem(pOptionalLocation, pMessage, true);
                        if (((CompilingIClassLoader)CompilingIClassLoader.this).JaninoJavaCompiler.this.problemHandler != null) {
                            ((CompilingIClassLoader)CompilingIClassLoader.this).JaninoJavaCompiler.this.problemHandler.handle((CompilationProblem)problem);
                        }
                        CompilingIClassLoader.this.problems.add(problem);
                    }
                });
                uc.setWarningHandler(new WarningHandler(){

                    public void handleWarning(String pHandle, String pMessage, Location pOptionalLocation) {
                        JaninoCompilationProblem problem = new JaninoCompilationProblem(pOptionalLocation, pMessage, false);
                        if (((CompilingIClassLoader)CompilingIClassLoader.this).JaninoJavaCompiler.this.problemHandler != null) {
                            ((CompilingIClassLoader)CompilingIClassLoader.this).JaninoJavaCompiler.this.problemHandler.handle((CompilationProblem)problem);
                        }
                        CompilingIClassLoader.this.problems.add(problem);
                    }
                });
                log.debug((Object)("compile " + className));
                ClassFile[] classFiles = uc.compileUnit(DebuggingInformation.ALL);
                for (int i = 0; i < classFiles.length; ++i) {
                    log.debug((Object)("compiled " + classFiles[i].getThisClassName()));
                    this.classes.put(classFiles[i].getThisClassName(), classFiles[i].toByteArray());
                }
                IClass ic = uc.findClass(className);
                if (null != ic) {
                    this.types.put(pType, ic);
                }
                IClass iClass = ic;
                return iClass;
            }
            catch (Scanner.LocatedException e) {
                this.problems.add(new JaninoCompilationProblem(e));
            }
            catch (IOException e) {
                this.problems.add(new JaninoCompilationProblem(resourceNameFromClass, "IOException:" + e.getMessage(), true));
            }
            catch (Exception e) {
                this.problems.add(new JaninoCompilationProblem(resourceNameFromClass, "Exception:" + e.getMessage(), true));
            }
            finally {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("IOException occured while compiling " + className), (Throwable)e);
                    }
                }
            }
            return null;
        }
    }
}

