/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rules.InvalidRuleSessionException;
import javax.rules.ObjectFilter;
import javax.rules.RuleExecutionSetMetadata;
import javax.rules.RuleSession;
import javax.rules.StatefulRuleSession;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.RuleExecutionSet;
import org.drools.WorkingMemory;
import org.drools.jsr94.rules.RuleExecutionSetMetadataImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetRepository;

abstract class AbstractRuleSessionImpl
implements RuleSession {
    private RuleExecutionSetRepository repository;
    private WorkingMemory workingMemory;
    private RuleExecutionSetImpl ruleExecutionSet;
    private Map properties;

    public AbstractRuleSessionImpl(RuleExecutionSetRepository ruleExecutionSetRepository) {
        this.repository = ruleExecutionSetRepository;
    }

    protected void initWorkingMemory() {
        this.setWorkingMemory(this.newWorkingMemory());
    }

    protected WorkingMemory newWorkingMemory() {
        WorkingMemory workingMemory = this.getRuleExecutionSet().newWorkingMemory();
        Map map = this.getProperties();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                workingMemory.setGlobal((String)entry.getKey(), entry.getValue());
            }
        }
        return workingMemory;
    }

    protected void setProperties(Map map) {
        this.properties = map;
    }

    protected Map getProperties() {
        return this.properties;
    }

    protected void setWorkingMemory(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    protected WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    protected void setRuleExecutionSet(RuleExecutionSetImpl ruleExecutionSetImpl) {
        this.ruleExecutionSet = ruleExecutionSetImpl;
    }

    protected RuleExecutionSetImpl getRuleExecutionSet() {
        return this.ruleExecutionSet;
    }

    protected void checkRuleSessionValidity() throws InvalidRuleSessionException {
        if (this.workingMemory == null) {
            throw new InvalidRuleSessionException("invalid rule session");
        }
    }

    protected void applyFilter(List list, ObjectFilter objectFilter) {
        if (objectFilter != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (objectFilter.filter(e) != null) continue;
                iterator.remove();
            }
        }
    }

    public RuleExecutionSetMetadata getRuleExecutionSetMetadata() {
        String string = null;
        Iterator iterator = this.repository.getRegistrations().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            RuleExecutionSet ruleExecutionSet = this.repository.getRuleExecutionSet(string2);
            if (ruleExecutionSet != this.ruleExecutionSet) continue;
            string = string2;
            break;
        }
        return new RuleExecutionSetMetadataImpl(string, this.ruleExecutionSet.getName(), this.ruleExecutionSet.getDescription());
    }

    public int getType() throws InvalidRuleSessionException {
        if (this instanceof StatelessRuleSession) {
            return 1;
        }
        if (this instanceof StatefulRuleSession) {
            return 0;
        }
        throw new InvalidRuleSessionException("unknown type");
    }

    public void release() {
        this.setProperties(null);
        this.setWorkingMemory(null);
        this.setRuleExecutionSet(null);
    }

    public void reset() {
        this.initWorkingMemory();
    }
}

