/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeValue;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.visualization.VertexLocationFunction;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PajekNetWriter {
    public void save(Graph g, String filename, VertexStringer vs, NumberEdgeValue nev, VertexLocationFunction vld) throws IOException {
        this.save(g, new FileWriter(filename), vs, nev, vld);
    }

    public void save(Graph g, String filename, VertexStringer vs, NumberEdgeValue nev) throws IOException {
        this.save(g, new FileWriter(filename), vs, nev, null);
    }

    public void save(Graph g, String filename) throws IOException {
        this.save(g, filename, null, null, null);
    }

    public void save(Graph g, Writer w) throws IOException {
        this.save(g, w, null, null, null);
    }

    public void save(Graph g, Writer w, VertexStringer vs, NumberEdgeValue nev) throws IOException {
        this.save(g, w, vs, nev, null);
    }

    public void save(Graph graph, Writer w, VertexStringer vs, NumberEdgeValue nev, VertexLocationFunction vld) throws IOException {
        Edge e;
        BufferedWriter writer = new BufferedWriter(w);
        if (nev == null) {
            nev = new ConstantEdgeValue(1.0);
        }
        writer.write("*Vertices " + graph.numVertices());
        writer.newLine();
        Vertex currentVertex = null;
        Indexer id = Indexer.getIndexer(graph);
        Iterator i = graph.getVertices().iterator();
        while (i.hasNext()) {
            Point2D location;
            String label;
            currentVertex = (Vertex)i.next();
            Integer v_id = new Integer(id.getIndex(currentVertex) + 1);
            writer.write(v_id.toString());
            if (vs != null && (label = vs.getLabel(currentVertex)) != null) {
                writer.write(" \"" + label + "\"");
            }
            if (vld != null && (location = vld.getLocation(currentVertex)) != null) {
                writer.write(" " + location.getX() + " " + location.getY() + " 0.0");
            }
            writer.newLine();
        }
        Set d_set = new HashSet();
        Set u_set = new HashSet();
        boolean directed = PredicateUtils.enforcesDirected(graph);
        boolean undirected = PredicateUtils.enforcesUndirected(graph);
        if (directed) {
            d_set = graph.getEdges();
        }
        if (undirected) {
            u_set = graph.getEdges();
        }
        if (!directed && !undirected) {
            d_set = PredicateUtils.getEdges(graph, Graph.DIRECTED_EDGE);
            u_set = PredicateUtils.getEdges(graph, Graph.UNDIRECTED_EDGE);
        }
        if (!d_set.isEmpty()) {
            writer.write("*Arcs");
            writer.newLine();
        }
        Iterator eIt = d_set.iterator();
        while (eIt.hasNext()) {
            e = (DirectedEdge)eIt.next();
            int source_id = id.getIndex(e.getSource()) + 1;
            int target_id = id.getIndex(e.getDest()) + 1;
            float weight = nev.getNumber(e).floatValue();
            writer.write(source_id + " " + target_id + " " + weight);
            writer.newLine();
        }
        if (!u_set.isEmpty()) {
            writer.write("*Edges");
            writer.newLine();
        }
        eIt = u_set.iterator();
        while (eIt.hasNext()) {
            e = (UndirectedEdge)eIt.next();
            Pair endpoints = e.getEndpoints();
            int v1_id = id.getIndex((Vertex)endpoints.getFirst()) + 1;
            int v2_id = id.getIndex((Vertex)endpoints.getSecond()) + 1;
            float weight = nev.getNumber(e).floatValue();
            writer.write(v1_id + " " + v2_id + " " + weight);
            writer.newLine();
        }
        writer.close();
    }
}

