/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.generators;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.random.generators.GraphGenerator;
import edu.uci.ics.jung.utils.GraphUtils;

public class Lattice2DGenerator
implements GraphGenerator {
    private int mLatticeSize;
    private boolean mIsToroidal;

    public Lattice2DGenerator(int latticeSize, boolean isToroidal) {
        if (latticeSize < 2) {
            throw new IllegalArgumentException("Lattice size must be at least 2.");
        }
        this.mLatticeSize = latticeSize;
        this.mIsToroidal = isToroidal;
    }

    public ArchetypeGraph generateGraph() {
        int numNodes = (int)Math.pow(this.mLatticeSize, 2.0);
        DirectedSparseGraph graph = new DirectedSparseGraph();
        GraphUtils.addVertices((Graph)graph, numNodes);
        int currentLatticeRow = 0;
        int currentLatticeColumn = 0;
        int upIndex = 0;
        int downIndex = 0;
        int leftIndex = 0;
        int rightIndex = 0;
        Indexer id = Indexer.getIndexer(graph);
        for (int i = 0; i < numNodes; ++i) {
            currentLatticeRow = i / this.mLatticeSize;
            currentLatticeColumn = i % this.mLatticeSize;
            upIndex = this.upIndex(currentLatticeRow, currentLatticeColumn);
            leftIndex = this.leftIndex(currentLatticeRow, currentLatticeColumn);
            downIndex = this.downIndex(currentLatticeRow, currentLatticeColumn);
            rightIndex = this.rightIndex(currentLatticeRow, currentLatticeColumn);
            if (currentLatticeRow != 0 || currentLatticeRow == 0 && this.mIsToroidal) {
                GraphUtils.addEdge(graph, (Vertex)id.getVertex(i), (Vertex)id.getVertex(upIndex));
            }
            if (currentLatticeColumn != 0 || currentLatticeColumn == 0 && this.mIsToroidal) {
                GraphUtils.addEdge(graph, (Vertex)id.getVertex(i), (Vertex)id.getVertex(leftIndex));
            }
            if (currentLatticeRow != this.mLatticeSize - 1 || currentLatticeRow == this.mLatticeSize - 1 && this.mIsToroidal) {
                GraphUtils.addEdge(graph, (Vertex)id.getVertex(i), (Vertex)id.getVertex(downIndex));
            }
            if (currentLatticeColumn == this.mLatticeSize - 1 && (currentLatticeColumn != this.mLatticeSize - 1 || !this.mIsToroidal)) continue;
            GraphUtils.addEdge(graph, (Vertex)id.getVertex(i), (Vertex)id.getVertex(rightIndex));
        }
        return graph;
    }

    protected int upIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeRow == 0) {
            return this.mLatticeSize * (this.mLatticeSize - 1) + currentLatticeColumn;
        }
        return (currentLatticeRow - 1) * this.mLatticeSize + currentLatticeColumn;
    }

    protected int downIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeRow == this.mLatticeSize - 1) {
            return currentLatticeColumn;
        }
        return (currentLatticeRow + 1) * this.mLatticeSize + currentLatticeColumn;
    }

    protected int leftIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeColumn == 0) {
            return currentLatticeRow * this.mLatticeSize + this.mLatticeSize - 1;
        }
        return currentLatticeRow * this.mLatticeSize + currentLatticeColumn - 1;
    }

    protected int rightIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeColumn == this.mLatticeSize - 1) {
            return currentLatticeRow * this.mLatticeSize;
        }
        return currentLatticeRow * this.mLatticeSize + currentLatticeColumn + 1;
    }

    public int getLatticeSize() {
        return this.mLatticeSize;
    }
}

