/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.utils.SubsetManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.PredicateDecorator;

public class PredicateUtils {
    public static Set getVertices(ArchetypeGraph g, Predicate p) {
        HashSet<ArchetypeVertex> s;
        SubsetManager sm = (SubsetManager)g.getUserDatum("edu.ics.uci.jung.graph.ArchetypeGraph:SubsetManager");
        if (sm != null && (s = sm.getVertices(p)) != null) {
            return s;
        }
        s = new HashSet<ArchetypeVertex>();
        Set vertices = g.getVertices();
        Iterator v_it = vertices.iterator();
        while (v_it.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)v_it.next();
            if (!p.evaluate((Object)v)) continue;
            s.add(v);
        }
        return Collections.unmodifiableSet(s);
    }

    public static Set getEdges(ArchetypeGraph g, Predicate p) {
        HashSet<ArchetypeEdge> s;
        SubsetManager sm = (SubsetManager)g.getUserDatum("edu.ics.uci.jung.graph.ArchetypeGraph:SubsetManager");
        if (sm != null && (s = sm.getEdges(p)) != null) {
            return s;
        }
        s = new HashSet<ArchetypeEdge>();
        Set edges = g.getEdges();
        Iterator e_it = edges.iterator();
        while (e_it.hasNext()) {
            ArchetypeEdge e = (ArchetypeEdge)e_it.next();
            if (!p.evaluate((Object)e)) continue;
            s.add(e);
        }
        return Collections.unmodifiableSet(s);
    }

    public static boolean addVertexSubset(ArchetypeGraph g, Predicate p) {
        return SubsetManager.getInstance(g).addVertexSubset(p);
    }

    public static boolean addEdgeSubset(ArchetypeGraph g, Predicate p) {
        return SubsetManager.getInstance(g).addEdgeSubset(p);
    }

    public static void removeVertexSubset(ArchetypeGraph g, Predicate p) {
        SubsetManager.getInstance(g).removeVertexSubset(p);
    }

    public static void removeEdgeSubset(ArchetypeGraph g, Predicate p) {
        SubsetManager.getInstance(g).removeEdgeSubset(p);
    }

    public static boolean enforcesEdgeConstraint(ArchetypeGraph g, Predicate p) {
        return g.getEdgeConstraints().contains(p);
    }

    public static boolean satisfiesEdgeConstraint(ArchetypeGraph g, Predicate p) {
        if (PredicateUtils.enforcesEdgeConstraint(g, p)) {
            return true;
        }
        return PredicateUtils.satisfiesPredicate(g.getEdges(), p);
    }

    public static boolean enforcesVertexConstraint(ArchetypeGraph g, Predicate p) {
        return g.getVertexConstraints().contains(p);
    }

    public static boolean satisfiesVertexConstraint(ArchetypeGraph g, Predicate p) {
        if (PredicateUtils.enforcesVertexConstraint(g, p)) {
            return true;
        }
        return PredicateUtils.satisfiesPredicate(g.getVertices(), p);
    }

    public static boolean satisfiesPredicate(Collection c, Predicate p) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (p.evaluate(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static Collection getSatisfyingElements(Collection c, Predicate p) {
        LinkedList satisfied = new LinkedList();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!p.evaluate(o)) continue;
            satisfied.add(o);
        }
        return satisfied;
    }

    public static boolean enforcesDirected(Graph g) {
        return g.getEdgeConstraints().contains(Graph.DIRECTED_EDGE);
    }

    public static boolean enforcesUndirected(Graph g) {
        return g.getEdgeConstraints().contains(Graph.UNDIRECTED_EDGE);
    }

    public static boolean enforcesNotParallel(Graph g) {
        return g.getEdgeConstraints().contains(Graph.NOT_PARALLEL_EDGE);
    }

    public static Map evaluateNestedPredicates(Predicate p, Object o) {
        HashMap<Predicate, Boolean> evaluations = new HashMap<Predicate, Boolean>();
        if (p instanceof PredicateDecorator) {
            Predicate[] nested_preds = ((PredicateDecorator)p).getPredicates();
            for (int i = 0; i < nested_preds.length; ++i) {
                evaluations.put(nested_preds[i], new Boolean(nested_preds[i].evaluate(o)));
            }
        } else {
            evaluations.put(p, new Boolean(p.evaluate(o)));
        }
        return evaluations;
    }
}

