/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalHyperbolicGraphMouse;
import edu.uci.ics.jung.visualization.transform.HyperbolicLensSupport;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

public abstract class AbstractHyperbolicLensSupport
implements HyperbolicLensSupport {
    protected VisualizationViewer vv;
    protected VisualizationViewer.GraphMouse graphMouse;
    protected MutableTransformer savedViewTransformer;
    protected HyperbolicTransformer hyperbolicTransformer;
    protected ModalGraphMouse hyperbolicGraphMouse;
    protected Lens lens;
    protected String defaultToolTipText;
    protected static final String instructions = "<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>";

    public AbstractHyperbolicLensSupport(VisualizationViewer vv) {
        this.vv = vv;
        this.savedViewTransformer = vv.getViewTransformer();
        this.graphMouse = vv.getGraphMouse();
        this.defaultToolTipText = vv.getToolTipText();
        this.hyperbolicGraphMouse = new ModalHyperbolicGraphMouse();
    }

    public void activate(boolean state) {
        if (state) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public HyperbolicTransformer getHyperbolicTransformer() {
        return this.hyperbolicTransformer;
    }

    public ModalGraphMouse getHyperbolicGraphMouse() {
        return this.hyperbolicGraphMouse;
    }

    public static class Lens
    implements VisualizationViewer.Paintable {
        HyperbolicTransformer hyperbolicTransformer;
        Ellipse2D ellipse;

        public Lens(HyperbolicTransformer hyperbolicTransformer) {
            this.hyperbolicTransformer = hyperbolicTransformer;
            this.ellipse = hyperbolicTransformer.getEllipse();
        }

        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(Color.decode("0xdddddd"));
            g2d.fill(this.ellipse);
            g.setColor(Color.gray);
            g2d.draw(this.ellipse);
            g.drawOval((int)Math.round(this.ellipse.getCenterX() - 5.0), (int)Math.round(this.ellipse.getCenterY() - 5.0), 10, 10);
        }

        public boolean useTransform() {
            return false;
        }
    }
}

