/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.utils.TestGraphs;
import edu.uci.ics.jung.visualization.BirdsEyeVisualizationViewer;
import edu.uci.ics.jung.visualization.ISOMLayout;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ViewScalingControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ZoomDemo {
    Graph graph = TestGraphs.getOneComponentGraph();
    VisualizationViewer vv;
    JDialog dialog;

    public ZoomDemo() {
        ISOMLayout layout = new ISOMLayout(this.graph);
        PluggableRenderer pr = new PluggableRenderer();
        this.vv = new VisualizationViewer(layout, (Renderer)pr);
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        this.vv.setPickSupport(new ShapePickSupport());
        final JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.vv);
        content.add(panel);
        frame.setDefaultCloseOperation(3);
        this.dialog = new JDialog(frame);
        content = this.dialog.getContentPane();
        final BirdsEyeVisualizationViewer bird = new BirdsEyeVisualizationViewer(this.vv, 0.25f, 0.25f);
        JButton reset = new JButton("No Zoom");
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                bird.resetLens();
            }
        });
        final ViewScalingControl scaler = new ViewScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(ZoomDemo.this.vv, 1.1f, ZoomDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(ZoomDemo.this.vv, 0.9f, ZoomDemo.this.vv.getCenter());
            }
        });
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String zoomHelp = "<html><center>Drag the rectangle to pan<p>Drag one side of the rectangle to zoom</center></html>";
                JOptionPane.showMessageDialog(ZoomDemo.this.dialog, zoomHelp);
            }
        });
        JPanel controls = new JPanel(new GridLayout(2, 2));
        controls.add(plus);
        controls.add(minus);
        controls.add(reset);
        controls.add(help);
        content.add(bird);
        content.add((Component)controls, "South");
        JButton zoomer = new JButton("Show Zoom Window");
        zoomer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZoomDemo.this.dialog.pack();
                ZoomDemo.this.dialog.setLocation((int)(frame.getLocationOnScreen().getX() + (double)frame.getWidth()), (int)frame.getLocationOnScreen().getY());
                ZoomDemo.this.dialog.show();
                bird.initLens();
            }
        });
        JPanel p = new JPanel();
        p.add(zoomer);
        frame.getContentPane().add((Component)p, "South");
        frame.setSize(600, 600);
        frame.show();
    }

    public static void main(String[] args) {
        new ZoomDemo();
    }
}

