/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceFinder;

public class ResourceFinderClassLoader
extends ClassLoader {
    private final ResourceFinder resourceFinder;

    public ResourceFinderClassLoader(ResourceFinder resourceFinder, ClassLoader classLoader) {
        super(classLoader);
        this.resourceFinder = resourceFinder;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        InputStream inputStream;
        Resource resource = this.resourceFinder.findResource(ClassFile.getClassFileResourceName(string));
        if (resource == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            inputStream = resource.open();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Opening class file resource \"" + resource.getFileName() + "\": " + iOException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("Reading class file from \"" + resource + "\"", iOException);
            }
            clazz = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        byte[] byArray = byteArrayOutputStream.toByteArray();
        clazz = super.defineClass(null, byArray, 0, byArray.length);
        if (!clazz.getName().equals(string)) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public ResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }
}

