/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.listeners;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.jci.ReloadingClassLoader;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.JavaCompilerFactory;
import org.apache.commons.jci.listeners.ReloadingListener;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.FileResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.TransactionalResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompilingListener
extends ReloadingListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$listeners$CompilingListener == null ? (class$org$apache$commons$jci$listeners$CompilingListener = CompilingListener.class$("org.apache.commons.jci.listeners.CompilingListener")) : class$org$apache$commons$jci$listeners$CompilingListener));
    private final JavaCompiler compiler;
    private final ResourceReader reader;
    private final TransactionalResourceStore transactionalStore;
    private CompilationResult lastResult;
    static /* synthetic */ Class class$org$apache$commons$jci$listeners$CompilingListener;

    public CompilingListener(File pRepository) {
        this(pRepository, JavaCompilerFactory.getInstance().createCompiler("eclipse"), new TransactionalResourceStore(new MemoryResourceStore()));
    }

    public CompilingListener(File pRepository, JavaCompiler pCompiler, TransactionalResourceStore pTransactionalStore) {
        super(pRepository);
        this.compiler = pCompiler;
        this.transactionalStore = pTransactionalStore;
        this.reader = new FileResourceReader(pRepository);
        this.lastResult = null;
    }

    public ResourceStore getStore() {
        return this.transactionalStore;
    }

    public synchronized CompilationResult getCompilationResult() {
        return this.lastResult;
    }

    public void onStart() {
        super.onStart();
        this.transactionalStore.onStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop() {
        boolean reload = false;
        log.debug((Object)("created:" + this.created.size() + " changed:" + this.changed.size() + " deleted:" + this.deleted.size() + " resources"));
        if (this.deleted.size() > 0) {
            Iterator it = this.deleted.iterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                this.transactionalStore.remove(ReloadingClassLoader.clazzName(this.repository, file));
            }
            reload = true;
        }
        ArrayList<File> compileables = new ArrayList<File>();
        Iterator it = this.created.iterator();
        while (it.hasNext()) {
            File createdFile = (File)it.next();
            if (!createdFile.getName().endsWith(".java")) continue;
            compileables.add(createdFile);
        }
        it = this.changed.iterator();
        while (it.hasNext()) {
            File changedFile = (File)it.next();
            if (!changedFile.getName().endsWith(".java")) continue;
            compileables.add(changedFile);
        }
        if (compileables.size() > 0) {
            Object file;
            log.debug((Object)(compileables.size() + " classes to compile"));
            int i = 0;
            String[] clazzes = new String[compileables.size()];
            Iterator it2 = compileables.iterator();
            while (it2.hasNext()) {
                file = (File)it2.next();
                clazzes[i] = ReloadingClassLoader.clazzName(this.repository, (File)file);
                ++i;
            }
            CompilationResult result = this.compiler.compile(clazzes, this.reader, this.transactionalStore);
            file = this;
            synchronized (file) {
                this.lastResult = result;
            }
            CompilationProblem[] errors = result.getErrors();
            CompilationProblem[] warnings = result.getWarnings();
            log.debug((Object)(errors.length + " errors, " + warnings.length + " warnings"));
            if (errors.length > 0) {
                for (int j = 0; j < clazzes.length; ++j) {
                    this.transactionalStore.remove(clazzes[j]);
                }
            }
            reload = true;
        }
        this.transactionalStore.onStop();
        this.checked(reload);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

