/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.listeners;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jci.ReloadingClassLoader;
import org.apache.commons.jci.listeners.ResourceStoringListener;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.Transactional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadingListener
extends ResourceStoringListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$listeners$ReloadingListener == null ? (class$org$apache$commons$jci$listeners$ReloadingListener = ReloadingListener.class$("org.apache.commons.jci.listeners.ReloadingListener")) : class$org$apache$commons$jci$listeners$ReloadingListener));
    protected final Collection created = new ArrayList();
    protected final Collection changed = new ArrayList();
    protected final Collection deleted = new ArrayList();
    private final ResourceStore store;
    protected ReloadingClassLoader reloader;
    static /* synthetic */ Class class$org$apache$commons$jci$listeners$ReloadingListener;

    public ReloadingListener(File pRepository) {
        this(pRepository, new MemoryResourceStore());
    }

    public ReloadingListener(File pRepository, ResourceStore pStore) {
        super(pRepository);
        this.store = pStore;
    }

    public ResourceStore getStore() {
        return this.store;
    }

    public void onStart() {
        this.created.clear();
        this.changed.clear();
        this.deleted.clear();
    }

    public void onStop() {
        String resourceName;
        byte[] bytes;
        File file;
        Iterator it;
        boolean reload = false;
        log.debug((Object)("created:" + this.created.size() + " changed:" + this.changed.size() + " deleted:" + this.deleted.size() + " resources"));
        if (this.store instanceof Transactional) {
            ((Transactional)((Object)this.store)).onStart();
        }
        if (this.deleted.size() > 0) {
            it = this.deleted.iterator();
            while (it.hasNext()) {
                file = (File)it.next();
                String resourceName2 = ReloadingClassLoader.clazzName(this.repository, file);
                this.store.remove(resourceName2);
            }
            reload = true;
        }
        if (this.created.size() > 0) {
            it = this.created.iterator();
            while (it.hasNext()) {
                file = (File)it.next();
                try {
                    bytes = IOUtils.toByteArray((Reader)new FileReader(file));
                    resourceName = ReloadingClassLoader.clazzName(this.repository, file);
                    this.store.write(resourceName, bytes);
                }
                catch (Exception e) {
                    log.error((Object)("could not load " + file), (Throwable)e);
                }
            }
        }
        if (this.changed.size() > 0) {
            it = this.changed.iterator();
            while (it.hasNext()) {
                file = (File)it.next();
                try {
                    bytes = IOUtils.toByteArray((Reader)new FileReader(file));
                    resourceName = ReloadingClassLoader.clazzName(this.repository, file);
                    this.store.write(resourceName, bytes);
                }
                catch (Exception e) {
                    log.error((Object)("could not load " + file), (Throwable)e);
                }
            }
            reload = true;
        }
        if (this.store instanceof Transactional) {
            ((Transactional)((Object)this.store)).onStop();
        }
        this.checked(reload);
    }

    public void onCreateFile(File file) {
        this.created.add(file);
    }

    public void onChangeFile(File file) {
        this.changed.add(file);
    }

    public void onDeleteFile(File file) {
        this.deleted.add(file);
    }

    public void onCreateDirectory(File file) {
    }

    public void onChangeDirectory(File file) {
    }

    public void onDeleteDirectory(File file) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

