/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.contract;

import java.util.List;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.messaging.core.impl.tx.Transaction;

public interface PersistenceManager
extends MessagingComponent {
    public void addReference(long var1, MessageReference var3, Transaction var4) throws Exception;

    public void moveReference(long var1, long var3, MessageReference var5) throws Exception;

    public void removeReference(long var1, MessageReference var3, Transaction var4) throws Exception;

    public void updateDeliveryCount(long var1, MessageReference var3) throws Exception;

    public List retrievePreparedTransactions() throws Exception;

    public List getMessageChannelPairRefsForTx(long var1) throws Exception;

    public List getMessageChannelPairAcksForTx(long var1) throws Exception;

    public void pageReferences(long var1, List var3, boolean var4) throws Exception;

    public void removeDepagedReferences(long var1, List var3) throws Exception;

    public void updatePageOrder(long var1, List var3) throws Exception;

    public void updateReferencesNotPagedInRange(long var1, long var3, long var5, long var7) throws Exception;

    public List getPagedReferenceInfos(long var1, long var3, int var5) throws Exception;

    public InitialLoadInfo loadFromStart(long var1, int var3) throws Exception;

    public void mergeTransactions(int var1, int var2) throws Exception;

    public InitialLoadInfo mergeAndLoad(long var1, long var3, int var5, long var6, long var8) throws Exception;

    public List getMessages(List var1) throws Exception;

    public long reserveIDBlock(String var1, int var2) throws Exception;

    public boolean idExists(String var1) throws Exception;

    public void addTransaction(Transaction var1);

    public void dropChannelMessages(long var1) throws Exception;

    public void mergeChannelMessage(long var1, long var3) throws Exception;

    public void setSupportsTxAge(boolean var1);

    public boolean supportsTxAge();

    public static class InitialLoadInfo {
        private Long minPageOrdering;
        private Long maxPageOrdering;
        private List refInfos;
        private boolean isFromMerge;

        public InitialLoadInfo(Long minPageOrdering, Long maxPageOrdering, List refInfos, boolean fromMerge) {
            this.minPageOrdering = minPageOrdering;
            this.maxPageOrdering = maxPageOrdering;
            this.refInfos = refInfos;
            this.isFromMerge = fromMerge;
        }

        public InitialLoadInfo(Long minPageOrdering, Long maxPageOrdering, List refInfos) {
            this(minPageOrdering, maxPageOrdering, refInfos, false);
        }

        public Long getMaxPageOrdering() {
            return this.maxPageOrdering;
        }

        public Long getMinPageOrdering() {
            return this.minPageOrdering;
        }

        public List getRefInfos() {
            return this.refInfos;
        }

        public boolean isFromMerge() {
            return this.isFromMerge;
        }
    }

    public static class ReferenceInfo {
        private long messageId;
        private int deliveryCount;
        private long scheduledDelivery;

        public ReferenceInfo(long msgId, int deliveryCount, long scheduledDelivery) {
            this.messageId = msgId;
            this.deliveryCount = deliveryCount;
            this.scheduledDelivery = scheduledDelivery;
        }

        public long getMessageId() {
            return this.messageId;
        }

        public int getDeliveryCount() {
            return this.deliveryCount;
        }

        public long getScheduledDelivery() {
            return this.scheduledDelivery;
        }
    }

    public static class MessageChannelPair {
        private Message message;
        private long channelId;

        public MessageChannelPair(Message message, long channelId) {
            this.message = message;
            this.channelId = channelId;
        }

        public Message getMessage() {
            return this.message;
        }

        public long getChannelId() {
            return this.channelId;
        }
    }
}

