/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RegionEmptyException;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.InactiveRegionException;
import org.jboss.cache.statetransfer.DefaultStateTransferManager;
import org.jboss.cache.util.CachePrinter;

@Deprecated
public class LegacyStateTransferManager
extends DefaultStateTransferManager {
    protected LockManager lockManager;
    private boolean usePut;

    @Inject
    public void injectLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    @Start(priority=14)
    public void checkLoaders() {
        this.usePut = this.configuration.getCacheLoaderConfig() != null && !this.configuration.getCacheLoaderConfig().isFetchPersistentState() && !this.configuration.getCacheLoaderConfig().isShared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getState(ObjectOutputStream out, Fqn fqn, long timeout, boolean force, boolean suppressErrors) throws Exception {
        boolean canProvideState;
        boolean bl = canProvideState = !this.regionManager.isInactive(fqn) && this.cache.peek(fqn, false) != null;
        if (canProvideState && (this.fetchPersistentState || this.fetchTransientState)) {
            this.marshaller.objectToObjectStream(true, out);
            long startTime = System.currentTimeMillis();
            NodeSPI rootNode = this.cache.peek(fqn, false, false);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("locking the " + fqn + " subtree to return the in-memory (transient) state"));
                }
                this.acquireLocksForStateTransfer(rootNode, timeout, force);
                this.generator.generateState(out, rootNode, this.fetchTransientState, this.fetchPersistentState, suppressErrors);
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Successfully generated state in " + CachePrinter.prettyPrint(System.currentTimeMillis() - startTime)));
                return;
            }
            finally {
                this.releaseStateTransferLocks(rootNode);
            }
        } else {
            this.marshaller.objectToObjectStream(false, out);
            CacheException e = null;
            if (!canProvideState) {
                String exceptionMessage = "Cache instance at " + this.cache.getLocalAddress() + " cannot provide state for fqn " + fqn + ".";
                if (this.regionManager.isInactive(fqn)) {
                    exceptionMessage = exceptionMessage + " Region for fqn " + fqn + " is inactive.";
                    e = new InactiveRegionException(exceptionMessage);
                }
                if (this.cache.peek(fqn, false, false) == null) {
                    e = new RegionEmptyException();
                }
            }
            if (!this.fetchPersistentState && !this.fetchTransientState) {
                e = new CacheException("Cache instance at " + this.cache.getLocalAddress() + " is not configured to provide state");
            }
            this.marshaller.objectToObjectStream(e, out);
            if (e == null) return;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(ObjectInputStream state, NodeSPI targetRoot) throws Exception {
        long startTime = System.currentTimeMillis();
        this.acquireLocksForStateTransfer(targetRoot, this.stateRetrievalTimeout, true);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("starting state integration at node " + targetRoot));
            }
            this.integrator.integrateState(state, targetRoot, targetRoot.getFqn(), this.fetchPersistentState);
            if (log.isDebugEnabled()) {
                log.debug((Object)("successfully integrated state in " + CachePrinter.prettyPrint(System.currentTimeMillis() - startTime)));
            }
        }
        finally {
            this.releaseStateTransferLocks(targetRoot);
        }
    }

    protected void acquireLocksForStateTransfer(NodeSPI root, long timeout, boolean force) throws InterruptedException {
        if (this.usePut) {
            return;
        }
        try {
            this.lockManager.lockAll(root, LockType.READ, this.getLockOwner(), timeout, true);
        }
        catch (TimeoutException te) {
            log.error((Object)("Caught TimeoutException acquiring locks on region " + root.getFqn()), (Throwable)te);
            if (force) {
                throw te;
            }
            throw te;
        }
    }

    protected void releaseStateTransferLocks(NodeSPI root) {
        if (this.usePut) {
            return;
        }
        try {
            this.lockManager.unlockAll(root, this.getLockOwner());
        }
        catch (Throwable t) {
            log.error((Object)"failed releasing locks", t);
        }
    }

    private Object getLockOwner() {
        Object owner = this.cache.getCurrentTransaction();
        if (owner == null) {
            owner = Thread.currentThread();
        }
        return owner;
    }
}

