/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.policy.AbstractAssertion;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMPolicyReader
implements PolicyReader {
    public static final String XMLNS_NS_URI = "http://www.w3.org/2000/xmlns/";

    DOMPolicyReader() {
    }

    public Policy readPolicy(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            return this.readPolicy(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new RuntimeException("error : " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new RuntimeException("error : " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("error : " + iOException.getMessage());
        }
    }

    private Assertion readAssertion(Element element) {
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        if (!string.equals("http://schemas.xmlsoap.org/ws/2004/09/policy")) {
            return this.readPrimitiveAssertion(element);
        }
        if (string2.equals("Policy")) {
            return this.readPolicy(element);
        }
        if (string2.equals("All")) {
            return this.readAndComposite(element);
        }
        if (string2.equals("ExactlyOne")) {
            return this.readXorComposite(element);
        }
        if (string2.equals("PolicyReference")) {
            return this.readPolicyReference(element);
        }
        throw new RuntimeException("unknown element ..");
    }

    public Policy readPolicy(Element element) {
        Policy policy = new Policy();
        Attr attr = element.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (attr != null) {
            policy.setId(attr.getValue());
        }
        if ((attr = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "base")) != null) {
            policy.setBase(attr.getValue());
        }
        policy.addTerms(this.readTerms(element));
        return policy;
    }

    private AndCompositeAssertion readAndComposite(Element element) {
        AndCompositeAssertion andCompositeAssertion = new AndCompositeAssertion();
        andCompositeAssertion.addTerms(this.readTerms(element));
        return andCompositeAssertion;
    }

    private XorCompositeAssertion readXorComposite(Element element) {
        XorCompositeAssertion xorCompositeAssertion = new XorCompositeAssertion();
        xorCompositeAssertion.addTerms(this.readTerms(element));
        return xorCompositeAssertion;
    }

    public PolicyReference readPolicyReference(Element element) {
        Attr attr = element.getAttributeNode("URI");
        return new PolicyReference(attr.getValue());
    }

    private PrimitiveAssertion readPrimitiveAssertion(Element element) {
        QName qName = new QName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix());
        PrimitiveAssertion primitiveAssertion = new PrimitiveAssertion(qName);
        primitiveAssertion.setAttributes(this.getAttributes(element));
        String string = primitiveAssertion.getAttribute(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Optional"));
        primitiveAssertion.setOptional(new Boolean(string));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Node node = nodeList.item(i);
            short s = node.getNodeType();
            if (s == 1) {
                AbstractAssertion abstractAssertion;
                object = (Element)node;
                if (object.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/09/policy") && object.getLocalName().equals("Policy")) {
                    abstractAssertion = this.readPolicy((Element)object);
                    primitiveAssertion.addTerm(abstractAssertion);
                    continue;
                }
                abstractAssertion = this.readPrimitiveAssertion((Element)object);
                primitiveAssertion.addTerm(abstractAssertion);
                continue;
            }
            if (s != 3 || (object = node.getNodeValue()) == null || ((String)object).length() == 0) continue;
            primitiveAssertion.setStrValue((String)object);
        }
        return primitiveAssertion;
    }

    private ArrayList readTerms(Element element) {
        ArrayList<Assertion> arrayList = new ArrayList<Assertion>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            arrayList.add(this.readAssertion(element2));
        }
        return arrayList;
    }

    private Hashtable getAttributes(Element element) {
        Hashtable<QName, String> hashtable = new Hashtable<QName, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (XMLNS_NS_URI.equals(attr.getNamespaceURI())) continue;
            String string = attr.getPrefix();
            QName qName = null;
            qName = string != null ? new QName(attr.getNamespaceURI(), attr.getLocalName(), string) : new QName(attr.getNamespaceURI(), attr.getLocalName());
            hashtable.put(qName, attr.getValue());
        }
        return hashtable;
    }
}

