/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy.util;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Loader {
    private static Log log = LogFactory.getLog((String)Loader.class.getName());

    public static URL getResource(String string) {
        ClassLoader classLoader = null;
        URL uRL = null;
        try {
            classLoader = Loader.getTCL();
            if (classLoader != null) {
                log.debug((Object)("Trying to find [" + string + "] using " + classLoader + " class loader."));
                uRL = classLoader.getResource(string);
                if (uRL != null) {
                    return uRL;
                }
            }
        }
        catch (Throwable throwable) {
            log.warn((Object)"Caught Exception while in Loader.getResource. This may be innocuous.", throwable);
        }
        log.debug((Object)("Trying to find [" + string + "] using ClassLoader.getSystemResource()."));
        return ClassLoader.getSystemResource(string);
    }

    public static URL getResource(ClassLoader classLoader, String string) throws ClassNotFoundException {
        URL uRL = null;
        try {
            if (classLoader != null) {
                log.debug((Object)("Trying to find [" + string + "] using " + classLoader + " class loader."));
                uRL = classLoader.getResource(string);
                if (uRL != null) {
                    return uRL;
                }
            }
        }
        catch (Throwable throwable) {
            log.warn((Object)"Caught Exception while in Loader.getResource. This may be innocuous.", throwable);
        }
        return Loader.getResource(string);
    }

    public static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class loadClass(ClassLoader classLoader, String string) throws ClassNotFoundException {
        try {
            Class<?> clazz;
            if (classLoader != null && (clazz = classLoader.loadClass(string)) != null) {
                return clazz;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Loader.loadClass(string);
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        try {
            Class<?> clazz;
            ClassLoader classLoader = Loader.getTCL();
            if (classLoader != null && (clazz = classLoader.loadClass(string)) != null) {
                return clazz;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(string);
    }
}

