/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy.util;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyWriter;

public class StAXPolicyWriter
implements PolicyWriter {
    private int num = 1;

    StAXPolicyWriter() {
    }

    public void writePolicy(Policy policy, OutputStream outputStream) {
        XMLStreamWriter xMLStreamWriter = null;
        try {
            xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream);
            this.writePolicy(policy, xMLStreamWriter);
            xMLStreamWriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException);
        }
    }

    public void writePolicy(Policy policy, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamWriter.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (string != null) {
            xMLStreamWriter.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
        } else {
            xMLStreamWriter.writeStartElement("wsp", "Policy", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            xMLStreamWriter.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            xMLStreamWriter.setPrefix("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        }
        if (policy.getId() != null) {
            xMLStreamWriter.writeNamespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            xMLStreamWriter.setPrefix("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            xMLStreamWriter.writeAttribute("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", policy.getId());
        }
        for (Assertion assertion : policy.getTerms()) {
            this.writeAssertion(assertion, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
    }

    private void writeAssertion(Assertion assertion, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (assertion instanceof PrimitiveAssertion) {
            this.writePrimitiveAssertion((PrimitiveAssertion)assertion, xMLStreamWriter);
        } else if (assertion instanceof XorCompositeAssertion) {
            this.writeXorCompositeAssertion((XorCompositeAssertion)assertion, xMLStreamWriter);
        } else if (assertion instanceof PolicyReference) {
            this.writePolicyReference((PolicyReference)assertion, xMLStreamWriter);
        } else if (assertion instanceof Policy) {
            this.writePolicy((Policy)assertion, xMLStreamWriter);
        } else if (assertion instanceof AndCompositeAssertion) {
            this.writeAndCompositeAssertion((AndCompositeAssertion)assertion, xMLStreamWriter);
        } else {
            throw new RuntimeException("unknown element type");
        }
    }

    private void writeAndCompositeAssertion(AndCompositeAssertion andCompositeAssertion, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamWriter.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (string == null) {
            xMLStreamWriter.writeStartElement("wsp", "All", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            xMLStreamWriter.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            xMLStreamWriter.setPrefix("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        } else {
            xMLStreamWriter.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "All");
        }
        List list = andCompositeAssertion.getTerms();
        this.writeTerms(list, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    private void writeXorCompositeAssertion(XorCompositeAssertion xorCompositeAssertion, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamWriter.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (string == null) {
            xMLStreamWriter.writeStartElement("wsp", "ExactlyOne", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            xMLStreamWriter.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            xMLStreamWriter.setPrefix("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        } else {
            xMLStreamWriter.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "ExactlyOne");
        }
        List list = xorCompositeAssertion.getTerms();
        this.writeTerms(list, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    private void writePrimitiveAssertion(PrimitiveAssertion primitiveAssertion, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        Object object;
        QName qName = primitiveAssertion.getName();
        String string = xMLStreamWriter.getPrefix(qName.getNamespaceURI());
        if (string != null) {
            xMLStreamWriter.writeStartElement(qName.getNamespaceURI(), qName.getLocalPart());
        } else {
            object = qName.getPrefix() != null ? qName.getPrefix() : this.generateNamespace();
            xMLStreamWriter.writeStartElement((String)object, qName.getLocalPart(), qName.getNamespaceURI());
            xMLStreamWriter.writeNamespace((String)object, qName.getNamespaceURI());
            xMLStreamWriter.setPrefix((String)object, qName.getNamespaceURI());
        }
        object = primitiveAssertion.getAttributes();
        this.writeAttributes((Hashtable)object, xMLStreamWriter);
        String string2 = primitiveAssertion.getStrValue();
        if (string2 != null) {
            xMLStreamWriter.writeCharacters(string2);
        }
        List list = primitiveAssertion.getTerms();
        this.writeTerms(list, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    public void writePolicyReference(PolicyReference policyReference, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamWriter.getPrefix("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (string != null) {
            xMLStreamWriter.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference");
        } else {
            xMLStreamWriter.writeStartElement("wsp", "PolicyReference", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            xMLStreamWriter.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            xMLStreamWriter.setPrefix("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
        }
        xMLStreamWriter.writeAttribute("URI", policyReference.getPolicyURIString());
        xMLStreamWriter.writeEndElement();
    }

    private void writeTerms(List list, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        for (Assertion assertion : list) {
            this.writeAssertion(assertion, xMLStreamWriter);
        }
    }

    private void writeAttributes(Hashtable hashtable, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        for (QName qName : hashtable.keySet()) {
            String string = (String)hashtable.get(qName);
            String string2 = qName.getPrefix();
            if (string2 != null) {
                xMLStreamWriter.writeAttribute(string2, qName.getNamespaceURI(), qName.getLocalPart(), string);
                continue;
            }
            xMLStreamWriter.writeAttribute(qName.getNamespaceURI(), qName.getLocalPart(), string);
        }
    }

    private String generateNamespace() {
        return "ns" + this.num++;
    }
}

