/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.mgbean.ManagedBeanInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.ManagedBean;
import javax.faces.model.ManagedBeans;
import javax.faces.model.ManagedProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBeanConfigHandler
implements ConfigAnnotationHandler {
    private static final Collection<Class<? extends Annotation>> HANDLES;
    private Map<Class<?>, Annotation> managedBeans;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        if (this.managedBeans == null) {
            this.managedBeans = new HashMap();
        }
        this.managedBeans.put(target, annotation);
    }

    @Override
    public void push(FacesContext ctx) {
        ApplicationAssociate associate;
        if (this.managedBeans != null && (associate = ApplicationAssociate.getInstance(ctx.getExternalContext())) != null) {
            BeanManager manager = associate.getBeanManager();
            for (Map.Entry<Class<?>, Annotation> entry : this.managedBeans.entrySet()) {
                this.process(manager, entry.getKey(), entry.getValue());
            }
        }
    }

    private void process(BeanManager manager, Class<?> annotatedClass, Annotation annotation) {
        if (annotation instanceof ManagedBeans) {
            ManagedBeans beansAnnotation = (ManagedBeans)annotation;
            ManagedBean[] beans = beansAnnotation.value();
            if (beans.length > 0) {
                ManagedBeanInfo info = this.getBeanInfo(annotatedClass, beans[0]);
                manager.register(info);
                for (int i = 1; i < beans.length; ++i) {
                    ManagedBean managedBean = beans[i];
                    manager.register(info.clone(managedBean.name(), managedBean.scope(), managedBean.eager(), info));
                }
            }
        } else {
            manager.register(this.getBeanInfo(annotatedClass, (ManagedBean)annotation));
        }
    }

    private ManagedBeanInfo getBeanInfo(Class<?> annotatedClass, ManagedBean metadata) {
        String name = metadata.name();
        String scope = metadata.scope();
        boolean eager = metadata.eager();
        Field[] fields = annotatedClass.getDeclaredFields();
        ArrayList<ManagedBeanInfo.ManagedProperty> properties = null;
        if (fields.length > 0) {
            for (Field field : fields) {
                String n;
                ManagedProperty property = field.getAnnotation(ManagedProperty.class);
                if (property == null) continue;
                if (properties == null) {
                    properties = new ArrayList<ManagedBeanInfo.ManagedProperty>();
                }
                ManagedBeanInfo.ManagedProperty propertyInfo = new ManagedBeanInfo.ManagedProperty((n = property.name()) != null && n.length() != 0 ? n : field.getName(), field.getType().getName(), property.value(), null, null);
                properties.add(propertyInfo);
            }
        }
        return new ManagedBeanInfo(name, annotatedClass.getName(), scope, eager, null, null, properties, null);
    }

    static {
        ArrayList<Class> handles = new ArrayList<Class>(2);
        handles.add(ManagedBean.class);
        handles.add(ManagedBeans.class);
        HANDLES = Collections.unmodifiableCollection(handles);
    }
}

