/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.RuntimeAnnotationHandler;
import com.sun.faces.el.ELUtils;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

class ResourceDependencyHandler
implements RuntimeAnnotationHandler {
    private ResourceDependency[] dependencies;
    private Map<ResourceDependency, Expressions> expressionsMap;

    public ResourceDependencyHandler(ResourceDependency[] dependencies) {
        this.dependencies = dependencies;
        this.expressionsMap = new HashMap<ResourceDependency, Expressions>(dependencies.length, 1.0f);
        for (ResourceDependency dep : dependencies) {
            String tgt;
            Expressions exprs = new Expressions();
            exprs.name = dep.name();
            String lib = dep.library();
            if (lib.length() > 0) {
                exprs.library = lib;
            }
            if ((tgt = dep.target()).length() > 0) {
                exprs.target = tgt;
            }
            this.expressionsMap.put(dep, exprs);
        }
    }

    public void apply(FacesContext ctx, Object ... params) {
        for (ResourceDependency dep : this.dependencies) {
            if (this.hasBeenProcessed(ctx, dep)) continue;
            this.pushResourceToRoot(ctx, this.createComponentResource(ctx, dep));
            this.markProcssed(ctx, dep);
        }
    }

    private void pushResourceToRoot(FacesContext ctx, UIComponent c) {
        ctx.getViewRoot().addComponentResource(ctx, c, (String)c.getAttributes().get("target"));
    }

    private boolean hasBeenProcessed(FacesContext ctx, ResourceDependency dep) {
        return ctx.getAttributes().containsKey(dep);
    }

    private UIComponent createComponentResource(FacesContext ctx, ResourceDependency dep) {
        Expressions exprs = this.expressionsMap.get(dep);
        Application app = ctx.getApplication();
        String resname = exprs.getName(ctx);
        UIComponent c = ctx.getApplication().createComponent("javax.faces.Output");
        c.setRendererType(app.getResourceHandler().getRendererTypeForResourceName(resname));
        Map attrs = c.getAttributes();
        attrs.put("name", resname);
        if (exprs.library != null) {
            attrs.put("library", exprs.getLibrary(ctx));
        }
        if (exprs.target != null) {
            attrs.put("target", exprs.getTarget(ctx));
        }
        return c;
    }

    private void markProcssed(FacesContext ctx, ResourceDependency dep) {
        ctx.getAttributes().put(dep, dep);
    }

    private static final class Expressions {
        ValueExpression nameExpression;
        ValueExpression libraryExpression;
        ValueExpression targetExpression;
        String name;
        String library;
        String target;

        private Expressions() {
        }

        String getName(FacesContext ctx) {
            if (this.nameExpression == null) {
                this.nameExpression = ELUtils.createValueExpression(this.name, String.class);
            }
            return (String)this.nameExpression.getValue(ctx.getELContext());
        }

        String getLibrary(FacesContext ctx) {
            if (this.library != null) {
                if (this.libraryExpression == null) {
                    this.libraryExpression = ELUtils.createValueExpression(this.library, String.class);
                }
                return (String)this.libraryExpression.getValue(ctx.getELContext());
            }
            return null;
        }

        String getTarget(FacesContext ctx) {
            if (this.target != null) {
                if (this.targetExpression == null) {
                    this.targetExpression = ELUtils.createValueExpression(this.target, String.class);
                }
                return (String)this.targetExpression.getValue(ctx.getELContext());
            }
            return null;
        }
    }
}

