/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AfterAddToParentEvent;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.render.Renderer;

@ListenerFor(systemEventClass=AfterAddToParentEvent.class)
public class StylesheetRenderer
extends Renderer
implements ComponentSystemEventListener {
    public static final String RENDERER_TYPE = "javax.faces.resource.Stylesheet";

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        FacesContext context = FacesContext.getCurrentInstance();
        context.getViewRoot().addComponentResource(context, component, "head");
    }

    public void decode(FacesContext context, UIComponent component) {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map attributes = component.getAttributes();
        Map contextMap = context.getAttributes();
        String name = (String)attributes.get("name");
        String library = (String)attributes.get("library");
        String key = name + library;
        if (contextMap.containsKey(key)) {
            return;
        }
        contextMap.put(key, Boolean.TRUE);
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("link", component);
        writer.writeAttribute("type", (Object)"text/css", "type");
        writer.writeAttribute("rel", (Object)"stylesheet", "rel");
        writer.writeAttribute("href", (Object)(resource != null ? resource.getRequestPath() : "RES_NOT_FOUND"), "href");
        writer.endElement("link");
    }
}

