/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MojarraThreadFactory;
import com.sun.faces.util.MultiKeyConcurrentHashMap;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class ResourceCache {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final int SHARED_THREAD_COUNT = 5;
    private static final int NON_SHARED_THREAD_COUNT = 1;
    private static ScheduledThreadPoolExecutor service;
    private MultiKeyConcurrentHashMap<String, ResourceInfo> resourceCache;
    private List<ResourceMonitor> monitors;
    private ScheduledFuture monitorTask;
    private String contextName;
    private boolean shutdown;

    public ResourceCache() {
        WebConfiguration config = WebConfiguration.getInstance();
        assert (config != null);
        ServletContext sc = config.getServletContext();
        this.contextName = ResourceCache.getServletContextIdentifier(sc);
        this.shutdown = false;
        long checkPeriod = this.getCheckPeriod(config);
        this.resourceCache = new MultiKeyConcurrentHashMap(30);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "ResourceCache constructed for {0}.  Check period is {1} minutes.", new Object[]{this.contextName, checkPeriod});
        }
        if (config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading) && checkPeriod >= 1L) {
            this.initExecutor(checkPeriod * 1000L * 60L);
            this.initMonitors(sc);
        }
    }

    public ResourceInfo add(ResourceInfo info) {
        if (this.shutdown) {
            throw new IllegalStateException("ResourceCache has been terminated");
        }
        Util.notNull("info", info);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Caching ResourceInfo: {0}", info.toString());
        }
        return this.resourceCache.putIfAbsent(info.name, info.libraryName, info.localePrefix, info);
    }

    public ResourceInfo get(String name, String libraryName, String localePrefix) {
        if (this.shutdown) {
            throw new IllegalStateException("ResourceCache has been terminated");
        }
        Util.notNull("name", name);
        return this.resourceCache != null ? this.resourceCache.get(name, libraryName, localePrefix) : null;
    }

    public void clear() {
        if (this.shutdown) {
            throw new IllegalStateException("ResourceCache has been terminated");
        }
        this.resourceCache.clear();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cache Cleared");
        }
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.resourceCache.clear();
        this.resourceCache = null;
        if (service != null) {
            if (this.monitorTask != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[{0}] Cancelling ResourceCache update task...", this.contextName);
                }
                this.monitorTask.cancel(true);
                this.monitorTask = null;
            }
            service.purge();
        }
    }

    private synchronized void initExecutor(long period) {
        if (service == null) {
            int poolSize = this.getThreadPoolSize();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Created new static ScheduledExecutorService with a pool size of {0}", poolSize);
            }
            service = new ScheduledThreadPoolExecutor(poolSize, new MojarraThreadFactory("ResourceCache"));
        }
        this.monitorTask = service.scheduleWithFixedDelay(new MonitorTask(this.contextName), period, period, TimeUnit.MILLISECONDS);
    }

    private int getThreadPoolSize() {
        int tc;
        ClassLoader thisClassLoader = ResourceCache.class.getClassLoader();
        boolean shared = thisClassLoader.equals(Thread.currentThread().getContextClassLoader());
        if (shared) {
            tc = Runtime.getRuntime().availableProcessors();
            if (tc > 5) {
                tc = 5;
            }
        } else {
            tc = 1;
        }
        return tc;
    }

    private Long getCheckPeriod(WebConfiguration webConfig) {
        String val = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceUpdateCheckPeriod);
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            return Long.parseLong(WebConfiguration.WebContextInitParameter.ResourceUpdateCheckPeriod.getDefaultValue());
        }
    }

    private void initMonitors(ServletContext sc) {
        block8: {
            this.monitors = new ArrayList<ResourceMonitor>();
            this.monitors.add(new WebappResourceMonitor(sc, "/resources/"));
            this.monitors.add(new WebappResourceMonitor(sc, "/WEB-INF/classes/META-INF/resources/"));
            ClassLoader loader = Util.getCurrentLoader(this.getClass());
            try {
                Enumeration<URL> urls = loader.getResources("META-INF/resources");
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (!"jar".equals(url.getProtocol())) {
                        String urlString = url.toString();
                        if (urlString.contains("/WEB-INF/classes/META-INF/resources") || urlString.contains("jsf-ri-runtime.xml") || !LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.log(Level.WARNING, "Unhandled URL: {0}", url);
                        continue;
                    }
                    if (url.toString().contains("jsf-impl.jar")) continue;
                    try {
                        this.monitors.add(new JarResourceMonitor(url));
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "IOException occurred setting up JarResourceMonitor for URL {0}.  Updates to this resource will be ignored.", url.toExternalForm());
                    }
                }
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                LOGGER.log(Level.SEVERE, "Classpath resource monitoring unavailable.", ioe);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "[{0}] Registered ResouceMonitors:", sc.getContextPath());
            for (ResourceMonitor monitor : this.monitors) {
                LOGGER.log(Level.FINE, monitor.toString());
            }
        }
    }

    private static String getServletContextIdentifier(ServletContext context) {
        if (context.getMajorVersion() == 2 && context.getMinorVersion() < 5) {
            return context.getServletContextName();
        }
        return context.getContextPath();
    }

    private static class JarResourceMonitor
    implements ResourceMonitor {
        private URL jarFileURL;
        private long currentTimeStamp;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JarResourceMonitor(URL url) throws IOException {
            Util.notNull("url", url);
            if (!"jar".equals(url.getProtocol())) {
                throw new IllegalArgumentException("URL protocol must be 'jar' -> " + url.toExternalForm());
            }
            InputStream in = null;
            try {
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.connect();
                in = conn.getInputStream();
                this.jarFileURL = ((JarURLConnection)conn).getJarFileURL();
                if (this.jarFileURL == null) {
                    throw new IllegalStateException("Unable to obtain URL to Jar");
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.currentTimeStamp = this.getLastModified();
        }

        public boolean hasBeenModified() {
            long ts = this.getLastModified();
            if (ts > this.currentTimeStamp) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Timestamp for JAR ({0}) changed.", this.jarFileURL.toExternalForm());
                }
                this.currentTimeStamp = ts;
                return true;
            }
            return false;
        }

        public String toString() {
            return "[JarResourceMonitor] Monitoring->" + this.jarFileURL.toExternalForm();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getLastModified() {
            InputStream in = null;
            try {
                URLConnection conn = this.jarFileURL.openConnection();
                conn.connect();
                in = conn.getInputStream();
                long l = conn.getLastModified();
                return l;
            }
            catch (IOException ioe) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to check JAR timestamp.", ioe);
                }
                long l = this.currentTimeStamp;
                return l;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WebappResourceMonitor
    implements ResourceMonitor {
        private Map<String, Set<String>> layout;
        private ServletContext sc;
        private String startPath;
        private String contextPath;

        public WebappResourceMonitor(ServletContext sc, String startPath) {
            if (startPath.charAt(0) != '/' && startPath.charAt(startPath.length() - 1) != '/') {
                throw new IllegalArgumentException("startPath must start and end with '/'");
            }
            this.startPath = startPath;
            this.sc = sc;
            this.contextPath = ResourceCache.getServletContextIdentifier(sc);
            this.layout = new HashMap<String, Set<String>>();
            this.createSnapshot(this.layout);
        }

        @Override
        public boolean hasBeenModified() {
            boolean modified;
            HashMap<String, Set<String>> temp = new HashMap<String, Set<String>>();
            this.createSnapshot(temp);
            boolean bl = modified = !((Object)this.layout).equals(temp);
            if (modified) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[{0}] Change detected in webapp filesystem", new Object[]{this.contextPath, this.startPath});
                }
                this.layout = temp;
            }
            return modified;
        }

        public String toString() {
            return "[WebappResourceMonitor] Monitoring->" + this.contextPath + ':' + this.startPath;
        }

        private void createSnapshot(Map<String, Set<String>> target) {
            this.createSnapshot(target, this.startPath);
        }

        private void createSnapshot(Map<String, Set<String>> target, String startPath) {
            Set paths = this.sc.getResourcePaths(startPath);
            if (paths == null) {
                return;
            }
            target.put(startPath, paths);
            for (String path : paths) {
                if (path.charAt(path.length() - 1) != '/') continue;
                this.createSnapshot(target, path);
            }
        }
    }

    private static interface ResourceMonitor {
        public boolean hasBeenModified();
    }

    private final class MonitorTask
    implements Runnable {
        private final String contextPath;

        public MonitorTask(String contextPath) {
            this.contextPath = contextPath;
        }

        public void run() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "[{0}] Starting modification search", this.contextPath);
            }
            for (ResourceMonitor monitor : ResourceCache.this.monitors) {
                if (!monitor.hasBeenModified()) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[{0}] Modifications found, clearing cache", this.contextPath);
                }
                ResourceCache.this.resourceCache.clear();
                return;
            }
        }
    }
}

