/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.saml.v2.response;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLProtocolFactory;
import org.jboss.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.saml.v2.util.JAXBElementMappingUtil;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeType;
import org.jboss.identity.federation.saml.v2.assertion.ConditionsType;
import org.jboss.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2Response {
    public AttributeStatementType createAttributeStatement(List<String> roles) {
        AttributeStatementType attrStatement = JBossSAMLBaseFactory.createAttributeStatement();
        for (String role : roles) {
            AttributeType attr = JBossSAMLBaseFactory.createAttributeForRole((String)role);
            attrStatement.getAttributeOrEncryptedAttribute().add(attr);
        }
        return attrStatement;
    }

    public ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo) throws Exception {
        return JBossSAMLAuthnResponseFactory.createResponseType((String)ID, (SPInfoHolder)sp, (IDPInfoHolder)idp, (IssuerInfoHolder)issuerInfo);
    }

    public ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertion) throws Exception {
        return JBossSAMLAuthnResponseFactory.createResponseType((String)ID, (IssuerInfoHolder)issuerInfo, (AssertionType)assertion);
    }

    public void createTimedConditions(AssertionType assertion, long durationInMilis) throws Exception {
        XMLGregorianCalendar issueInstant = assertion.getIssueInstant();
        if (issueInstant == null) {
            throw new IllegalStateException("assertion does not have issue instant");
        }
        XMLGregorianCalendar assertionValidityLength = XMLTimeUtil.add((XMLGregorianCalendar)issueInstant, (long)durationInMilis);
        ConditionsType conditionsType = JBossSAMLBaseFactory.getObjectFactory().createConditionsType();
        conditionsType.setNotBefore(issueInstant);
        conditionsType.setNotOnOrAfter(assertionValidityLength);
        assertion.setConditions(conditionsType);
    }

    public EncryptedElementType getEncryptedAssertion(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Unmarshaller un = JBossSAMLAuthnResponseFactory.getValidatingUnmarshaller();
        JAXBElement jaxb = (JAXBElement)un.unmarshal(is);
        return (EncryptedElementType)jaxb.getValue();
    }

    public AssertionType getAssertionType(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Unmarshaller un = JBossSAMLAuthnResponseFactory.getValidatingUnmarshaller();
        JAXBElement jaxb = (JAXBElement)un.unmarshal(is);
        return (AssertionType)jaxb.getValue();
    }

    public ResponseType getResponseType(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Unmarshaller un = JBossSAMLAuthnResponseFactory.getValidatingUnmarshaller();
        JAXBElement jaxbAuthnRequestType = (JAXBElement)un.unmarshal(is);
        return (ResponseType)jaxbAuthnRequestType.getValue();
    }

    public Document convert(EncryptedElementType encryptedElementType) throws Exception {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{EncryptedElementType.class});
        Binder binder = jaxb.createBinder();
        Document doc = DocumentUtil.createDocument();
        binder.marshal((Object)JAXBElementMappingUtil.get((EncryptedElementType)encryptedElementType), (Object)doc);
        return doc;
    }

    public Document convert(ResponseType responseType) throws Exception {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
        Binder binder = jaxb.createBinder();
        Document doc = DocumentUtil.createDocument();
        binder.marshal((Object)JAXBElementMappingUtil.get((ResponseType)responseType), (Object)doc);
        return doc;
    }

    public void marshall(ResponseType responseType, OutputStream os) throws Exception {
        Marshaller marshaller = JBossSAMLAuthnResponseFactory.getValidatingMarshaller();
        JAXBElement jaxb = SAMLProtocolFactory.getObjectFactory().createResponse(responseType);
        marshaller.marshal((Object)jaxb, os);
    }

    public void marshall(ResponseType responseType, Writer writer) throws Exception {
        Marshaller marshaller = JBossSAMLAuthnResponseFactory.getValidatingMarshaller();
        JAXBElement jaxb = SAMLProtocolFactory.getObjectFactory().createResponse(responseType);
        marshaller.marshal((Object)jaxb, writer);
    }
}

