/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.util;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLEncryptionUtil {
    public static final String CIPHER_DATA_LOCALNAME = "CipherData";
    public static final String ENCRYPTED_KEY_LOCALNAME = "EncryptedKey";
    public static final String DS_KEY_INFO = "ds:KeyInfo";
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    public static String XMLSIG_NS = JBossSAMLURIConstants.XMLDSIG_NSURI.get();
    public static String XMLENC_NS = JBossSAMLURIConstants.XMLENC_NSURI.get();

    public static EncryptedKey encryptKey(Document document, SecretKey keyToBeEncrypted, PublicKey keyUsedToEncryptSecretKey, int keySize) throws Exception {
        XMLCipher keyCipher = null;
        String pubKeyAlg = keyUsedToEncryptSecretKey.getAlgorithm();
        String keyWrapAlgo = XMLEncryptionUtil.getXMLEncryptionURLForKeyUnwrap(pubKeyAlg, keySize);
        keyCipher = XMLCipher.getInstance((String)keyWrapAlgo);
        keyCipher.init(3, (Key)keyUsedToEncryptSecretKey);
        return keyCipher.encryptKey(document, (Key)keyToBeEncrypted);
    }

    public static void encryptElement(QName elementQName, Document document, PublicKey publicKey, SecretKey secretKey, int keySize, QName wrappingElementQName, boolean addEncryptedKeyInKeyInfo) throws Exception {
        if (elementQName == null) {
            throw new IllegalArgumentException("elementQName is null");
        }
        if (document == null) {
            throw new IllegalArgumentException("document is null");
        }
        String wrappingElementPrefix = wrappingElementQName.getPrefix();
        if (wrappingElementPrefix == null || wrappingElementPrefix == "") {
            throw new IllegalArgumentException("Wrapping element prefix invalid");
        }
        NodeList elements = document.getElementsByTagName(elementQName.toString());
        if (elements == null || elements.getLength() > 1) {
            throw new IllegalStateException("Element was either null or more than one:" + elements);
        }
        Element documentElement = (Element)elements.item(0);
        if (documentElement == null) {
            throw new IllegalStateException("Element could not be found in the document:" + elementQName.toString());
        }
        XMLCipher cipher = null;
        EncryptedKey encryptedKey = XMLEncryptionUtil.encryptKey(document, secretKey, publicKey, keySize);
        String encryptionAlgorithm = XMLEncryptionUtil.getXMLEncryptionURL(secretKey.getAlgorithm(), keySize);
        cipher = XMLCipher.getInstance((String)encryptionAlgorithm);
        cipher.init(1, (Key)secretKey);
        Document encryptedDoc = cipher.doFinal(document, documentElement);
        Element encryptedKeyElement = cipher.martial(document, encryptedKey);
        String wrappingElementName = wrappingElementPrefix + ":" + wrappingElementQName.getLocalPart();
        Element wrappingElement = encryptedDoc.createElementNS(wrappingElementQName.getNamespaceURI(), wrappingElementName);
        if (wrappingElementPrefix == null || wrappingElementPrefix == "") {
            wrappingElementName = wrappingElementQName.getLocalPart();
        }
        wrappingElement.setAttributeNS(XMLNS, "xmlns:" + wrappingElementPrefix, wrappingElementQName.getNamespaceURI());
        NodeList cipherElements = encryptedDoc.getElementsByTagNameNS(XMLENC_NS, "EncryptedData");
        if (cipherElements == null || cipherElements.getLength() == 0) {
            throw new IllegalStateException("xenc:EncryptedData Element Missing");
        }
        Element encryptedDataElement = (Element)cipherElements.item(0);
        Node parentOfEncNode = encryptedDataElement.getParentNode();
        parentOfEncNode.replaceChild(wrappingElement, encryptedDataElement);
        wrappingElement.appendChild(encryptedDataElement);
        if (addEncryptedKeyInKeyInfo) {
            Element sigElement = encryptedDoc.createElementNS(XMLSIG_NS, DS_KEY_INFO);
            sigElement.setAttributeNS(XMLNS, "xmlns:ds", XMLSIG_NS);
            sigElement.appendChild(encryptedKeyElement);
            NodeList nodeList = encryptedDoc.getElementsByTagNameNS(XMLENC_NS, CIPHER_DATA_LOCALNAME);
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new IllegalStateException("xenc:CipherData Element Missing");
            }
            Element cipherDataElement = (Element)nodeList.item(0);
            Node cipherParent = cipherDataElement.getParentNode();
            cipherParent.insertBefore(sigElement, cipherDataElement);
        } else {
            wrappingElement.appendChild(encryptedKeyElement);
        }
    }

    public static Element encryptElementInDocument(Document document, PublicKey publicKey, SecretKey secretKey, int keySize, QName wrappingElementQName, boolean addEncryptedKeyInKeyInfo) throws Exception {
        String wrappingElementPrefix = wrappingElementQName.getPrefix();
        if (wrappingElementPrefix == null || wrappingElementPrefix == "") {
            throw new IllegalArgumentException("Wrapping element prefix invalid");
        }
        XMLCipher cipher = null;
        EncryptedKey encryptedKey = XMLEncryptionUtil.encryptKey(document, secretKey, publicKey, keySize);
        String encryptionAlgorithm = XMLEncryptionUtil.getXMLEncryptionURL(secretKey.getAlgorithm(), keySize);
        cipher = XMLCipher.getInstance((String)encryptionAlgorithm);
        cipher.init(1, (Key)secretKey);
        Document encryptedDoc = cipher.doFinal(document, document.getDocumentElement());
        Element encryptedKeyElement = cipher.martial(document, encryptedKey);
        String wrappingElementName = wrappingElementPrefix + ":" + wrappingElementQName.getLocalPart();
        Element wrappingElement = encryptedDoc.createElementNS(wrappingElementQName.getNamespaceURI(), wrappingElementName);
        if (wrappingElementPrefix == null || wrappingElementPrefix == "") {
            wrappingElementName = wrappingElementQName.getLocalPart();
        }
        wrappingElement.setAttributeNS(XMLNS, "xmlns:" + wrappingElementPrefix, wrappingElementQName.getNamespaceURI());
        Element encryptedDocRootElement = encryptedDoc.getDocumentElement();
        encryptedDoc.replaceChild(wrappingElement, encryptedDocRootElement);
        wrappingElement.appendChild(encryptedDocRootElement);
        if (addEncryptedKeyInKeyInfo) {
            Element sigElement = encryptedDoc.createElementNS(XMLSIG_NS, DS_KEY_INFO);
            sigElement.setAttributeNS(XMLNS, "xmlns:ds", XMLSIG_NS);
            sigElement.appendChild(encryptedKeyElement);
            NodeList nodeList = encryptedDocRootElement.getElementsByTagNameNS(XMLENC_NS, CIPHER_DATA_LOCALNAME);
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new IllegalStateException("xenc:CipherData Element Missing");
            }
            Element cipherDataElement = (Element)nodeList.item(0);
            encryptedDocRootElement.insertBefore(sigElement, cipherDataElement);
        } else {
            wrappingElement.appendChild(encryptedKeyElement);
        }
        return encryptedDoc.getDocumentElement();
    }

    public static Element decryptElementInDocument(Document documentWithEncryptedElement, PrivateKey privateKey) throws Exception {
        Element decryptedRoot;
        Element dataElement;
        if (documentWithEncryptedElement == null) {
            throw new IllegalArgumentException("Input document is null");
        }
        Element documentRoot = documentWithEncryptedElement.getDocumentElement();
        Element encDataElement = XMLEncryptionUtil.getNextElementNode(documentRoot.getFirstChild());
        if (encDataElement == null) {
            throw new IllegalStateException("No element representing the encrypted data found");
        }
        Element encKeyElement = XMLEncryptionUtil.getNextElementNode(encDataElement.getNextSibling());
        if (encKeyElement == null) {
            NodeList nodeList = encDataElement.getElementsByTagNameNS(XMLENC_NS, ENCRYPTED_KEY_LOCALNAME);
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new IllegalStateException("Encrypted Key not found in the enc data");
            }
            encKeyElement = (Element)nodeList.item(0);
        }
        XMLCipher cipher = XMLCipher.getInstance();
        cipher.init(2, null);
        EncryptedData encryptedData = cipher.loadEncryptedData(documentWithEncryptedElement, encDataElement);
        EncryptedKey encryptedKey = cipher.loadEncryptedKey(documentWithEncryptedElement, encKeyElement);
        Document decryptedDoc = null;
        if (encryptedData != null && encryptedKey != null) {
            String encAlgoURL = encryptedData.getEncryptionMethod().getAlgorithm();
            XMLCipher keyCipher = XMLCipher.getInstance();
            keyCipher.init(4, (Key)privateKey);
            Key encryptionKey = keyCipher.decryptKey(encryptedKey, encAlgoURL);
            cipher = XMLCipher.getInstance();
            cipher.init(2, encryptionKey);
            decryptedDoc = cipher.doFinal(documentWithEncryptedElement, encDataElement);
        }
        if ((dataElement = XMLEncryptionUtil.getNextElementNode((decryptedRoot = decryptedDoc.getDocumentElement()).getFirstChild())) == null) {
            throw new IllegalStateException("Data Element after encryption is null");
        }
        decryptedRoot.removeChild(dataElement);
        decryptedDoc.replaceChild(dataElement, decryptedRoot);
        return decryptedDoc.getDocumentElement();
    }

    private static String getXMLEncryptionURLForKeyUnwrap(String publicKeyAlgo, int keySize) {
        if ("AES".equals(publicKeyAlgo)) {
            switch (keySize) {
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
                }
            }
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }
        if (publicKeyAlgo.contains("RSA")) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        if (publicKeyAlgo.contains("DES")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }
        throw new IllegalArgumentException("unsupported publicKey Algo:" + publicKeyAlgo);
    }

    private static String getXMLEncryptionURL(String algo, int keySize) {
        if ("AES".equals(algo)) {
            switch (keySize) {
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
                }
            }
            return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        }
        if (algo.contains("RSA")) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        if (algo.contains("DES")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }
        throw new IllegalArgumentException("Secret Key with unsupported algo:" + algo);
    }

    private static Element getNextElementNode(Node node) {
        while (node != null) {
            if (1 == node.getNodeType()) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    static {
        Init.init();
    }
}

