/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust;

import org.jboss.identity.federation.api.wstrust.STSConfiguration;
import org.jboss.identity.federation.api.wstrust.WSTrustRequestHandler;

public class WSTrustServiceFactory {
    private static final WSTrustServiceFactory factory = new WSTrustServiceFactory();

    private WSTrustServiceFactory() {
    }

    public static WSTrustServiceFactory getInstance() {
        return factory;
    }

    public WSTrustRequestHandler createRequestHandler(STSConfiguration configuration) {
        String handlerClassName = "org.jboss.identity.federation.api.wstrust.JBossWSTrustRequestHandler";
        try {
            Class<?> handlerClass = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            handlerClass = loader == null ? Class.forName(handlerClassName) : loader.loadClass(handlerClassName);
            WSTrustRequestHandler handler = (WSTrustRequestHandler)handlerClass.newInstance();
            handler.initialize(configuration);
            return handler;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

