/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.openid;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.identity.federation.api.openid.OpenIDAttributeMap;
import org.jboss.identity.federation.api.openid.OpenIDConstants;
import org.jboss.identity.federation.api.openid.OpenIDLifecycle;
import org.jboss.identity.federation.api.openid.OpenIDLifecycleEvent;
import org.jboss.identity.federation.api.openid.OpenIDProtocolAdapter;
import org.jboss.identity.federation.api.openid.OpenIDRequest;
import org.jboss.identity.federation.api.openid.exceptions.OpenIDAssociationException;
import org.jboss.identity.federation.api.openid.exceptions.OpenIDConsumerException;
import org.jboss.identity.federation.api.openid.exceptions.OpenIDDiscoveryException;
import org.jboss.identity.federation.api.openid.exceptions.OpenIDLifeCycleException;
import org.jboss.identity.federation.api.openid.exceptions.OpenIDMessageException;
import org.jboss.identity.federation.api.openid.exceptions.OpenIDProtocolException;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.sreg.SRegRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIDManager {
    private OpenIDRequest request = null;
    private ConsumerManager consumerManager = null;
    private String userString = null;

    public OpenIDManager(OpenIDRequest theReq) {
        this.request = theReq;
        try {
            this.consumerManager = new ConsumerManager();
            this.consumerManager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
            this.consumerManager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
            this.userString = this.request.getURL();
        }
        catch (ConsumerException ce) {
            throw new RuntimeException(ce);
        }
    }

    public OpenIDRequest getOpenIDRequest() {
        return this.request;
    }

    public OpenIDProviderList discoverProviders() throws OpenIDDiscoveryException, OpenIDConsumerException {
        List discoveries;
        try {
            discoveries = this.consumerManager.discover(this.userString);
        }
        catch (DiscoveryException e1) {
            throw new OpenIDDiscoveryException(e1);
        }
        return new OpenIDProviderList(discoveries);
    }

    public OpenIDProviderInformation associate(OpenIDProtocolAdapter adapter, OpenIDProviderList listOfProviders) throws OpenIDConsumerException, OpenIDLifeCycleException {
        List<DiscoveryInformation> discoveries;
        OpenIDLifecycle lifeCycle = null;
        if (adapter instanceof OpenIDLifecycle) {
            lifeCycle = (OpenIDLifecycle)((Object)adapter);
        }
        if ((discoveries = listOfProviders.get()).size() == 0) {
            throw new OpenIDConsumerException("No open id endpoints discovered");
        }
        DiscoveryInformation discovered = this.consumerManager.associate(discoveries);
        if (lifeCycle != null) {
            OpenIDLifecycleEvent ev = new OpenIDLifecycleEvent(OpenIDLifecycleEvent.TYPE.SESSION, OpenIDLifecycleEvent.OP.ADD, CONST.OPENID_DISC.get(), discovered);
            lifeCycle.handle(ev);
        }
        return new OpenIDProviderInformation(discovered);
    }

    public boolean authenticate(OpenIDProtocolAdapter adapter, OpenIDProviderInformation providerInfo) throws OpenIDDiscoveryException, OpenIDConsumerException, OpenIDMessageException, OpenIDProtocolException {
        DiscoveryInformation discovered = providerInfo.get();
        try {
            AuthRequest authReq = this.consumerManager.authenticate(discovered, adapter.getReturnURL());
            FetchRequest fetch = FetchRequest.createFetchRequest();
            SRegRequest sregReq = SRegRequest.createFetchRequest();
            OpenIDAttributeMap amap = adapter.getAttributeMap();
            if ("1".equals(amap.get("nickname"))) {
                sregReq.addAttribute("nickname", false);
            }
            if ("1".equals(amap.get("email"))) {
                fetch.addAttribute("email", OpenIDConstants.EMAIL.url(), false);
                sregReq.addAttribute("email", false);
            }
            if ("1".equals(amap.get("fullname"))) {
                fetch.addAttribute("fullname", OpenIDConstants.FULLNAME.url(), false);
                sregReq.addAttribute("fullname", false);
            }
            if ("1".equals(amap.get("dob"))) {
                fetch.addAttribute("dob", OpenIDConstants.DOB.url(), true);
                sregReq.addAttribute("dob", false);
            }
            if ("1".equals(amap.get("gender"))) {
                fetch.addAttribute("gender", OpenIDConstants.GENDER.url(), false);
                sregReq.addAttribute("gender", false);
            }
            if ("1".equals(amap.get("postcode"))) {
                fetch.addAttribute("postcode", OpenIDConstants.POSTCODE.url(), false);
                sregReq.addAttribute("postcode", false);
            }
            if ("1".equals(amap.get("country"))) {
                fetch.addAttribute("country", OpenIDConstants.COUNTRY.url(), false);
                sregReq.addAttribute("country", false);
            }
            if ("1".equals(amap.get("language"))) {
                fetch.addAttribute("language", OpenIDConstants.LANGUAGE.url(), false);
                sregReq.addAttribute("language", false);
            }
            if ("1".equals(amap.get("timezone"))) {
                fetch.addAttribute("timezone", OpenIDConstants.TIMEZONE.url(), false);
                sregReq.addAttribute("timezone", false);
            }
            if (!sregReq.getAttributes().isEmpty()) {
                authReq.addExtension((MessageExtension)sregReq);
            }
            if (!discovered.isVersion2()) {
                adapter.sendToProvider(1, authReq.getDestinationUrl(true), null);
                return false;
            }
            adapter.sendToProvider(2, authReq.getDestinationUrl(false), authReq.getParameterMap());
        }
        catch (MessageException e) {
            throw new OpenIDMessageException(e);
        }
        catch (ConsumerException e) {
            throw new OpenIDConsumerException(e);
        }
        return false;
    }

    public boolean verify(OpenIDProtocolAdapter adapter, Map<String, String> parameterMap, String receivedURL) throws OpenIDMessageException, OpenIDDiscoveryException, OpenIDAssociationException, OpenIDLifeCycleException {
        OpenIDLifecycle lifeCycle = null;
        if (adapter instanceof OpenIDLifecycle) {
            lifeCycle = (OpenIDLifecycle)((Object)adapter);
        }
        ParameterList responselist = new ParameterList(parameterMap);
        if (lifeCycle == null) {
            throw new IllegalStateException("Lifecycle not found");
        }
        DiscoveryInformation discovered = (DiscoveryInformation)lifeCycle.getAttributeValue(CONST.OPENID_DISC.get());
        try {
            VerificationResult verification = this.consumerManager.verify(receivedURL, responselist, discovered);
            Identifier verified = verification.getVerifiedId();
            if (verified != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                OpenIDLifecycleEvent[] eventArr = new OpenIDLifecycleEvent[]{new OpenIDLifecycleEvent(OpenIDLifecycleEvent.TYPE.SESSION, OpenIDLifecycleEvent.OP.ADD, CONST.OPENID.get(), authSuccess.getIdentity()), new OpenIDLifecycleEvent(OpenIDLifecycleEvent.TYPE.SESSION, OpenIDLifecycleEvent.OP.ADD, CONST.OPENID_CLAIMED.get(), authSuccess.getClaimed()), new OpenIDLifecycleEvent(OpenIDLifecycleEvent.TYPE.SUCCESS, null, null, null)};
                lifeCycle.handle(eventArr);
                return true;
            }
        }
        catch (MessageException e) {
            throw new OpenIDMessageException(e);
        }
        catch (DiscoveryException e) {
            throw new OpenIDDiscoveryException(e);
        }
        catch (AssociationException e) {
            throw new OpenIDAssociationException(e);
        }
        return false;
    }

    public void logout(OpenIDProtocolAdapter adapter) throws OpenIDLifeCycleException {
        OpenIDLifecycle lifeCycle = null;
        if (adapter instanceof OpenIDLifecycle) {
            lifeCycle = (OpenIDLifecycle)((Object)adapter);
        }
        if (lifeCycle != null) {
            lifeCycle.handle(new OpenIDLifecycleEvent(OpenIDLifecycleEvent.TYPE.SESSION, OpenIDLifecycleEvent.OP.REMOVE, CONST.OPENID.get(), null));
            lifeCycle.handle(new OpenIDLifecycleEvent(OpenIDLifecycleEvent.TYPE.SESSION, OpenIDLifecycleEvent.OP.REMOVE, CONST.OPENID_CLAIMED.get(), null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenIDProviderList {
        private List<DiscoveryInformation> providers = null;

        OpenIDProviderList(List<DiscoveryInformation> providers) {
            this.providers = providers;
        }

        List<DiscoveryInformation> get() {
            return Collections.unmodifiableList(this.providers);
        }

        public int size() {
            return this.providers != null ? this.providers.size() : 0;
        }
    }

    public static class OpenIDProviderInformation {
        private DiscoveryInformation discovered;

        OpenIDProviderInformation(DiscoveryInformation di) {
            this.discovered = di;
        }

        DiscoveryInformation get() {
            return this.discovered;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CONST {
        OPENID("openid"),
        OPENID_CLAIMED("openid-claimed"),
        OPENID_DISC("openid-discovered");

        private String val;

        private CONST(String val) {
            this.val = val;
        }

        public String get() {
            return this.val;
        }
    }
}

