/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.saml.v2.metadata;

import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.federation.saml.v2.assertion.AttributeType;
import org.jboss.identity.federation.saml.v2.metadata.EndpointType;
import org.jboss.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.jboss.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.jboss.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.jboss.identity.federation.saml.v2.metadata.LocalizedNameType;
import org.jboss.identity.federation.saml.v2.metadata.LocalizedURIType;
import org.jboss.identity.federation.saml.v2.metadata.ObjectFactory;
import org.jboss.identity.federation.saml.v2.metadata.OrganizationType;
import org.jboss.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.jboss.identity.federation.saml.v2.metadata.SSODescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataBuilder {
    private static ObjectFactory oFact = new ObjectFactory();
    private static String pkgName = "org.jboss.identity.federation.saml.v2.metadata";

    public static EndpointType createEndpoint(String binding, String location, String responseLocation) {
        EndpointType endpoint = oFact.createEndpointType();
        endpoint.setBinding(binding);
        endpoint.setLocation(location);
        endpoint.setResponseLocation(responseLocation);
        return endpoint;
    }

    public static OrganizationType createOrganization(String organizationName, String organizationDisplayName, String organizationURL, String lang) {
        if (organizationName == null) {
            throw new IllegalArgumentException("organizationName is null");
        }
        if (organizationDisplayName == null) {
            throw new IllegalArgumentException("organizationDisplayName is null");
        }
        if (organizationURL == null) {
            throw new IllegalArgumentException("organizationURL is null");
        }
        if (lang == null) {
            lang = JBossSAMLConstants.LANG_EN.get();
        }
        LocalizedNameType orgName = oFact.createLocalizedNameType();
        orgName.setValue(organizationName);
        orgName.setLang(lang);
        LocalizedNameType orgDisplayName = oFact.createLocalizedNameType();
        orgDisplayName.setValue(organizationDisplayName);
        orgDisplayName.setLang(lang);
        LocalizedURIType orgURL = oFact.createLocalizedURIType();
        orgURL.setValue(organizationURL);
        orgURL.setLang(lang);
        OrganizationType orgType = oFact.createOrganizationType();
        orgType.getOrganizationName().add(orgName);
        orgType.getOrganizationDisplayName().add(orgDisplayName);
        orgType.getOrganizationURL().add(orgURL);
        return orgType;
    }

    public static EntityDescriptorType createEntityDescriptor(SSODescriptorType idpOrSPDescriptor) {
        EntityDescriptorType entity = oFact.createEntityDescriptorType();
        entity.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().add(idpOrSPDescriptor);
        return entity;
    }

    public static IDPSSODescriptorType createIDPSSODescriptor(boolean requestsSigned, KeyDescriptorType keyDescriptorType, EndpointType ssoEndPoint, EndpointType sloEndPoint, List<AttributeType> attributes, OrganizationType org) {
        IDPSSODescriptorType idp = oFact.createIDPSSODescriptorType();
        idp.getSingleSignOnService().add(ssoEndPoint);
        idp.getSingleLogoutService().add(sloEndPoint);
        idp.getAttribute().addAll(attributes);
        idp.getKeyDescriptor().add(keyDescriptorType);
        idp.setWantAuthnRequestsSigned(Boolean.valueOf(requestsSigned));
        idp.setOrganization(org);
        return idp;
    }

    public static SPSSODescriptorType createSPSSODescriptor(boolean requestsSigned, KeyDescriptorType keyDescriptorType, EndpointType sloEndPoint, List<AttributeType> attributes, OrganizationType org) {
        SPSSODescriptorType sp = oFact.createSPSSODescriptorType();
        sp.getSingleLogoutService().add(sloEndPoint);
        sp.getKeyDescriptor().add(keyDescriptorType);
        sp.setAuthnRequestsSigned(Boolean.valueOf(requestsSigned));
        sp.setOrganization(org);
        return sp;
    }

    public static Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.getMarshaller((String)pkgName);
    }

    public static Unmarshaller getUnmarshaller() throws JAXBException {
        return JAXBUtil.getUnmarshaller((String)pkgName);
    }

    public static ObjectFactory getObjectFactory() {
        return oFact;
    }
}

