/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.deployers;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.hibernate.deployers.metadata.HibernateMetaData;
import org.jboss.hibernate.deployers.metadata.SessionFactoryMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDeployer
extends AbstractSimpleRealDeployer<HibernateMetaData> {
    private boolean scanFromTop;

    public HibernateDeployer() {
        super(HibernateMetaData.class);
        this.setOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit, HibernateMetaData metaData) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        SessionFactoryMetaData sessionFactoryMetaData = metaData.getSessionFactory();
        if (sessionFactoryMetaData == null) {
            return;
        }
        VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
        if (this.scanFromTop) {
            vfsUnit = vfsUnit.getTopLevel();
        }
        BeanMetaData beanMetaData = sessionFactoryMetaData.getBeanMetaData(vfsUnit.getRoot());
        vfsUnit.addAttachment(BeanMetaData.class + "$Hibernate", (Object)beanMetaData);
        this.log.info((Object)("Created Hibernate bean: " + beanMetaData));
    }

    public void setScanFromTop(boolean scanFromTop) {
        this.scanFromTop = scanFromTop;
    }
}

