/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.proxy;

import gov.nist.javax.sip.address.SipUri;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.SLEEException;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.Tracer;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import net.java.slee.resource.sip.CancelRequestEvent;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.services.sip.common.MessageHandlerInterface;
import org.mobicents.slee.services.sip.common.MessageUtils;
import org.mobicents.slee.services.sip.common.ProxyConfiguration;
import org.mobicents.slee.services.sip.common.SipLoopDetectedException;
import org.mobicents.slee.services.sip.common.SipSendErrorResponseException;
import org.mobicents.slee.services.sip.location.LocationSbbLocalObject;
import org.mobicents.slee.services.sip.location.LocationService;
import org.mobicents.slee.services.sip.location.LocationServiceException;
import org.mobicents.slee.services.sip.location.RegistrationBinding;
import org.mobicents.slee.services.sip.proxy.ProxySbbActivityContextInterface;
import org.mobicents.slee.services.sip.proxy.mbean.ProxyConfigurator;

public abstract class ProxySbb
implements Sbb {
    private Tracer logger;
    private static final ProxyConfigurator proxyConfigurator = new ProxyConfigurator();
    private SbbContext sbbContext;
    private Context myEnv;
    private SleeSipProvider provider = null;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SipActivityContextInterfaceFactory acif;

    public InitialEventSelector callIDSelect(InitialEventSelector ies) {
        Object event = ies.getEvent();
        String callId = null;
        if (event instanceof ResponseEvent) {
            ies.setInitialEvent(false);
            return ies;
        }
        if (event instanceof RequestEvent) {
            Request request = ((RequestEvent)event).getRequest();
            callId = !request.getMethod().equals("ACK") ? ((ViaHeader)request.getHeaders("Via").next()).getBranch() : ((ViaHeader)request.getHeaders("Via").next()).getBranch() + "_ACK";
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Setting convergence name to: " + callId);
        }
        ies.setCustomName(callId);
        return ies;
    }

    public abstract ChildRelation getRegistrarSbbChildRelation();

    public abstract ChildRelation getLocationSbbChildRelation();

    public LocationSbbLocalObject getLocationSbb() throws TransactionRequiredLocalException, SLEEException, CreateException {
        ChildRelation childRelation = this.getLocationSbbChildRelation();
        if (childRelation.isEmpty()) {
            return (LocationSbbLocalObject)childRelation.create();
        }
        return (LocationSbbLocalObject)childRelation.iterator().next();
    }

    public abstract ProxySbbActivityContextInterface asSbbActivityContextInterface(ActivityContextInterface var1);

    public abstract void setConfiguration(ProxyConfigurator var1);

    public abstract ProxyConfigurator getConfiguration();

    public abstract boolean getServerTransactionTerminated();

    public abstract void setServerTransactionTerminated(boolean var1);

    public abstract void setForwardedInviteViaHeader(ViaHeader var1);

    public abstract ViaHeader getForwardedInviteViaHeader();

    public void onServiceStarted(ServiceStartedEvent serviceEvent, ActivityContextInterface aci) {
        try {
            ServiceActivity sa = ((ServiceActivityFactory)this.myEnv.lookup("java:comp/env/slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity())) {
                this.startMBeanConfigurator();
            } else {
                aci.detach(this.sbbContext.getSbbLocalObject());
            }
        }
        catch (Exception e) {
            this.logger.severe("Failed to start service", (Throwable)e);
        }
    }

    private void startMBeanConfigurator() {
        int i;
        String[] tmp;
        proxyConfigurator.setSipHostName(this.provider.getListeningPoints()[0].getIPAddress());
        proxyConfigurator.setSipPort(this.provider.getListeningPoints()[0].getPort());
        proxyConfigurator.setSipTransports(new String[]{this.provider.getListeningPoints()[0].getTransport()});
        String confValue = null;
        Context myEnv = null;
        try {
            this.logger.info("Building Configuration from ENV Entries");
            myEnv = (Context)new InitialContext().lookup("java:comp/env");
        }
        catch (NamingException ne) {
            this.logger.warning("Could not set SBB context", (Throwable)ne);
            return;
        }
        try {
            confValue = (String)myEnv.lookup("configuration-URI-SCHEMES");
        }
        catch (NamingException e) {
            this.logger.severe("", (Throwable)e);
        }
        if (confValue == null) {
            proxyConfigurator.addSupportedURIScheme("sip");
            proxyConfigurator.addSupportedURIScheme("sips");
        } else {
            tmp = confValue.split(";");
            for (i = 0; i < tmp.length; ++i) {
                proxyConfigurator.addSupportedURIScheme(tmp[i]);
            }
        }
        confValue = null;
        try {
            confValue = (String)myEnv.lookup("configuration-LOCAL-DOMAINS");
        }
        catch (NamingException e) {
            this.logger.severe("", (Throwable)e);
        }
        if (confValue == null) {
            proxyConfigurator.addLocalDomain("nist.gov");
            proxyConfigurator.addLocalDomain("mobicents.org");
        } else {
            tmp = confValue.split(";");
            for (i = 0; i < tmp.length; ++i) {
                proxyConfigurator.addLocalDomain(tmp[i]);
            }
        }
        String configurationName = null;
        try {
            configurationName = (String)myEnv.lookup("configuration-MBEAN");
        }
        catch (NamingException e) {
            this.logger.severe("", (Throwable)e);
        }
        if (configurationName != null) {
            proxyConfigurator.setName(configurationName);
        }
        proxyConfigurator.startService();
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        try {
            if (aci.getActivity() instanceof ServiceActivity) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Service aci ending, removing mbean");
                }
                SleeContainer.lookupFromJndi().getMBeanServer().unregisterMBean(new ObjectName("slee:sipproxyconfigurator=" + proxyConfigurator.getName()));
            }
        }
        catch (Exception e) {
            this.logger.severe("", (Throwable)e);
        }
    }

    public void onRegisterEvent(RequestEvent event, ActivityContextInterface ac) {
        SipURI uri;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received REGISTER request, class=" + event.getClass());
        }
        if (ProxySbb.isRegisterLocal(uri = (SipURI)event.getRequest().getRequestURI(), this.getProxyConfigurator().getLocalDomainNames())) {
            try {
                ac.attach(this.getRegistrarSbbChildRelation().create());
            }
            catch (Exception e) {
                this.logger.severe("", (Throwable)e);
            }
            ac.detach(this.sbbContext.getSbbLocalObject());
        } else {
            this.processRequest(event.getServerTransaction(), event.getRequest(), ac);
        }
    }

    public void onInviteEvent(RequestEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received INVITE request");
        }
        this.processRequest(event.getServerTransaction(), event.getRequest(), ac);
    }

    public void onByeEvent(RequestEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received BYE request");
        }
        this.processRequest(event.getServerTransaction(), event.getRequest(), ac);
    }

    public void onCancelEvent(CancelRequestEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received CANCEL request");
        }
        ServerTransaction serverTransaction = event.getServerTransaction();
        try {
            if (serverTransaction.getState() != TransactionState.TERMINATED && serverTransaction.getState() != TransactionState.COMPLETED && serverTransaction.getState() != TransactionState.CONFIRMED) {
                serverTransaction.sendResponse(this.messageFactory.createResponse(200, event.getRequest()));
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to reply to CANCEL", (Throwable)e);
        }
        this.processRequest(serverTransaction, event.getRequest(), ac);
    }

    public void onAckEvent(RequestEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received ACK request");
        }
        this.processRequest(event.getServerTransaction(), event.getRequest(), ac);
    }

    public void onMessageEvent(RequestEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received MESSAGE request");
        }
        this.processRequest(event.getServerTransaction(), event.getRequest(), ac);
    }

    public void onOptionsEvent(RequestEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received OPTIONS request");
        }
        try {
            Request request = event.getRequest();
            ServerTransaction serverTransaction = event.getServerTransaction();
            ProxyConfigurator proxyConfiguration = this.getConfiguration();
            SipUri localNodeURI = new SipUri();
            localNodeURI.setHost(proxyConfiguration.getSipHostname());
            localNodeURI.setPort(proxyConfiguration.getSipPort());
            if (request.getRequestURI().equals(localNodeURI)) {
                if (request.getHeader("Max-Forwards") == null) {
                    request.addHeader((Header)this.headerFactory.createMaxForwardsHeader(69));
                }
                serverTransaction.sendResponse(this.messageFactory.createResponse(501, request));
            } else {
                this.processRequest(serverTransaction, request, ac);
            }
        }
        catch (Exception e) {
            this.logger.warning("Exception during onOptionsEvent", (Throwable)e);
        }
    }

    public void onInfoRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received 1xx (FINER) response");
        }
        this.processResponse(event.getClientTransaction(), event.getResponse(), ac);
    }

    public void onSuccessRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received 2xx (SUCCESS) response");
        }
        this.processResponse(event.getClientTransaction(), event.getResponse(), ac);
    }

    public void onRedirRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received 3xx (REDIRECT) response");
        }
        this.processResponse(event.getClientTransaction(), event.getResponse(), ac);
    }

    public void onClientErrorRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received 4xx (CLIENT ERROR) response");
        }
        this.processResponse(event.getClientTransaction(), event.getResponse(), ac);
    }

    public void onServerErrorRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received 5xx (SERVER ERROR) response");
        }
        this.processResponse(event.getClientTransaction(), event.getResponse(), ac);
    }

    public void onGlobalFailureRespEvent(ResponseEvent event, ActivityContextInterface ac) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received 6xx (GLOBAL FAILURE) response");
        }
        this.processResponse(event.getClientTransaction(), event.getResponse(), ac);
    }

    public void onTransactionTimeoutEvent(TimeoutEvent event, ActivityContextInterface ac) {
        ServerTransaction serverTransaction;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received transaction timeout event, tid=" + event.getClientTransaction());
        }
        if ((serverTransaction = event.getServerTransaction()) != null) {
            try {
                serverTransaction.sendResponse(this.messageFactory.createResponse(408, serverTransaction.getRequest()));
                this.setServerTransactionTerminated(true);
            }
            catch (Exception e) {
                this.logger.severe("", (Throwable)e);
            }
        }
    }

    public ServerTransaction getServerTransaction(ClientTransaction clientTransaction) {
        ActivityContextInterface[] myacis = this.sbbContext.getActivities();
        for (int i = 0; i < myacis.length; ++i) {
            ServerTransaction stx;
            Request req;
            Object activity = myacis[i].getActivity();
            if (!(activity instanceof ServerTransaction) || (req = (stx = (ServerTransaction)activity).getRequest()).getMethod().equals("CANCEL") || !req.getMethod().equals(clientTransaction.getRequest().getMethod())) continue;
            return stx;
        }
        return null;
    }

    public ClientTransaction sendRequest(Request request, boolean attach) throws SipException {
        if (request.getHeader("Max-Forwards") == null) {
            try {
                request.addHeader((Header)this.headerFactory.createMaxForwardsHeader(69));
            }
            catch (Exception e) {
                this.logger.severe("", (Throwable)e);
            }
        }
        ClientTransaction ct = this.provider.getNewClientTransaction(request);
        if (attach) {
            try {
                ActivityContextInterface aci = this.acif.getActivityContextInterface(ct);
                aci.attach(this.sbbContext.getSbbLocalObject());
            }
            catch (UnrecognizedActivityException e) {
                this.logger.warning("unable to attach to client transaction", (Throwable)e);
            }
        }
        ct.sendRequest();
        return ct;
    }

    public void sendStatelessRequest(Request request) throws SipException {
        this.provider.sendRequest(request);
    }

    public void sendStatelessResponse(Response response) throws SipException {
        this.provider.sendResponse(response);
    }

    private void processRequest(ServerTransaction serverTransaction, Request request, ActivityContextInterface ac) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("processing request: method = \n" + request.getMethod().toString());
        }
        try {
            if (this.getServerTransactionTerminated()) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("[PROXY MACHINE] txTERM \n" + request);
                }
                return;
            }
            new ProxyMachine(this.getProxyConfigurator(), (LocationService)this.getLocationSbb(), this.addressFactory, this.headerFactory, this.messageFactory, (SipProvider)this.provider).processRequest(serverTransaction, request);
        }
        catch (Exception e) {
            this.logger.warning("Exception during processRequest", (Throwable)e);
            try {
                serverTransaction.sendResponse(this.messageFactory.createResponse(500, request));
            }
            catch (Exception ex) {
                this.logger.warning("Exception during processRequest", (Throwable)e);
            }
        }
    }

    private void processResponse(ClientTransaction clientTransaction, Response response, ActivityContextInterface ac) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("processing response: status = \n" + response.getStatusCode());
        }
        try {
            if (this.getServerTransactionTerminated()) {
                return;
            }
            ServerTransaction serverTransaction = this.getServerTransaction(clientTransaction);
            if (serverTransaction != null) {
                new ProxyMachine(this.getProxyConfigurator(), (LocationService)this.getLocationSbb(), this.addressFactory, this.headerFactory, this.messageFactory, (SipProvider)this.provider).processResponse(serverTransaction, clientTransaction, response);
            } else {
                this.logger.warning("Weird got null tx for[" + response + "]");
            }
        }
        catch (Exception e) {
            this.logger.warning("Exception during processResponse", (Throwable)e);
        }
    }

    private ProxyConfigurator getProxyConfigurator() {
        ProxyConfigurator configurator = this.getConfiguration();
        if (configurator == null) {
            configurator = (ProxyConfigurator)proxyConfigurator.clone();
            this.setConfiguration(configurator);
        }
        return configurator;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        this.logger = context.getTracer("ProxySbb");
        try {
            this.myEnv = new InitialContext();
            this.provider = (SleeSipProvider)this.myEnv.lookup("java:comp/env/slee/resources/jainsip/1.2/provider");
            this.messageFactory = this.provider.getMessageFactory();
            this.headerFactory = this.provider.getHeaderFactory();
            this.addressFactory = this.provider.getAddressFactory();
            this.acif = (SipActivityContextInterfaceFactory)this.myEnv.lookup("java:comp/env/slee/resources/jainsip/1.2/acifactory");
        }
        catch (Exception ne) {
            this.logger.severe("Could not create SBB properly: ", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    private static boolean isRegisterLocal(SipURI uri, String[] domains) {
        String registerDomain = uri.getHost();
        for (String domain : domains) {
            if (!domain.toLowerCase().equals(registerDomain.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProxyMachine
    extends MessageUtils
    implements MessageHandlerInterface {
        protected LocationService reg;
        protected AddressFactory af;
        protected HeaderFactory hf;
        protected MessageFactory mf;
        protected SipProvider provider;
        protected HashSet<URI> localMachineInterfaces;
        protected ProxyConfiguration config;

        public ProxyMachine(ProxyConfiguration config, LocationService registrarAccess, AddressFactory af, HeaderFactory hf, MessageFactory mf, SipProvider prov) throws ParseException {
            super(config);
            this.reg = null;
            this.af = null;
            this.hf = null;
            this.mf = null;
            this.provider = null;
            this.localMachineInterfaces = new HashSet();
            this.config = null;
            this.reg = registrarAccess;
            this.mf = mf;
            this.af = af;
            this.hf = hf;
            this.provider = prov;
            this.config = config;
            SipUri localMachineURI = new SipUri();
            localMachineURI.setHost(this.config.getSipHostname());
            localMachineURI.setPort(this.config.getSipPort());
            this.localMachineInterfaces.add((URI)localMachineURI);
        }

        public void processRequest(ServerTransaction stx, Request req) {
            if (ProxySbb.this.logger.isFinerEnabled()) {
                ProxySbb.this.logger.finer("processRequest");
            }
            try {
                Request tmpNewRequest = (Request)req.clone();
                this.validateRequest(stx, tmpNewRequest);
                this.routePreProcess(tmpNewRequest);
                List targets = this.determineRequestTargets(tmpNewRequest);
                Iterator it = targets.iterator();
                while (it.hasNext()) {
                    Request newRequest = (Request)tmpNewRequest.clone();
                    URI target = (URI)it.next();
                    if (this.isLocalMachine(target)) continue;
                    if (target.isSipURI() && !((SipUri)target).hasLrParam()) {
                        newRequest.setRequestURI(target);
                    }
                    if (newRequest.getMethod().equals("CANCEL")) {
                        newRequest.removeHeader("Via");
                        newRequest.removeHeader("Record-Route");
                    } else {
                        this.decrementMaxForwards(newRequest);
                        this.addRecordRouteHeader(newRequest);
                    }
                    this.addViaHeader(newRequest);
                    ClientTransaction ctx = this.forwardRequest(stx, newRequest);
                }
            }
            catch (SipSendErrorResponseException se) {
                se.printStackTrace();
                int statusCode = se.getStatusCode();
                this.sendErrorResponse(stx, req, statusCode);
            }
            catch (SipLoopDetectedException slde) {
                ProxySbb.this.logger.warning("Loop detected, droping message.");
                slde.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void processResponse(ServerTransaction stx, ClientTransaction ctx, Response resp) {
            try {
                Response newResponse = (Response)resp.clone();
                ListIterator viaHeaderIt = newResponse.getHeaders("Via");
                viaHeaderIt.next();
                viaHeaderIt.remove();
                if (!viaHeaderIt.hasNext()) {
                    return;
                }
                if (newResponse.getStatusCode() == 100) {
                    return;
                }
                this.forwardResponse(stx, newResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public ClientTransaction forwardRequest(ServerTransaction serverTransaction, Request request) {
            ClientTransaction toReturn;
            block5: {
                toReturn = null;
                if (ProxySbb.this.logger.isFinerEnabled()) {
                    ProxySbb.this.logger.finer("Forwarding request " + request.getMethod() + " of server tx " + serverTransaction.getBranchId());
                }
                try {
                    if (request.getMethod().equals("ACK")) {
                        ProxySbb.this.sendStatelessRequest(request);
                        break block5;
                    }
                    if (request.getMethod().equals("CANCEL")) {
                        ProxySbb.this.sendRequest(request, false);
                        break block5;
                    }
                    ClientTransaction clientTransaction = ProxySbb.this.sendRequest(request, true);
                    return clientTransaction;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (serverTransaction.getRequest().getMethod().endsWith("CANCEL")) break block5;
                    this.sendErrorResponse(serverTransaction, serverTransaction.getRequest(), 500);
                }
            }
            return toReturn;
        }

        public void sendErrorResponse(ServerTransaction txn, Request request, int statusCode) {
            try {
                ProxySbb.this.setServerTransactionTerminated(true);
                Response response = this.mf.createResponse(statusCode, request);
                if (response.getHeader("Max-Forwards") == null) {
                    response.addHeader((Header)this.hf.createMaxForwardsHeader(69));
                }
                txn.sendResponse(response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void forwardResponse(ServerTransaction txn, Response response) {
            if (ProxySbb.this.logger.isFinerEnabled()) {
                ProxySbb.this.logger.fine("Forwarding response " + response.getStatusCode() + " of server tx " + txn.getBranchId());
            }
            try {
                if (txn != null) {
                    txn.sendResponse(response);
                } else {
                    ProxySbb.this.sendStatelessResponse(response);
                }
            }
            catch (Exception e) {
                ProxySbb.this.logger.severe("Exception during forwardResponse[\n" + response + "\n] TXBRANCH[" + txn.getBranchId() + "] TXR[\n" + txn.getRequest() + "\n]", (Throwable)e);
            }
        }

        public void validateRequest(ServerTransaction txn, Request request) throws SipSendErrorResponseException, SipLoopDetectedException {
            URI requestURI = null;
            requestURI = request.getRequestURI();
            boolean supportedURIScheme = false;
            supportedURIScheme = this.isSupportedURIScheme(requestURI);
            if (!supportedURIScheme) {
                throw new SipSendErrorResponseException("Unsupported URI scheme", 416);
            }
            this.checkMaxForwards(txn, request);
            this.detectLoop(request);
        }

        public void detectLoop(Request request) throws SipLoopDetectedException {
            ListIterator lit;
            URI requestURI = null;
            requestURI = request.getRequestURI();
            SipUri localNodeURI = new SipUri();
            try {
                localNodeURI.setHost(this.config.getSipHostname());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            localNodeURI.setPort(this.config.getSipPort());
            if (requestURI.equals(localNodeURI) && ProxySbb.this.logger.isFinerEnabled()) {
                ProxySbb.this.logger.finer("Possible loop detected on LOCAL[" + localNodeURI + "] MSG[" + requestURI + "] message:n" + request + "\n====================================");
            }
            if ((lit = request.getHeaders("Via")) != null && lit.hasNext()) {
                int found = 0;
                do {
                    ViaHeader vh;
                    if ((vh = (ViaHeader)lit.next()).getHost().equals(localNodeURI.getHost()) && vh.getPort() == localNodeURI.getPort()) {
                        ++found;
                    }
                    if (found < 2) continue;
                    throw new SipLoopDetectedException("Possible loop detected[mutliple via headers] on message:n" + request + "\n====================================");
                } while (lit.hasNext());
            }
        }

        public void checkMaxForwards(ServerTransaction txn, Request request) throws SipSendErrorResponseException {
            MaxForwardsHeader mfh = (MaxForwardsHeader)request.getHeader("Max-Forwards");
            if (mfh == null) {
                return;
            }
            int maxForwards = 0;
            maxForwards = ((MaxForwardsHeader)request.getHeader("Max-Forwards")).getMaxForwards();
            if (maxForwards > 0) {
                return;
            }
            throw new SipSendErrorResponseException("Too many hops", 483);
        }

        public LinkedList<URI> findLocalTarget(URI uri) throws SipSendErrorResponseException {
            String addressOfRecord = uri.toString();
            Map bindings = null;
            LinkedList<URI> listOfTargets = new LinkedList<URI>();
            try {
                bindings = this.reg.getBindings(addressOfRecord);
            }
            catch (LocationServiceException e) {
                e.printStackTrace();
                return listOfTargets;
            }
            if (bindings == null) {
                throw new SipSendErrorResponseException("User not found", 404);
            }
            if (bindings.isEmpty()) {
                throw new SipSendErrorResponseException("User temporarily unavailable", 480);
            }
            Iterator it = bindings.values().iterator();
            Object target = null;
            while (it.hasNext()) {
                String contactAddress = ((RegistrationBinding)it.next()).getContactAddress();
                try {
                    listOfTargets.add(this.af.createURI(contactAddress));
                }
                catch (ParseException e) {
                    ProxySbb.this.logger.warning("Ignoring contact address " + contactAddress + " due to parse error", (Throwable)e);
                }
            }
            if (listOfTargets.size() == 0) {
                throw new SipSendErrorResponseException("User temporarily unavailable", 480);
            }
            return listOfTargets;
        }

        public void addViaHeader(Request request) throws SipSendErrorResponseException {
            ViaHeader via = null;
            try {
                if (request.getMethod().equals("CANCEL")) {
                    via = ProxySbb.this.getForwardedInviteViaHeader();
                    if (via == null) {
                        throw new SipSendErrorResponseException("Couldnt add via [" + via + "] to msg[\n" + request + "\n], didnt find forwarded via!!!", 400);
                    }
                } else {
                    via = this.hf.createViaHeader(this.config.getSipHostname(), this.config.getSipPort(), this.config.getSipTransports()[0], "z9hG4bK" + System.currentTimeMillis() + "_" + Math.random() + "_" + System.currentTimeMillis());
                    if (request.getMethod().equals("INVITE")) {
                        ProxySbb.this.setForwardedInviteViaHeader(via);
                    }
                }
                if (ProxySbb.this.logger.isFinerEnabled()) {
                    ProxySbb.this.logger.finer("[&&&] addViaHeader\n" + via + "");
                }
                request.addHeader((Header)via);
            }
            catch (Exception e) {
                throw new SipSendErrorResponseException("Couldnt add via [" + via + "] to msg[\n" + request + "\n]", 500, (Throwable)e);
            }
        }

        public void addRecordRouteHeader(Request request) {
            try {
                SipURI myURI = this.af.createSipURI(null, this.config.getSipHostname());
                myURI.setPort(this.config.getSipPort());
                myURI.setMAddrParam(this.config.getSipHostname());
                myURI.setTransportParam(this.config.getSipTransports()[0]);
                myURI.setParameter("cluster", "mobi-cents");
                myURI.setParameter("lr", "");
                Address myName = this.af.createAddress((URI)myURI);
                RecordRouteHeader myHeader = this.hf.createRecordRouteHeader(myName);
                request.addFirst((Header)myHeader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void decrementMaxForwards(Request request) throws SipSendErrorResponseException {
            MaxForwardsHeader max = (MaxForwardsHeader)request.getHeader("Max-Forwards");
            try {
                if (max == null) {
                    max = this.hf.createMaxForwardsHeader(70);
                    request.setHeader((Header)max);
                } else {
                    int maxForwards = max.getMaxForwards();
                    max.setMaxForwards(--maxForwards);
                    request.setHeader((Header)max);
                }
            }
            catch (Exception e) {
                throw new SipSendErrorResponseException("Error updating max-forwards", 500);
            }
        }

        public void routePreProcess(Request request) throws SipSendErrorResponseException {
            RouteHeader r;
            URI uri;
            ListIterator routeHeaders;
            URI requestURI = null;
            requestURI = request.getRequestURI();
            if (requestURI.isSipURI() && ((SipURI)requestURI).getUser() == null && ((SipURI)requestURI).getHost().equalsIgnoreCase(this.config.getSipHostname())) {
                try {
                    ListIterator it = request.getHeaders("Route");
                    LinkedList<RouteHeader> l = new LinkedList<RouteHeader>();
                    while (it.hasNext()) {
                        RouteHeader r2 = (RouteHeader)it.next();
                        l.add(r2);
                    }
                    if (l.size() == 0) {
                        return;
                    }
                    RouteHeader route = (RouteHeader)l.getLast();
                    l.removeLast();
                    request.removeHeader("Route");
                    for (int i = 0; i < l.size(); ++i) {
                        RouteHeader routeHeader = (RouteHeader)l.get(i);
                        request.addHeader((Header)routeHeader);
                    }
                    URI newURI = route.getAddress().getURI();
                    request.setRequestURI(newURI);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SipSendErrorResponseException("Error updating route headers", 500);
                }
            }
            if ((routeHeaders = request.getHeaders("Route")).hasNext() && (uri = (r = (RouteHeader)routeHeaders.next()).getAddress().getURI()).isSipURI()) {
                String cluster;
                boolean isMobicents;
                SipURI sipURI = (SipURI)uri;
                int uriPort = sipURI.getPort();
                if (uriPort <= 0) {
                    uriPort = 5060;
                }
                boolean bl = isMobicents = (cluster = sipURI.getParameter("cluster")) != null && cluster.equals("mobi-cents");
                if (sipURI.getHost().equalsIgnoreCase(this.config.getSipHostname()) && uriPort == this.config.getSipPort() || isMobicents) {
                    routeHeaders.remove();
                    if (!routeHeaders.hasNext()) {
                        request.removeHeader("Route");
                    }
                }
            }
        }

        public List determineRequestTargets(Request request) throws SipSendErrorResponseException {
            LinkedList<Object> targets = null;
            URI requestURI = null;
            URI target = null;
            boolean localDomain = false;
            requestURI = request.getRequestURI();
            localDomain = this.isLocalDomain(requestURI);
            if (request.getMethod().equals("ACK") || request.getMethod().equals("BYE")) {
                RouteHeader rh = (RouteHeader)request.getHeader("Route");
                target = rh != null ? rh.getAddress().getURI() : request.getRequestURI();
                targets = new LinkedList();
                targets.add(target);
            } else if (localDomain) {
                targets = this.findLocalTarget(requestURI);
            } else {
                target = requestURI;
                targets = new LinkedList();
                targets.add(target);
            }
            return targets;
        }

        public boolean isLocalMachine(URI hostURI) {
            return this.localMachineInterfaces.contains(hostURI);
        }
    }
}

