/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.slee.ComponentID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.resource.ResourceAdaptorTypeID;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.EventTypeIDImpl;
import org.mobicents.slee.container.component.MobicentsEventTypeDescriptor;
import org.mobicents.slee.container.component.MobicentsEventTypeDescriptorInternalImpl;
import org.mobicents.slee.container.component.MobicentsSbbDescriptorInternalImpl;
import org.mobicents.slee.container.component.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.component.ResourceAdaptorEntityBinding;
import org.mobicents.slee.container.component.ResourceAdaptorIDImpl;
import org.mobicents.slee.container.component.SbbEventEntry;
import org.mobicents.slee.container.component.SbbIDImpl;
import org.mobicents.slee.container.component.SbbRef;
import org.mobicents.slee.container.component.ServiceIDImpl;
import org.mobicents.slee.container.component.deployment.EventTypeDeploymentDescriptorParser;
import org.mobicents.slee.container.component.deployment.ProfileSpecificationDescriptorParser;
import org.mobicents.slee.container.component.deployment.ResourceAdaptorDescriptorParser;
import org.mobicents.slee.container.component.deployment.ResourceAdaptorTypeDescriptorParser;
import org.mobicents.slee.container.component.deployment.SbbDeploymentDescriptorParser;
import org.mobicents.slee.container.deployment.jboss.DeployableUnit;
import org.mobicents.slee.container.deployment.jboss.DeployableUnitWrapper;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.mobicents.slee.resource.ResourceAdaptorDescriptorImpl;
import org.mobicents.slee.resource.ResourceAdaptorTypeDescriptorImpl;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableComponent {
    private static Logger logger = Logger.getLogger(DeployableComponent.class);
    public static final int PROFILESPEC_COMPONENT = 1;
    public static final int EVENTTYPE_COMPONENT = 2;
    public static final int RATYPE_COMPONENT = 3;
    public static final int RA_COMPONENT = 4;
    public static final int SBB_COMPONENT = 5;
    public static final int SERVICE_COMPONENT = 6;
    private String diShortName;
    private URL diURL;
    private ComponentID componentID;
    private Collection<String> dependencies = new ArrayList<String>();
    private Collection<Object[]> installActions = new ArrayList<Object[]>();
    private Collection<Object[]> uninstallActions = new ArrayList<Object[]>();
    private String componentKey;
    private int componentType = -1;
    private DeployableUnitWrapper duWrapper;
    private Collection<DeployableComponent> subComponents = new ArrayList<DeployableComponent>();

    private DeployableComponent(DeployableComponent dc) throws Exception {
        this.diShortName = dc.diShortName;
        this.diURL = dc.diURL;
        this.subComponents = null;
    }

    public DeployableComponent(URL url, String fileName) throws Exception {
        this.diShortName = fileName;
        this.diURL = url;
        this.subComponents = this.parseDescriptor();
    }

    public DeployableComponent(DeployableUnitWrapper duWrapper, URL url, String fileName) throws Exception {
        this.duWrapper = duWrapper;
        this.diShortName = fileName;
        this.diURL = url;
        this.subComponents = this.parseDescriptor();
    }

    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    public boolean isDeployable(Collection<String> deployedComponents) {
        return deployedComponents.containsAll(this.dependencies);
    }

    public String getComponentKey() {
        return this.componentKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<DeployableComponent> parseDescriptor() throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Parsing Descriptor for " + this.diURL.toString()));
        }
        ArrayList<DeployableComponent> deployableComponents = new ArrayList<DeployableComponent>();
        if (this.diShortName.endsWith(".xml")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing Service Descriptor.");
            }
            InputStream is = null;
            try {
                is = this.diURL.openStream();
                Document doc2 = XMLUtils.parseDocument((InputStream)is, (boolean)true);
                NodeList nodeList = doc2.getElementsByTagName("service");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element curElement = (Element)nodeList.item(i);
                    String serviceName = curElement.getElementsByTagName("service-name").item(0).getTextContent().trim();
                    String serviceVendor = curElement.getElementsByTagName("service-vendor").item(0).getTextContent().trim();
                    String serviceVersion = curElement.getElementsByTagName("service-version").item(0).getTextContent().trim();
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentID = new ServiceIDImpl(new ComponentKey(serviceName, serviceVendor, serviceVersion));
                    dc.componentKey = dc.componentID.toString();
                    dc.componentType = 6;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                    }
                    Element rootSbbElem = (Element)curElement.getElementsByTagName("root-sbb").item(0);
                    String rootSbbName = rootSbbElem.getElementsByTagName("sbb-name").item(0).getTextContent().trim();
                    String rootSbbVendor = rootSbbElem.getElementsByTagName("sbb-vendor").item(0).getTextContent().trim();
                    String rootSbbVersion = rootSbbElem.getElementsByTagName("sbb-version").item(0).getTextContent().trim();
                    String rootSbb = new SbbIDImpl(new ComponentKey(rootSbbName, rootSbbVendor, rootSbbVersion)).toString();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                        logger.trace((Object)rootSbb);
                        logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                    }
                    dc.dependencies.add(rootSbb);
                    dc.installActions.add(new Object[]{"activate", dc.componentID});
                    dc.uninstallActions.add(new Object[]{"deactivate", dc.componentID});
                    deployableComponents.add(dc);
                }
                ArrayList<DeployableComponent> i = deployableComponents;
                return i;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                Collection<DeployableComponent> nodeList = null;
                return nodeList;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        URL descriptorXML = null;
        Document doc = null;
        descriptorXML = this.duWrapper.getEntry("META-INF/sbb-jar.xml");
        if (descriptorXML != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing SBB Descriptor.");
            }
            InputStream is = null;
            try {
                is = descriptorXML.openStream();
                doc = XMLUtils.parseDocument((InputStream)is, (boolean)true);
                Element sbbJarNode = doc.getDocumentElement();
                List sbbNodes = XMLUtils.getAllChildElements((Element)sbbJarNode, (String)"sbb");
                if (sbbNodes.size() == 0) {
                    logger.warn((Object)("The " + this.duWrapper.getFileName() + " deployment descriptor contains no sbb definitions"));
                    Collection<DeployableComponent> serviceName = null;
                    return serviceName;
                }
                int i = sbbNodes.size() - 1;
                while (i >= 0) {
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 5;
                    Element sbbNode = (Element)sbbNodes.get(i);
                    SbbDeploymentDescriptorParser parser = new SbbDeploymentDescriptorParser();
                    MobicentsSbbDescriptorInternalImpl descriptor = (MobicentsSbbDescriptorInternalImpl)parser.parseSbbComponent(sbbNode, new MobicentsSbbDescriptorInternalImpl());
                    dc.componentID = descriptor.getID();
                    dc.componentKey = dc.componentID.toString();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                        logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                    }
                    HashSet sbbRefs = descriptor.getSbbRef();
                    for (SbbRef sbbRef : sbbRefs) {
                        dc.dependencies.add("SbbID[" + sbbRef.getComponentKey() + "]");
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)("SbbID[" + sbbRef.getComponentKey() + "]"));
                    }
                    ResourceAdaptorTypeID[] rasList = descriptor.getResourceAdaptorTypes();
                    for (int n = 0; n < rasList.length; ++n) {
                        dc.dependencies.add(rasList[n].toString());
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)rasList[n]);
                        }
                        Iterator raebIt = descriptor.getResourceAdaptorEntityBindings((ResourceAdaptorTypeIDImpl)rasList[n]);
                        while (raebIt.hasNext()) {
                            String raLink = ((ResourceAdaptorEntityBinding)raebIt.next()).getResourceAdaptorEntityLink() + "_@_" + rasList[n];
                            dc.dependencies.add(raLink);
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace((Object)raLink);
                        }
                    }
                    HashSet eventsList = descriptor.getSbbEventEntries();
                    for (SbbEventEntry event : eventsList) {
                        String eventTypeID = "EventTypeID[" + event.getEventTypeRefKey() + "]";
                        dc.dependencies.add(eventTypeID);
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)eventTypeID);
                    }
                    ProfileSpecificationID[] profilesList = descriptor.getProfileSpecifications();
                    for (int n = 0; n < profilesList.length; ++n) {
                        dc.dependencies.add(profilesList[n].toString());
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)profilesList[n]);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                    }
                    deployableComponents.add(dc);
                    --i;
                }
                return deployableComponents;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return deployableComponents;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        descriptorXML = this.duWrapper.getEntry("META-INF/profile-spec-jar.xml");
        if (descriptorXML != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing Profile Specification Descriptor.");
            }
            InputStream is = null;
            try {
                is = descriptorXML.openStream();
                doc = XMLUtils.parseDocument((InputStream)is, (boolean)true);
                Element profileJarNode = doc.getDocumentElement();
                List profileSpecNodes = XMLUtils.getAllChildElements((Element)profileJarNode, (String)"profile-spec");
                if (profileSpecNodes.size() == 0) {
                    logger.warn((Object)("The " + this.duWrapper.getFileName() + " deployment descriptor contains no profile-spec definitions"));
                    Collection<DeployableComponent> i = null;
                    return i;
                }
                int i = profileSpecNodes.size() - 1;
                while (i >= 0) {
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 1;
                    Element profileSpecNode = (Element)profileSpecNodes.get(i);
                    ProfileSpecificationDescriptorParser parser = new ProfileSpecificationDescriptorParser();
                    ProfileSpecificationDescriptorImpl descriptor = parser.parseProfileComponent(profileSpecNode, new ProfileSpecificationDescriptorImpl());
                    dc.componentID = descriptor.getID();
                    dc.componentKey = dc.componentID.toString();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                    }
                    deployableComponents.add(dc);
                    --i;
                }
                return deployableComponents;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return deployableComponents;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        descriptorXML = this.duWrapper.getEntry("META-INF/event-jar.xml");
        if (descriptorXML != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing Event Definition Descriptor.");
            }
            InputStream is = null;
            try {
                is = descriptorXML.openStream();
                doc = XMLUtils.parseDocument((InputStream)is, (boolean)true);
                Element docElement = doc.getDocumentElement();
                List nodes = XMLUtils.getAllChildElements((Element)docElement, (String)"event-definition");
                int i = 0;
                while (i < nodes.size()) {
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 2;
                    MobicentsEventTypeDescriptorInternalImpl descriptorImpl = new MobicentsEventTypeDescriptorInternalImpl();
                    Element eventDefinitionNode = (Element)nodes.get(i);
                    EventTypeDeploymentDescriptorParser parser = new EventTypeDeploymentDescriptorParser();
                    parser.parse(eventDefinitionNode, (MobicentsEventTypeDescriptor)descriptorImpl);
                    dc.componentID = new EventTypeIDImpl(new ComponentKey(descriptorImpl.getName(), descriptorImpl.getVendor(), descriptorImpl.getVersion()));
                    dc.componentKey = dc.componentID.toString().substring(0, dc.componentID.toString().indexOf(44));
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                    }
                    deployableComponents.add(dc);
                    ++i;
                }
                return deployableComponents;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return deployableComponents;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        descriptorXML = this.duWrapper.getEntry("META-INF/resource-adaptor-type-jar.xml");
        if (descriptorXML != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing Resource Adaptor Type Descriptor.");
            }
            InputStream is = null;
            try {
                is = descriptorXML.openStream();
                doc = XMLUtils.parseDocument((InputStream)is, (boolean)true);
                Element raJarNode = doc.getDocumentElement();
                List raTypeNodes = XMLUtils.getAllChildElements((Element)raJarNode, (String)"resource-adaptor-type");
                if (raTypeNodes == null) return deployableComponents;
                Iterator it = raTypeNodes.iterator();
                while (it.hasNext()) {
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 3;
                    ResourceAdaptorTypeDescriptorImpl raTypeDescriptor = new ResourceAdaptorTypeDescriptorImpl();
                    ResourceAdaptorTypeDescriptorParser parser = new ResourceAdaptorTypeDescriptorParser();
                    parser.parseResourceAdaptorTypeDescriptor((Element)it.next(), raTypeDescriptor);
                    dc.componentID = raTypeDescriptor.getID();
                    dc.componentKey = dc.componentID.toString();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                        logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                    }
                    ComponentKey[] eventsList = raTypeDescriptor.getEventTypeRefEntries();
                    for (int i = 0; i < eventsList.length; ++i) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("EventTypeID[" + eventsList[i].toString() + "]"));
                        }
                        dc.dependencies.add("EventTypeID[" + eventsList[i].toString() + "]");
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                    }
                    deployableComponents.add(dc);
                }
                return deployableComponents;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return deployableComponents;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        descriptorXML = this.duWrapper.getEntry("META-INF/resource-adaptor-jar.xml");
        if (descriptorXML == null) {
            logger.warn((Object)("\r\n--------------------------------------------------------------------------------\r\nNo Component Descriptor found in '" + this.duWrapper.getFileName() + "'.\r\n" + "--------------------------------------------------------------------------------"));
            return new ArrayList<DeployableComponent>();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Parsing Resource Adaptor Descriptor.");
        }
        InputStream is = null;
        try {
            is = descriptorXML.openStream();
            doc = XMLUtils.parseDocument((InputStream)is, (boolean)true);
            Iterator it = XMLUtils.getAllChildElements((Element)doc.getDocumentElement(), (String)"resource-adaptor").iterator();
            while (it.hasNext()) {
                DeployableComponent dc = new DeployableComponent(this);
                dc.componentType = 4;
                Element raNode = (Element)it.next();
                ResourceAdaptorDescriptorImpl raDescriptor = new ResourceAdaptorDescriptorImpl();
                ResourceAdaptorDescriptorParser parser = new ResourceAdaptorDescriptorParser();
                parser.parseResourceAdaptorDescriptor(raNode, raDescriptor);
                dc.componentID = raDescriptor.getID();
                dc.componentKey = dc.componentID.toString();
                dc.dependencies.add(raDescriptor.getResourceAdaptorType().toString());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Component ID: " + dc.componentKey));
                    logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                    logger.trace((Object)raDescriptor.getResourceAdaptorType());
                    logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                }
                deployableComponents.add(dc);
            }
            return deployableComponents;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return deployableComponents;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                finally {
                    is = null;
                }
            }
        }
    }

    public Collection<Object[]> getInstallActions() {
        return this.installActions;
    }

    public Collection<Object[]> getUninstallActions() {
        return this.uninstallActions;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public ComponentID getComponentID() {
        return this.componentID;
    }

    public Collection<DeployableComponent> getSubComponents() {
        return this.subComponents;
    }

    public boolean isUndeployable(DeployableUnit du) {
        SleeContainer sC = SleeContainer.lookupFromJndi();
        boolean result = false;
        switch (this.componentType) {
            case 1: {
                result = true;
                break;
            }
            case 2: {
                result = true;
                break;
            }
            case 3: {
                Collection<String> duComponents = du.getComponents();
                HashSet raIDs = sC.getResourceManagement().getResourceAdaptorType((ResourceAdaptorTypeID)this.componentID).getResourceAdaptorIDs();
                for (ResourceAdaptorIDImpl raID : raIDs) {
                    if (duComponents.contains(raID.getAsText())) continue;
                    return false;
                }
                result = true;
                break;
            }
            case 4: {
                result = true;
                break;
            }
            case 5: {
                result = true;
                break;
            }
            case 6: {
                result = true;
            }
        }
        return result;
    }
}

