/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.slee.ComponentID;
import javax.slee.resource.ResourceAdaptorTypeID;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.DeployableUnitDescriptorImpl;
import org.mobicents.slee.container.component.ResourceAdaptorIDImpl;
import org.mobicents.slee.container.deployment.jboss.DeployableComponent;
import org.mobicents.slee.container.deployment.jboss.DeployableUnitWrapper;
import org.mobicents.slee.container.deployment.jboss.DeploymentManager;
import org.mobicents.slee.container.management.ResourceManagement;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.mobicents.slee.resource.ResourceAdaptorType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableUnit {
    private static Logger logger = Logger.getLogger(DeployableUnit.class);
    private String diShortName;
    private URL diURL;
    private Collection<DeployableComponent> components = new ArrayList<DeployableComponent>();
    private Collection<String> componentIDs = new ArrayList<String>();
    private Collection<String> dependencies = new ArrayList<String>();
    private Collection<Object[]> installActions = new ArrayList<Object[]>();
    private HashMap<String, Collection<Object[]>> postInstallActions = new HashMap();
    private HashMap<String, Collection<Object[]>> preUninstallActions = new HashMap();
    private Collection<Object[]> uninstallActions = new ArrayList<Object[]>();
    private boolean isInstalled = false;

    public DeployableUnit(DeployableUnitWrapper du) throws Exception {
        this.diShortName = du.getFileName();
        this.diURL = du.getUrl();
        this.installActions.add(new Object[]{"install", this.diURL.toString()});
        this.parseDeployConfig();
    }

    public void addComponent(DeployableComponent dc) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding Component " + dc.getComponentKey()));
        }
        this.components.add(dc);
        this.componentIDs.add(dc.getComponentKey());
        this.dependencies.addAll(dc.getDependencies());
        this.installActions.addAll(dc.getInstallActions());
        Collection<Object[]> postInstallActionsStrings = this.postInstallActions.remove(dc.getComponentKey());
        if (postInstallActionsStrings != null && postInstallActionsStrings.size() > 0) {
            this.installActions.addAll(postInstallActionsStrings);
        } else if (dc.getComponentType() == 4) {
            ComponentID cid = dc.getComponentID();
            String raID = dc.getComponentKey();
            logger.warn((Object)("\r\n------------------------------------------------------------\r\nNo RA Entity and Link config for " + raID + " found. Using default values!" + "\r\n------------------------------------------------------------"));
            String raName = raID.substring(raID.indexOf(91) + 1, raID.indexOf(35));
            this.installActions.add(new Object[]{"createResourceAdaptorEntity", cid, raName, new Properties()});
            this.installActions.add(new Object[]{"activateResourceAdaptorEntity", raName});
            this.installActions.add(new Object[]{"bindLinkName", raName, raName});
            this.uninstallActions.add(new Object[]{"unbindLinkName", raName});
            this.uninstallActions.add(new Object[]{"deactivateResourceAdaptorEntity", raName});
            this.uninstallActions.add(new Object[]{"removeResourceAdaptorEntity", raName});
        }
        Collection<Object[]> preUninstallActionsStrings = this.preUninstallActions.remove(dc.getComponentKey());
        if (preUninstallActionsStrings != null) {
            this.uninstallActions.addAll(preUninstallActionsStrings);
        }
        this.uninstallActions.addAll(dc.getUninstallActions());
    }

    public boolean isSelfSufficient() {
        return this.componentIDs.containsAll(this.dependencies);
    }

    public Collection<String> getExternalDependencies() {
        Collection<String> externalDependencies = this.dependencies;
        externalDependencies.removeAll(this.componentIDs);
        return externalDependencies;
    }

    public boolean hasDependenciesSatisfied(boolean showMissing) {
        if (this.isSelfSufficient()) {
            return true;
        }
        Collection<String> externalDependencies = this.getExternalDependencies();
        externalDependencies.removeAll(DeploymentManager.INSTANCE.getDeployedComponents());
        if (externalDependencies.size() > 0) {
            if (showMissing) {
                String missingDepList = "";
                for (String missingDep : externalDependencies) {
                    missingDepList = missingDepList + "\r\n +-- " + missingDep;
                }
                logger.info((Object)("Missing dependencies for " + this.diShortName + ":" + missingDepList));
            }
            return false;
        }
        return true;
    }

    public boolean hasDuplicates() {
        ArrayList<String> duplicates = new ArrayList<String>();
        for (String componentId : this.componentIDs) {
            if (!DeploymentManager.INSTANCE.getDeployedComponents().contains(componentId)) continue;
            duplicates.add(componentId);
        }
        if (duplicates.size() > 0) {
            logger.warn((Object)("The deployable unit '" + this.diShortName + "' contains components that are already deployed. The following are already installed:"));
            for (String dupComponent : duplicates) {
                logger.warn((Object)(" - " + dupComponent));
            }
            return true;
        }
        return false;
    }

    public boolean isReadyToInstall(boolean showMissing) {
        return this.hasDependenciesSatisfied(showMissing) && !this.hasDuplicates();
    }

    public Collection<Object[]> getInstallActions() {
        ArrayList<Object[]> iActions = new ArrayList<Object[]>();
        iActions.addAll(this.installActions);
        if (this.postInstallActions.values().size() > 0) {
            for (String componentId : this.postInstallActions.keySet()) {
                iActions.addAll(this.postInstallActions.get(componentId));
            }
        }
        return iActions;
    }

    public Collection<Object[]> getUninstallActions() {
        ArrayList<Object[]> uActions = new ArrayList<Object[]>(this.uninstallActions);
        if (this.preUninstallActions.values().size() > 0) {
            for (String componentId : this.preUninstallActions.keySet()) {
                uActions.addAll(this.preUninstallActions.get(componentId));
            }
        }
        uActions.add(new Object[]{"uninstall", this.diURL.toString()});
        return uActions;
    }

    public Collection<String> getComponents() {
        return this.componentIDs;
    }

    public boolean isReadyToUninstall() throws Exception {
        if (this.isInstalled && !this.hasReferringDU()) {
            for (DeployableComponent dc : this.components) {
                if (dc.isUndeployable(this)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean hasReferringDU() throws Exception {
        SleeContainer sC = SleeContainer.lookupFromJndi();
        DeployableUnitDescriptorImpl dudesc = sC.getDeployableUnitManagement().getDeployableUnitDescriptor(this.diURL.toString());
        return sC.getDeployableUnitManagement().hasReferringDU(dudesc);
    }

    public String getDeploymentInfoShortName() {
        return this.diShortName;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public void setInstalled(boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDeployConfig() throws Exception {
        JarFile componentJarFile = null;
        InputStream is = null;
        try {
            componentJarFile = new JarFile(this.diURL.getFile());
            JarEntry deployInfoXML = componentJarFile.getJarEntry("META-INF/deploy-config.xml");
            InputStream inputStream = is = deployInfoXML != null ? componentJarFile.getInputStream(deployInfoXML) : null;
            if (is != null) {
                Document doc = XMLUtils.parseDocument((InputStream)is, (boolean)true);
                NodeList raEntities = doc.getElementsByTagName("ra-entity");
                String raId = null;
                ArrayList<Object[]> cPostInstallActions = new ArrayList<Object[]>();
                ArrayList<Object[]> cPreUninstallActions = new ArrayList<Object[]>();
                for (int i = 0; i < raEntities.getLength(); ++i) {
                    int j;
                    Element raEntity = (Element)raEntities.item(i);
                    raId = "ResourceAdaptorID[" + raEntity.getAttribute("resource-adaptor-id") + "]";
                    String entityName = raEntity.getAttribute("entity-name");
                    NodeList propsNodeList = raEntity.getElementsByTagName("properties");
                    if (propsNodeList.getLength() > 1) {
                        logger.warn((Object)"Invalid ra-entity element, has more than one properties child. Reading only first.");
                    }
                    Element propsNode = (Element)propsNodeList.item(0);
                    Properties props = new Properties();
                    if (propsNode != null) {
                        String propsFilename = propsNode.getAttribute("file");
                        if (propsFilename != null && !propsFilename.equals("")) {
                            JarEntry propsFile = componentJarFile.getJarEntry("META-INF/" + propsFilename);
                            props.load(componentJarFile.getInputStream(propsFile));
                        }
                        NodeList propsList = propsNode.getElementsByTagName("property");
                        for (j = 0; j < propsList.getLength(); ++j) {
                            Element property = (Element)propsList.item(j);
                            props.put(property.getAttribute("name"), property.getAttribute("value"));
                        }
                    }
                    ResourceAdaptorIDImpl componentID = new ResourceAdaptorIDImpl(new ComponentKey(raEntity.getAttribute("resource-adaptor-id")));
                    cPostInstallActions.add(new Object[]{"createResourceAdaptorEntity", componentID, entityName, props});
                    cPostInstallActions.add(new Object[]{"activateResourceAdaptorEntity", entityName});
                    NodeList links = raEntity.getElementsByTagName("ra-link");
                    for (j = 0; j < links.getLength(); ++j) {
                        String linkName = ((Element)links.item(j)).getAttribute("name");
                        cPostInstallActions.add(new Object[]{"bindLinkName", entityName, linkName});
                        cPreUninstallActions.add(new Object[]{"unbindLinkName", linkName});
                        ResourceManagement resourceManagement = SleeContainer.lookupFromJndi().getResourceManagement();
                        ResourceAdaptorTypeID[] existingRATypeIDs = resourceManagement.getResourceAdaptorTypeIDs();
                        String raTypeFromRa = null;
                        for (ResourceAdaptorTypeID resourceAdaptorTypeID : existingRATypeIDs) {
                            ResourceAdaptorType raType = resourceManagement.getResourceAdaptorType(resourceAdaptorTypeID);
                            if (raType == null || !raType.getResourceAdaptorIDs().contains(componentID)) continue;
                            raTypeFromRa = raType.getResourceAdaptorTypeID().toString();
                        }
                        if (raTypeFromRa == null) continue;
                        this.componentIDs.add(linkName + "_@_" + raTypeFromRa);
                    }
                    cPreUninstallActions.add(new Object[]{"deactivateResourceAdaptorEntity", entityName});
                    cPreUninstallActions.add(new Object[]{"removeResourceAdaptorEntity", entityName});
                    if (raId != null) {
                        if (this.postInstallActions.containsKey(raId)) {
                            this.postInstallActions.get(raId).addAll(cPostInstallActions);
                        } else {
                            this.postInstallActions.put(raId, cPostInstallActions);
                        }
                        if (this.preUninstallActions.containsKey(raId)) {
                            this.preUninstallActions.get(raId).addAll(cPreUninstallActions);
                        } else {
                            this.preUninstallActions.put(raId, cPreUninstallActions);
                        }
                    }
                    cPostInstallActions = new ArrayList();
                    cPreUninstallActions = new ArrayList();
                    raId = null;
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                is = null;
            }
            try {
                if (componentJarFile != null) {
                    componentJarFile.close();
                }
            }
            finally {
                componentJarFile = null;
            }
        }
    }
}

