/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.slee.EventTypeID;
import javax.slee.InvalidStateException;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ResourceAdaptorEntityAlreadyExistsException;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.management.UnrecognizedLinkNameException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.resource.ResourceAdaptorTypeID;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.SbbIDImpl;
import org.mobicents.slee.container.deployment.jboss.DeployableUnit;
import org.mobicents.slee.resource.ResourceAdaptorEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManager {
    public static final DeploymentManager INSTANCE = new DeploymentManager();
    private static Logger logger = Logger.getLogger(DeploymentManager.class);
    private Collection<DeployableUnit> waitingForInstallDUs = new ConcurrentLinkedQueue<DeployableUnit>();
    private Collection<DeployableUnit> waitingForUninstallDUs = new ConcurrentLinkedQueue<DeployableUnit>();
    private ConcurrentHashMap<DeployableUnit, RepositoryClassLoader> replacedUCLs = new ConcurrentHashMap();
    private Collection<String> deployedComponents = new ConcurrentLinkedQueue<String>();
    private Collection<String> deploymentActions = Arrays.asList("install", "uninstall");
    private Collection<String> resourceAdaptorActions = Arrays.asList("bindLinkName", "unbindLinkName", "createResourceAdaptorEntity", "removeResourceAdaptorEntity", "activateResourceAdaptorEntity", "deactivateResourceAdaptorEntity");
    private Collection<String> serviceActions = Arrays.asList("activate", "deactivate");
    private Collection<String> deployActions = Arrays.asList("install", "activate", "bindLinkName", "createResourceAdaptorEntity", "activateResourceAdaptorEntity");
    private ConcurrentHashMap<DeployableUnit, Collection<String>> actionsToAvoidByDU = new ConcurrentHashMap();
    public long waitTimeBetweenOperations = 250L;

    private DeploymentManager() {
    }

    public void addDeployableUnit(DeployableUnit du) throws Exception {
        this.updateDeployedComponents();
        if (!this.deployedComponents.containsAll(du.getComponents())) {
            this.waitingForInstallDUs.add(du);
        } else {
            logger.warn((Object)("Trying to deploy a duplicate DU (" + du.getDeploymentInfoShortName() + ")."));
        }
    }

    public void updateDeployedComponents() {
        try {
            SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
            ConcurrentLinkedQueue<String> newDeployedComponents = new ConcurrentLinkedQueue<String>();
            ProfileSpecificationID[] sleeProfileSpecifications = sleeContainer.getSleeProfileManager().getProfileSpecificationManagement().getProfileSpecificationIDs();
            for (int i = 0; i < sleeProfileSpecifications.length; ++i) {
                newDeployedComponents.add(sleeProfileSpecifications[i].toString());
            }
            EventTypeID[] sleeEventTypes = sleeContainer.getEventManagement().getEventTypes();
            for (int i = 0; i < sleeEventTypes.length; ++i) {
                String eventTypeIDwithDUnit = sleeEventTypes[i].toString();
                newDeployedComponents.add(eventTypeIDwithDUnit.substring(0, eventTypeIDwithDUnit.indexOf(",")));
            }
            ResourceAdaptorTypeID[] sleeRATypes = sleeContainer.getResourceManagement().getResourceAdaptorTypeIDs();
            for (int i = 0; i < sleeRATypes.length; ++i) {
                newDeployedComponents.add(sleeRATypes[i].toString());
            }
            ResourceAdaptorID[] sleeResourceAdaptors = sleeContainer.getResourceManagement().getResourceAdaptorIDs();
            for (int i = 0; i < sleeResourceAdaptors.length; ++i) {
                newDeployedComponents.add(sleeResourceAdaptors[i].toString());
            }
            SbbIDImpl[] sleeSBBs = sleeContainer.getSbbManagement().getSbbIDs();
            for (int i = 0; i < sleeSBBs.length; ++i) {
                newDeployedComponents.add(sleeSBBs[i].toString());
            }
            ServiceID[] sleeServices = sleeContainer.getServiceManagement().getServiceIDs();
            for (int i = 0; i < sleeServices.length; ++i) {
                newDeployedComponents.add(sleeServices[i].toString());
            }
            String[] entityNames = sleeContainer.getResourceManagement().getResourceAdaptorEntities();
            for (int i = 0; i < entityNames.length; ++i) {
                String[] entityLinks;
                ResourceAdaptorEntity rae = sleeContainer.getResourceManagement().getResourceAdaptorEntity(entityNames[i]);
                if (rae == null || rae.getState() != ResourceAdaptorEntityState.ACTIVE) continue;
                String raTypeId = rae.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID().toString();
                for (String entityLink : entityLinks = sleeContainer.getResourceManagement().getLinkNames(rae.getName())) {
                    newDeployedComponents.add(entityLink + "_@_" + raTypeId);
                }
            }
            this.deployedComponents = newDeployedComponents;
        }
        catch (Exception e) {
            logger.warn((Object)"Failure while updating deployed components.", (Throwable)e);
        }
    }

    public void installDeployableUnit(DeployableUnit du) throws Exception {
        this.updateDeployedComponents();
        if (du.isReadyToInstall(true)) {
            this.sciAction(du.getInstallActions(), du);
            du.setInstalled(true);
            this.updateDeployedComponents();
            Iterator<DeployableUnit> duIt = this.waitingForInstallDUs.iterator();
            while (duIt.hasNext()) {
                DeployableUnit waitingDU = duIt.next();
                if (!waitingDU.isReadyToInstall(false)) continue;
                this.sciAction(waitingDU.getInstallActions(), du);
                waitingDU.setInstalled(true);
                this.updateDeployedComponents();
                this.waitingForInstallDUs.remove(waitingDU);
                duIt = this.waitingForInstallDUs.iterator();
            }
        } else {
            logger.warn((Object)("Unable to INSTALL " + du.getDeploymentInfoShortName() + " right now. Waiting for dependencies to be resolved."));
            this.waitingForInstallDUs.add(du);
        }
    }

    public void uninstallDeployableUnit(DeployableUnit du) throws Exception {
        this.updateDeployedComponents();
        if (!du.isInstalled()) {
            if (this.waitingForInstallDUs.remove(du)) {
                logger.info((Object)(du.getDeploymentInfoShortName() + " wasn't deployed. Removing from waiting list."));
            }
        } else if (du.isReadyToUninstall()) {
            this.sciAction(du.getUninstallActions(), du);
            du.setInstalled(false);
            this.updateDeployedComponents();
            RepositoryClassLoader repositoryClassLoader = this.replacedUCLs.remove(du);
            if (repositoryClassLoader != null) {
                repositoryClassLoader.unregister();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("replacedUCLs size is " + this.replacedUCLs.size() + " after removing DU " + du.getDeploymentInfoShortName()));
                }
            }
            Iterator<DeployableUnit> duIt = this.waitingForUninstallDUs.iterator();
            while (duIt.hasNext()) {
                DeployableUnit waitingDU = duIt.next();
                if (!waitingDU.isReadyToUninstall()) continue;
                this.sciAction(waitingDU.getUninstallActions(), du);
                waitingDU.setInstalled(false);
                this.updateDeployedComponents();
                this.waitingForUninstallDUs.remove(waitingDU);
                repositoryClassLoader = this.replacedUCLs.remove(waitingDU);
                if (repositoryClassLoader != null) {
                    repositoryClassLoader.unregister();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("replacedUCLs size is " + this.replacedUCLs.size() + " after removing DU " + du.getDeploymentInfoShortName()));
                    }
                }
                duIt = this.waitingForUninstallDUs.iterator();
            }
        } else {
            if (!this.waitingForUninstallDUs.contains(du)) {
                this.waitingForUninstallDUs.add(du);
                logger.warn((Object)("Unable to UNINSTALL " + du.getDeploymentInfoShortName() + " right now. Waiting for dependents to be removed."));
            }
            throw new DeploymentException("Unable to UNINSTALL " + du.getDeploymentInfoShortName() + " right now. Waiting for dependents to be removed.");
        }
    }

    public void addReplacedUCL(DeployableUnit du, RepositoryClassLoader ucl) {
        if (ucl != null) {
            this.replacedUCLs.put(du, ucl);
        }
    }

    private void sciAction(Collection<Object[]> actions, DeployableUnit du) throws Exception {
        MBeanServer ms = SleeContainer.lookupFromJndi().getMBeanServer();
        for (Object[] params : actions) {
            block21: {
                ObjectName objectName = null;
                Object[] arguments = new Object[params.length - 1];
                Object[] signature = new String[params.length - 1];
                String action = (String)params[0];
                if (this.actionsToAvoidByDU.get(du) != null && this.actionsToAvoidByDU.get(du).remove(action)) {
                    if (this.actionsToAvoidByDU.get(du).size() != 0) continue;
                    this.actionsToAvoidByDU.remove(du);
                    continue;
                }
                for (int i = 1; i < params.length; ++i) {
                    arguments[i - 1] = params[i];
                    signature[i - 1] = params[i].getClass().getName();
                }
                if (this.deploymentActions.contains(action)) {
                    objectName = new ObjectName("slee:name=DeploymentMBean");
                    if (action.equals("uninstall")) {
                        DeployableUnitID duID = (DeployableUnitID)ms.invoke(objectName, "getDeployableUnit", new Object[]{params[1]}, new String[]{params[1].getClass().getName()});
                        arguments[0] = duID;
                        signature[0] = "javax.slee.management.DeployableUnitID";
                    }
                } else if (this.resourceAdaptorActions.contains(action)) {
                    objectName = new ObjectName("slee:name=ResourceManagementMBean");
                    if (action.equals("createResourceAdaptorEntity")) {
                        signature[0] = "javax.slee.resource.ResourceAdaptorID";
                    }
                } else if (this.serviceActions.contains(action)) {
                    objectName = new ObjectName("slee:name=ServiceManagementMBean");
                    signature[0] = "javax.slee.ServiceID";
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Invoking " + action + "(" + Arrays.toString(signature) + ") on " + objectName));
                }
                try {
                    ms.invoke(objectName, action, arguments, (String[])signature);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof ResourceAdaptorEntityAlreadyExistsException || e.getCause() instanceof InvalidStateException && action.equals("activateResourceAdaptorEntity")) {
                        String actionToAvoid = "";
                        if (action.equals("activateResourceAdaptorEntity")) {
                            actionToAvoid = "deactivateResourceAdaptorEntity";
                        } else if (action.equals("createResourceAdaptorEntity")) {
                            actionToAvoid = "removeResourceAdaptorEntity";
                        }
                        Collection<String> actionsToAvoid = this.actionsToAvoidByDU.get(du);
                        if (actionsToAvoid == null) {
                            actionsToAvoid = new ArrayList<String>();
                            actionsToAvoid.add(actionToAvoid);
                            this.actionsToAvoidByDU.put(du, actionsToAvoid);
                        } else {
                            actionsToAvoid.add(actionToAvoid);
                        }
                        logger.warn((Object)e.getCause().getMessage());
                    }
                    if (e.getCause() instanceof InvalidStateException && action.equals("deactivate")) {
                        logger.info((Object)"Delaying uninstall due to service deactivation not complete.");
                    }
                    if (e.getCause() instanceof InvalidStateException && action.equals("deactivateResourceAdaptorEntity") || e.getCause() instanceof UnrecognizedLinkNameException && action.equals("unbindLinkName")) break block21;
                    if (this.deployActions.contains(action)) {
                        logger.error((Object)("Failure invoking '" + action + "(" + Arrays.toString(arguments) + ") on " + objectName), (Throwable)e);
                    }
                    throw e;
                }
            }
            Thread.sleep(this.waitTimeBetweenOperations);
        }
    }

    public Collection<String> getDeployedComponents() {
        return this.deployedComponents;
    }

    public String showStatus() {
        this.updateDeployedComponents();
        String output = "";
        output = output + "<p>Deployable Units Waiting For Install:</p>";
        for (DeployableUnit waitingDU : this.waitingForInstallDUs) {
            output = output + "+-- " + waitingDU.getDeploymentInfoShortName() + "<br>";
            for (String dependency : waitingDU.getExternalDependencies()) {
                if (!this.deployedComponents.contains(dependency)) {
                    dependency = dependency + " <strong>MISSING!</strong>";
                }
                output = output + "  +-- depends on " + dependency + "<br>";
            }
        }
        output = output + "<p>Deployable Units Waiting For Uninstall:</p>";
        for (DeployableUnit waitingDU : this.waitingForUninstallDUs) {
            output = output + "+-- " + waitingDU.getDeploymentInfoShortName() + "<br>";
        }
        return output;
    }
}

