/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceController;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.mobicents.slee.container.deployment.jboss.DeployableUnitWrapper;
import org.mobicents.slee.container.deployment.jboss.SLEEDeploymentMetaData;
import org.mobicents.slee.container.deployment.jboss.SLEESubDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLEEDeployer
extends AbstractSimpleVFSRealDeployer<SLEEDeploymentMetaData> {
    private static Logger logger = Logger.getLogger(SLEEDeployer.class);

    public SLEEDeployer(ServiceController serviceController) {
        super(SLEEDeploymentMetaData.class);
        this.setOutput(SLEEDeploymentMetaData.class);
        logger.info((Object)"\u00aa\u00aa\u00aa\u00aa\u00aa SLEE Real Deployer Initialized! \u00b4\u00b4\u00b4\u00b4\u00b4");
    }

    public void deploy(VFSDeploymentUnit vfsDU, SLEEDeploymentMetaData sdmd) throws DeploymentException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SLEEParserDeployer 'deploy' called:");
            logger.trace((Object)("vfsDeploymentUnit.." + vfsDU));
            logger.trace((Object)("sdmd..............." + sdmd));
        }
        if (sdmd != null) {
            try {
                SLEESubDeployer ssdeployer = SLEESubDeployer.INSTANCE;
                DeployableUnitWrapper duWrapper = new DeployableUnitWrapper(VFSUtils.getCompatibleURL((VirtualFile)vfsDU.getRoot()));
                ssdeployer.accepts(duWrapper);
                ssdeployer.init(duWrapper);
                for (String componentJar : sdmd.duContents) {
                    DeployableUnitWrapper duWrapperComp = new DeployableUnitWrapper(VFSUtils.getCompatibleURL((VirtualFile)vfsDU.getFile(componentJar)));
                    ssdeployer.accepts(duWrapperComp);
                    ssdeployer.init(duWrapperComp);
                    ssdeployer.create(duWrapperComp);
                    ssdeployer.start(duWrapperComp);
                }
                ssdeployer.create(duWrapper);
                ssdeployer.start(duWrapper);
            }
            catch (Exception e) {
                logger.error((Object)("Failure while deploying " + vfsDU.getName()), (Throwable)e);
            }
        }
    }

    public void undeploy(VFSDeploymentUnit vfsDU, SLEEDeploymentMetaData sdmd) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SLEEParserDeployer 'undeploy' called:");
            logger.trace((Object)("vfsDeploymentUnit.." + vfsDU));
            logger.trace((Object)("sdmd..............." + sdmd));
        }
        if (sdmd != null) {
            try {
                SLEESubDeployer ssdeployer = SLEESubDeployer.INSTANCE;
                DeployableUnitWrapper duWrapper = new DeployableUnitWrapper(VFSUtils.getCompatibleURL((VirtualFile)vfsDU.getRoot()));
                ssdeployer.stop(duWrapper);
                ssdeployer.destroy(duWrapper);
            }
            catch (Exception e) {
                logger.error((Object)("Failure while undeploying " + vfsDU.getName()), (Throwable)e);
            }
        }
    }
}

