/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.component.DeployableUnitDescriptorImpl;
import org.mobicents.slee.container.deployment.jboss.DeployableComponent;
import org.mobicents.slee.container.deployment.jboss.DeployableUnit;
import org.mobicents.slee.container.deployment.jboss.DeployableUnitWrapper;
import org.mobicents.slee.container.deployment.jboss.DeploymentManager;
import org.mobicents.slee.container.deployment.jboss.SLEESubDeployerMBean;
import org.mobicents.slee.container.management.jmx.MobicentsManagement;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SLEESubDeployer
extends SubDeployerSupport
implements SLEESubDeployerMBean,
NotificationListener {
    public static final SLEESubDeployer INSTANCE = new SLEESubDeployer();
    public static final String DEPLOYMENT_EXTENSION = ".mar";
    public static final String BASE_SCRIPT_OBJECT_NAME = "jboss.scripts:type=BeanShell";
    private static Logger logger = Logger.getLogger(SLEESubDeployer.class);
    private static Timer timer = new Timer();
    private ConcurrentHashMap<String, DeployableUnitWrapper> toAccept = new ConcurrentHashMap();
    private ConcurrentHashMap<String, DeployableUnit> deployableUnits = new ConcurrentHashMap();
    private boolean isNotificationEnabled = false;
    private boolean isServerShuttingDown = false;

    private SLEESubDeployer() {
        this.setSuffixes(new String[]{DEPLOYMENT_EXTENSION, "xml", "jar"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(DeployableUnitWrapper du) {
        URL url = du.getUrl();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method accepts called for " + url));
        }
        try {
            String fullPath = url.getFile();
            String fileName = fullPath.substring(fullPath.lastIndexOf(47) + 1, fullPath.length());
            if (du.isDirectory()) {
                if (!fileName.endsWith(DEPLOYMENT_EXTENSION)) return false;
                if (!logger.isDebugEnabled()) return true;
                logger.debug((Object)("Accepting MAR DIRECTORY " + url.toString() + "."));
                return true;
            }
            if (this.toAccept.containsKey(fileName) || fileName.endsWith(DEPLOYMENT_EXTENSION)) {
                if (!logger.isDebugEnabled()) return true;
                logger.debug((Object)("Accepting " + url.toString() + "."));
                return true;
            }
            if (!fileName.endsWith(".jar")) return false;
            ZipFile duJarFile = null;
            try {
                if (du.getEntry("META-INF/deployable-unit.xml") == null) return false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Accepting " + url.toString() + "."));
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (duJarFile != null) {
                    try {
                        try {
                            duJarFile.close();
                            duJarFile = null;
                        }
                        catch (IOException ignore) {
                            duJarFile = null;
                        }
                    }
                    catch (Throwable throwable) {
                        duJarFile = null;
                        throw throwable;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DeployableUnitWrapper du) throws DeploymentException {
        block27: {
            URL url = du.getUrl();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Method init called for " + url));
            }
            if (this.server != null && !this.isNotificationEnabled) {
                try {
                    this.server.addNotificationListener(new ObjectName("jboss.system:type=Server"), this, null, (Object)"");
                    this.isNotificationEnabled = true;
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to register notification listener.", (Throwable)e);
                }
            }
            String fullPath = du.getFullPath();
            String fileName = du.getFileName();
            try {
                DeployableUnitWrapper duWrapper = null;
                duWrapper = this.toAccept.remove(fileName);
                if (duWrapper != null) {
                    DeployableComponent dc = new DeployableComponent(du, url, fileName);
                    DeployableUnit deployerDU = this.deployableUnits.get(duWrapper.getFileName());
                    for (DeployableComponent subDC : dc.getSubComponents()) {
                        deployerDU.addComponent(subDC);
                    }
                    break block27;
                }
                if (!fileName.endsWith(".jar")) break block27;
                JarFile duJarFile = null;
                try {
                    duJarFile = new JarFile(fullPath);
                    JarEntry duXmlEntry = duJarFile.getJarEntry("META-INF/deployable-unit.xml");
                    if (duXmlEntry != null) {
                        int beginIndex;
                        DeployableUnit deployerDU = new DeployableUnit(du);
                        DeployableUnitDescriptorImpl duDesc = this.parseDUDescriptor(duJarFile);
                        this.deployableUnits.put(fileName, deployerDU);
                        for (Element elem : duDesc.getJarNodes()) {
                            String componentJarName = elem.getTextContent().trim();
                            beginIndex = componentJarName.lastIndexOf(47);
                            if (beginIndex == -1) {
                                beginIndex = componentJarName.lastIndexOf(92);
                            }
                            componentJarName = componentJarName.substring(++beginIndex, componentJarName.length());
                            this.toAccept.put(componentJarName, du);
                        }
                        for (Element elem : duDesc.getServiceNodes()) {
                            String serviceXMLName = elem.getTextContent().trim();
                            beginIndex = serviceXMLName.lastIndexOf(47);
                            if (beginIndex == -1) {
                                beginIndex = serviceXMLName.lastIndexOf(92);
                            }
                            serviceXMLName = serviceXMLName.substring(++beginIndex, serviceXMLName.length());
                            this.toAccept.put(serviceXMLName, du);
                        }
                    }
                }
                finally {
                    if (duJarFile != null) {
                        try {
                            duJarFile.close();
                        }
                        catch (IOException ignore) {
                        }
                        finally {
                            duJarFile = null;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deployment of " + fileName + " failed."), (Throwable)e);
                }
                logger.error((Object)("Deployment of " + fileName + " failed. "), (Throwable)e);
                return;
            }
        }
    }

    public void create(DeployableUnitWrapper du) throws DeploymentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method create called for " + du.getUrl()));
        }
    }

    public void start(DeployableUnitWrapper du) throws DeploymentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method start called for " + du.getUrl()));
        }
        try {
            DeployableUnit realDU = this.deployableUnits.get(du.getFileName());
            if (realDU != null) {
                DeploymentManager.INSTANCE.installDeployableUnit(realDU);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public void stop(DeployableUnitWrapper du) throws DeploymentException {
        DeployableUnit realDU = null;
        String fileName = du.getFileName();
        realDU = this.deployableUnits.get(du.getFileName());
        if (realDU != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Got DU: " + realDU.getDeploymentInfoShortName()));
            }
            boolean oldIsServerShuttingDown = this.isServerShuttingDown;
            this.isServerShuttingDown = true;
            if (this.isServerShuttingDown) {
                this.doStop(fileName);
            } else {
                timer.scheduleAtFixedRate((TimerTask)new UndeploymentTask(fileName), 0L, this.getWaitTimeBetweenOperations());
            }
            this.isServerShuttingDown = oldIsServerShuttingDown;
        }
    }

    private boolean doStop(String filename) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method stop called for " + filename));
        }
        DeployableUnit du = null;
        try {
            du = this.deployableUnits.get(filename);
            if (du != null) {
                DeploymentManager.INSTANCE.uninstallDeployableUnit(du);
                this.deployableUnits.remove(filename);
                du = null;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void destroy(DeployableUnitWrapper du) throws DeploymentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method destroy called for " + du.getUrl()));
        }
    }

    public String showStatus() throws DeploymentException {
        String output = "";
        output = output + "<p>Deployable Units List:</p>";
        for (String key : this.deployableUnits.keySet()) {
            output = output + "&lt;" + key + "&gt; [" + this.deployableUnits.get(key) + "]<br>";
            for (String duComponent : this.deployableUnits.get(key).getComponents()) {
                output = output + "+-- " + duComponent + "<br>";
            }
        }
        output = output + "<p>To Accept List:</p>";
        for (String key : this.toAccept.keySet()) {
            output = output + "&lt;" + key + "&gt; [" + this.toAccept.get(key) + "]<br>";
        }
        output = output + "<p>Deployment Manager Status</p>";
        output = output + DeploymentManager.INSTANCE.showStatus();
        return output;
    }

    public long getWaitTimeBetweenOperations() {
        return DeploymentManager.INSTANCE.waitTimeBetweenOperations;
    }

    public void setWaitTimeBetweenOperations(long waitTime) {
        DeploymentManager.INSTANCE.waitTimeBetweenOperations = waitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeployableUnitDescriptorImpl parseDUDescriptor(JarFile unitJarFile) throws DeploymentException {
        JarEntry duXmlEntry = unitJarFile.getJarEntry("META-INF/deployable-unit.xml");
        if (duXmlEntry == null) {
            throw new DeploymentException("No DeployableUnitDeploymentDescriptor descriptor (META-INF/deployable-unit.xml) was found in deployable unit" + unitJarFile.getName());
        }
        Document doc = null;
        InputStream is = null;
        try {
            is = unitJarFile.getInputStream(duXmlEntry);
            doc = XMLUtils.parseDocument((InputStream)is, (boolean)false);
        }
        catch (IOException ex) {
            throw new DeploymentException("Failed to extract the DU depl descriptor from " + unitJarFile.getName());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {
                }
                finally {
                    is = null;
                }
            }
        }
        Element duNode = doc.getDocumentElement();
        DeployableUnitDescriptorImpl deployableUnitDescriptor = new DeployableUnitDescriptorImpl(unitJarFile.getName(), new Date());
        try {
            String description = XMLUtils.getElementTextValue((Element)duNode, (String)"description");
            if (description != null) {
                deployableUnitDescriptor.setDescription(description);
            }
        }
        catch (Exception ex) {
            throw new DeploymentException(ex.getMessage());
        }
        List jarNodes = XMLUtils.getAllChildElements((Element)duNode, (String)"jar");
        deployableUnitDescriptor.setJarNodes((Collection)jarNodes);
        List serviceNodes = XMLUtils.getAllChildElements((Element)duNode, (String)"service-xml");
        deployableUnitDescriptor.setServiceNodes((Collection)serviceNodes);
        if (jarNodes.size() == 0 && serviceNodes.size() == 0) {
            throw new DeploymentException("The " + unitJarFile.getName() + " deployable unit contains no jars or services");
        }
        return deployableUnitDescriptor;
    }

    public void handleNotification(Notification notification, Object o) {
        if (notification.getType().equals("org.jboss.system.server.stopped")) {
            this.isServerShuttingDown = true;
        }
    }

    private class UndeploymentTask
    extends TimerTask {
        String filename;
        long startTime;

        public UndeploymentTask(String filename) {
            this.filename = filename;
            this.startTime = System.currentTimeMillis();
        }

        public void run() {
            try {
                long elapsedTime = System.currentTimeMillis() - this.startTime;
                if (SLEESubDeployer.this.doStop(this.filename) || (double)elapsedTime > 3600000.0 + MobicentsManagement.entitiesRemovalDelay) {
                    this.cancel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

