/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.slee.ComponentID;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.EventTypeDescriptorFactory;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.EventTypeDescriptorImpl;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.LibraryDescriptorFactory;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.LibraryDescriptorImpl;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.ProfileSpecificationDescriptorFactory;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.ResourceAdaptorDescriptorFactory;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.ResourceAdaptorDescriptorImpl;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.ResourceAdaptorTypeDescriptorFactory;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.ResourceAdaptorTypeDescriptorImpl;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.SbbDescriptorFactory;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.SbbDescriptorImpl;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.ServiceDescriptorFactory;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.ServiceDescriptorImpl;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.sbb.MResourceAdaptorEntityBinding;
import org.mobicents.slee.container.component.deployment.jaxb.descriptors.sbb.MResourceAdaptorTypeBinding;
import org.mobicents.slee.container.deployment.jboss.DeployableUnit;
import org.mobicents.slee.container.deployment.jboss.DeployableUnitWrapper;
import org.mobicents.slee.container.management.jmx.editors.ComponentIDPropertyEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableComponent {
    private static Logger logger = Logger.getLogger(DeployableComponent.class);
    public static final int PROFILESPEC_COMPONENT = 1;
    public static final int EVENTTYPE_COMPONENT = 2;
    public static final int RATYPE_COMPONENT = 3;
    public static final int RA_COMPONENT = 4;
    public static final int SBB_COMPONENT = 5;
    public static final int SERVICE_COMPONENT = 6;
    public static final int LIBRARY_COMPONENT = 7;
    private String diShortName;
    private URL diURL;
    private ComponentID componentID;
    private Collection<String> dependencies = new ArrayList<String>();
    private Collection<Object[]> installActions = new ArrayList<Object[]>();
    private Collection<Object[]> uninstallActions = new ArrayList<Object[]>();
    private String componentKey;
    private int componentType = -1;
    private DeployableUnitWrapper duWrapper;
    private Collection<DeployableComponent> subComponents = new ArrayList<DeployableComponent>();

    private DeployableComponent(DeployableComponent dc) throws Exception {
        this.diShortName = dc.diShortName;
        this.diURL = dc.diURL;
        this.subComponents = null;
    }

    public DeployableComponent(URL url, String fileName) throws Exception {
        this.diShortName = fileName;
        this.diURL = url;
        this.subComponents = this.parseDescriptor();
    }

    public DeployableComponent(DeployableUnitWrapper duWrapper, URL url, String fileName) throws Exception {
        this.duWrapper = duWrapper;
        this.diShortName = fileName;
        this.diURL = url;
        this.subComponents = this.parseDescriptor();
    }

    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    public boolean isDeployable(Collection<String> deployedComponents) {
        return deployedComponents.containsAll(this.dependencies);
    }

    public String getComponentKey() {
        return this.componentKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<DeployableComponent> parseDescriptor() throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Parsing Descriptor for " + this.diURL.toString()));
        }
        ArrayList<DeployableComponent> deployableComponents = new ArrayList<DeployableComponent>();
        if (this.diShortName.endsWith(".xml")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing Service Descriptor.");
            }
            InputStream is = null;
            try {
                is = this.diURL.openStream();
                ServiceDescriptorFactory sdf = new ServiceDescriptorFactory();
                List serviceDescriptors = sdf.parse(is);
                for (ServiceDescriptorImpl sd : serviceDescriptors) {
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 6;
                    dc.componentID = sd.getServiceID();
                    dc.componentKey = this.getComponentIdAsString(dc.componentID);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                        logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                    }
                    Set serviceDependencies = sd.getDependenciesSet();
                    for (ComponentID dependencyId : serviceDependencies) {
                        dc.dependencies.add(this.getComponentIdAsString(dependencyId));
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)this.getComponentIdAsString(dependencyId));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                    }
                    dc.installActions.add(new Object[]{"activate", dc.componentID});
                    dc.uninstallActions.add(new Object[]{"deactivate", dc.componentID});
                    deployableComponents.add(dc);
                }
                ArrayList<DeployableComponent> i$ = deployableComponents;
                return i$;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                Collection<DeployableComponent> serviceDescriptors = null;
                return serviceDescriptors;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        URL descriptorXML = null;
        descriptorXML = this.duWrapper.getEntry("META-INF/sbb-jar.xml");
        if (descriptorXML != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing SBB Descriptor.");
            }
            InputStream is = null;
            try {
                is = descriptorXML.openStream();
                SbbDescriptorFactory sbbdf = new SbbDescriptorFactory();
                List sbbDescriptors = sbbdf.parse(is);
                if (sbbDescriptors.size() == 0) {
                    logger.warn((Object)("The " + this.duWrapper.getFileName() + " deployment descriptor contains no sbb definitions"));
                    Collection<DeployableComponent> sd = null;
                    return sd;
                }
                Iterator i$ = sbbDescriptors.iterator();
                while (i$.hasNext()) {
                    SbbDescriptorImpl sbbDescriptor = (SbbDescriptorImpl)i$.next();
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 5;
                    dc.componentID = sbbDescriptor.getSbbID();
                    dc.componentKey = this.getComponentIdAsString(dc.componentID);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                        logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                    }
                    Set sbbDependencies = sbbDescriptor.getDependenciesSet();
                    for (ComponentID dependencyId : sbbDependencies) {
                        dc.dependencies.add(this.getComponentIdAsString(dependencyId));
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)this.getComponentIdAsString(dependencyId));
                    }
                    for (MResourceAdaptorTypeBinding raTypeBinding : sbbDescriptor.getResourceAdaptorTypeBindings()) {
                        for (MResourceAdaptorEntityBinding raEntityBinding : raTypeBinding.getResourceAdaptorEntityBinding()) {
                            String raLink = raEntityBinding.getResourceAdaptorEntityLink() + "_@_" + this.getComponentIdAsString((ComponentID)raTypeBinding.getResourceAdaptorTypeRef());
                            dc.dependencies.add(raLink);
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace((Object)raLink);
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                    }
                    deployableComponents.add(dc);
                }
                return deployableComponents;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return deployableComponents;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        descriptorXML = this.duWrapper.getEntry("META-INF/profile-spec-jar.xml");
        if (descriptorXML != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing Profile Specification Descriptor.");
            }
            InputStream is = null;
            try {
                is = descriptorXML.openStream();
                ProfileSpecificationDescriptorFactory psdf = new ProfileSpecificationDescriptorFactory();
                List psDescriptors = psdf.parse(is);
                if (psDescriptors.size() == 0) {
                    logger.warn((Object)("The " + this.duWrapper.getFileName() + " deployment descriptor contains no profile-spec definitions"));
                    Collection<DeployableComponent> i$ = null;
                    return i$;
                }
                Iterator i$ = psDescriptors.iterator();
                while (i$.hasNext()) {
                    ProfileSpecificationDescriptorImpl psDescriptor = (ProfileSpecificationDescriptorImpl)i$.next();
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 1;
                    dc.componentID = psDescriptor.getProfileSpecificationID();
                    dc.componentKey = this.getComponentIdAsString(dc.componentID);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                        logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                    }
                    Set psDependencies = psDescriptor.getDependenciesSet();
                    for (ComponentID dependencyId : psDependencies) {
                        dc.dependencies.add(this.getComponentIdAsString(dependencyId));
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)this.getComponentIdAsString(dependencyId));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                    }
                    deployableComponents.add(dc);
                }
                return deployableComponents;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return deployableComponents;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        descriptorXML = this.duWrapper.getEntry("META-INF/event-jar.xml");
        if (descriptorXML != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing Event Definition Descriptor.");
            }
            InputStream is = null;
            try {
                is = descriptorXML.openStream();
                EventTypeDescriptorFactory etdf = new EventTypeDescriptorFactory();
                List etDescriptors = etdf.parse(is);
                if (etDescriptors == null || etDescriptors.size() == 0) {
                    logger.warn((Object)("The " + this.duWrapper.getFileName() + " deployment descriptor contains no event-type definitions"));
                    Collection<DeployableComponent> i$ = null;
                    return i$;
                }
                Iterator i$ = etDescriptors.iterator();
                while (i$.hasNext()) {
                    EventTypeDescriptorImpl etDescriptor = (EventTypeDescriptorImpl)i$.next();
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 2;
                    dc.componentID = etDescriptor.getEventTypeID();
                    dc.componentKey = this.getComponentIdAsString(dc.componentID);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                        logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                    }
                    Set etDependencies = etDescriptor.getDependenciesSet();
                    for (ComponentID dependencyId : etDependencies) {
                        dc.dependencies.add(this.getComponentIdAsString(dependencyId));
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)this.getComponentIdAsString(dependencyId));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                    }
                    deployableComponents.add(dc);
                }
                return deployableComponents;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return deployableComponents;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        descriptorXML = this.duWrapper.getEntry("META-INF/resource-adaptor-type-jar.xml");
        if (descriptorXML != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing Resource Adaptor Type Descriptor.");
            }
            InputStream is = null;
            try {
                is = descriptorXML.openStream();
                ResourceAdaptorTypeDescriptorFactory ratdf = new ResourceAdaptorTypeDescriptorFactory();
                List ratDescriptors = ratdf.parse(is);
                if (ratDescriptors == null || ratDescriptors.size() == 0) {
                    logger.warn((Object)("The " + this.duWrapper.getFileName() + " deployment descriptor contains no resource-adaptor-type definitions"));
                    Collection<DeployableComponent> i$ = null;
                    return i$;
                }
                Iterator i$ = ratDescriptors.iterator();
                while (i$.hasNext()) {
                    ResourceAdaptorTypeDescriptorImpl ratDescriptor = (ResourceAdaptorTypeDescriptorImpl)i$.next();
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 3;
                    dc.componentID = ratDescriptor.getResourceAdaptorTypeID();
                    dc.componentKey = this.getComponentIdAsString(dc.componentID);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                        logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                    }
                    Set ratDependencies = ratDescriptor.getDependenciesSet();
                    for (ComponentID dependencyId : ratDependencies) {
                        dc.dependencies.add(this.getComponentIdAsString(dependencyId));
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)this.getComponentIdAsString(dependencyId));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                    }
                    deployableComponents.add(dc);
                }
                return deployableComponents;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return deployableComponents;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        descriptorXML = this.duWrapper.getEntry("META-INF/resource-adaptor-jar.xml");
        if (descriptorXML != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Parsing Resource Adaptor Descriptor.");
            }
            InputStream is = null;
            try {
                is = descriptorXML.openStream();
                ResourceAdaptorDescriptorFactory radf = new ResourceAdaptorDescriptorFactory();
                List raDescriptors = radf.parse(is);
                Iterator i$ = raDescriptors.iterator();
                while (i$.hasNext()) {
                    ResourceAdaptorDescriptorImpl raDescriptor = (ResourceAdaptorDescriptorImpl)i$.next();
                    DeployableComponent dc = new DeployableComponent(this);
                    dc.componentType = 4;
                    dc.componentID = raDescriptor.getResourceAdaptorID();
                    dc.componentKey = this.getComponentIdAsString(dc.componentID);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Component ID: " + dc.componentKey));
                        logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                    }
                    Set raDependencies = raDescriptor.getDependenciesSet();
                    for (ComponentID dependencyId : raDependencies) {
                        dc.dependencies.add(this.getComponentIdAsString(dependencyId));
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)this.getComponentIdAsString(dependencyId));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                    }
                    deployableComponents.add(dc);
                }
                return deployableComponents;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return deployableComponents;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        descriptorXML = this.duWrapper.getEntry("META-INF/library-jar.xml");
        if (descriptorXML == null) {
            logger.warn((Object)("\r\n--------------------------------------------------------------------------------\r\nNo Component Descriptor found in '" + this.duWrapper.getFileName() + "'.\r\n" + "--------------------------------------------------------------------------------"));
            return new ArrayList<DeployableComponent>();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Parsing Library Descriptor.");
        }
        InputStream is = null;
        try {
            is = descriptorXML.openStream();
            LibraryDescriptorFactory ldf = new LibraryDescriptorFactory();
            List libraryDescriptors = ldf.parse(is);
            Iterator i$ = libraryDescriptors.iterator();
            while (i$.hasNext()) {
                LibraryDescriptorImpl libraryDescriptor = (LibraryDescriptorImpl)i$.next();
                DeployableComponent dc = new DeployableComponent(this);
                dc.componentType = 7;
                dc.componentID = libraryDescriptor.getLibraryID();
                dc.componentKey = this.getComponentIdAsString(dc.componentID);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Component ID: " + dc.componentKey));
                    logger.trace((Object)"------------------------------ Dependencies ------------------------------");
                }
                Set libraryDependencies = libraryDescriptor.getDependenciesSet();
                for (ComponentID dependencyId : libraryDependencies) {
                    dc.dependencies.add(this.getComponentIdAsString(dependencyId));
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)this.getComponentIdAsString(dependencyId));
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"--------------------------- End of Dependencies --------------------------");
                }
                deployableComponents.add(dc);
            }
            return deployableComponents;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return deployableComponents;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                finally {
                    is = null;
                }
            }
        }
    }

    public Collection<Object[]> getInstallActions() {
        return this.installActions;
    }

    public Collection<Object[]> getUninstallActions() {
        return this.uninstallActions;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public ComponentID getComponentID() {
        return this.componentID;
    }

    public Collection<DeployableComponent> getSubComponents() {
        return this.subComponents;
    }

    public boolean isUndeployable(DeployableUnit du) {
        boolean result = false;
        switch (this.componentType) {
            case 1: {
                result = true;
                break;
            }
            case 2: {
                result = true;
                break;
            }
            case 3: {
                result = true;
                break;
            }
            case 4: {
                result = true;
                break;
            }
            case 5: {
                result = true;
                break;
            }
            case 6: {
                result = true;
                break;
            }
            case 7: {
                result = true;
            }
        }
        return result;
    }

    private String getComponentIdAsString(ComponentID componentId) {
        ComponentIDPropertyEditor cidPropertyEditor = new ComponentIDPropertyEditor();
        cidPropertyEditor.setValue((Object)componentId);
        return cidPropertyEditor.getAsText();
    }
}

