/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.slee.ComponentID;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentRepositoryImpl;
import org.mobicents.slee.container.component.ResourceAdaptorComponent;
import org.mobicents.slee.container.deployment.jboss.DeployableComponent;
import org.mobicents.slee.container.deployment.jboss.DeployableUnitWrapper;
import org.mobicents.slee.container.deployment.jboss.DeploymentManager;
import org.mobicents.slee.container.management.jmx.editors.ComponentIDPropertyEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableUnit {
    private static Logger logger = Logger.getLogger(DeployableUnit.class);
    private String diShortName;
    private URL diURL;
    private Collection<DeployableComponent> components = new ArrayList<DeployableComponent>();
    private Collection<String> componentIDs = new ArrayList<String>();
    private Collection<String> dependencies = new ArrayList<String>();
    private Collection<Object[]> installActions = new ArrayList<Object[]>();
    private HashMap<String, Collection<Object[]>> postInstallActions = new HashMap();
    private HashMap<String, Collection<Object[]>> preUninstallActions = new HashMap();
    private Collection<Object[]> uninstallActions = new ArrayList<Object[]>();
    private boolean isInstalled = false;

    public DeployableUnit(DeployableUnitWrapper du) throws Exception {
        this.diShortName = du.getFileName();
        this.diURL = du.getUrl();
        this.installActions.add(new Object[]{"install", this.diURL.toString()});
        this.parseDeployConfig();
    }

    public void addComponent(DeployableComponent dc) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding Component " + dc.getComponentKey()));
        }
        this.components.add(dc);
        this.componentIDs.add(dc.getComponentKey());
        this.dependencies.addAll(dc.getDependencies());
        this.installActions.addAll(dc.getInstallActions());
        Collection<Object[]> postInstallActionsStrings = this.postInstallActions.remove(dc.getComponentKey());
        if (postInstallActionsStrings != null && postInstallActionsStrings.size() > 0) {
            this.installActions.addAll(postInstallActionsStrings);
        } else if (dc.getComponentType() == 4) {
            ComponentID cid = dc.getComponentID();
            String raID = dc.getComponentKey();
            logger.warn((Object)("\r\n------------------------------------------------------------\r\nNo RA Entity and Link config for " + raID + " found. Using default values!" + "\r\n------------------------------------------------------------"));
            String raName = cid.getName();
            this.installActions.add(new Object[]{"createResourceAdaptorEntity", cid, raName, new ConfigProperties()});
            this.installActions.add(new Object[]{"activateResourceAdaptorEntity", raName});
            this.installActions.add(new Object[]{"bindLinkName", raName, raName});
            this.uninstallActions.add(new Object[]{"unbindLinkName", raName});
            this.uninstallActions.add(new Object[]{"deactivateResourceAdaptorEntity", raName});
            this.uninstallActions.add(new Object[]{"removeResourceAdaptorEntity", raName});
        }
        Collection<Object[]> preUninstallActionsStrings = this.preUninstallActions.remove(dc.getComponentKey());
        if (preUninstallActionsStrings != null) {
            this.uninstallActions.addAll(preUninstallActionsStrings);
        }
        this.uninstallActions.addAll(dc.getUninstallActions());
    }

    public boolean isSelfSufficient() {
        return this.componentIDs.containsAll(this.dependencies);
    }

    public Collection<String> getExternalDependencies() {
        Collection<String> externalDependencies = this.dependencies;
        externalDependencies.removeAll(this.componentIDs);
        return externalDependencies;
    }

    public boolean hasDependenciesSatisfied(boolean showMissing) {
        if (this.isSelfSufficient()) {
            return true;
        }
        Collection<String> externalDependencies = this.getExternalDependencies();
        externalDependencies.removeAll(DeploymentManager.INSTANCE.getDeployedComponents());
        if (externalDependencies.size() > 0) {
            if (showMissing) {
                String missingDepList = "";
                for (String missingDep : externalDependencies) {
                    missingDepList = missingDepList + "\r\n +-- " + missingDep;
                }
                logger.info((Object)("Missing dependencies for " + this.diShortName + ":" + missingDepList));
            }
            return false;
        }
        return true;
    }

    public boolean hasDuplicates() {
        ArrayList<String> duplicates = new ArrayList<String>();
        for (String componentId : this.componentIDs) {
            if (!DeploymentManager.INSTANCE.getDeployedComponents().contains(componentId)) continue;
            duplicates.add(componentId);
        }
        if (duplicates.size() > 0) {
            logger.warn((Object)("The deployable unit '" + this.diShortName + "' contains components that are already deployed. The following are already installed:"));
            for (String dupComponent : duplicates) {
                logger.warn((Object)(" - " + dupComponent));
            }
            return true;
        }
        return false;
    }

    public boolean isReadyToInstall(boolean showMissing) {
        return this.hasDependenciesSatisfied(showMissing) && !this.hasDuplicates();
    }

    public Collection<Object[]> getInstallActions() {
        ArrayList<Object[]> iActions = new ArrayList<Object[]>();
        iActions.addAll(this.installActions);
        if (this.postInstallActions.values().size() > 0) {
            for (String componentId : this.postInstallActions.keySet()) {
                iActions.addAll(this.postInstallActions.get(componentId));
            }
        }
        return iActions;
    }

    public Collection<Object[]> getUninstallActions() {
        ArrayList<Object[]> uActions = new ArrayList<Object[]>(this.uninstallActions);
        if (this.preUninstallActions.values().size() > 0) {
            for (String componentId : this.preUninstallActions.keySet()) {
                uActions.addAll(this.preUninstallActions.get(componentId));
            }
        }
        uActions.add(new Object[]{"uninstall", this.diURL.toString()});
        return uActions;
    }

    public Collection<String> getComponents() {
        return this.componentIDs;
    }

    public boolean isReadyToUninstall() throws Exception {
        if (this.isInstalled && !this.hasReferringDU()) {
            for (DeployableComponent dc : this.components) {
                if (dc.isUndeployable(this)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean hasReferringDU() throws Exception {
        SleeContainer sC = SleeContainer.lookupFromJndi();
        for (String componentIdString : this.getComponents()) {
            ComponentIDPropertyEditor cidpe = new ComponentIDPropertyEditor();
            cidpe.setAsText(componentIdString);
            ComponentID componentId = (ComponentID)cidpe.getValue();
            for (ComponentID referringComponentId : sC.getComponentRepositoryImpl().getReferringComponents(componentId)) {
                ComponentIDPropertyEditor rcidpe = new ComponentIDPropertyEditor();
                rcidpe.setValue((Object)referringComponentId);
                String referringComponentIdString = rcidpe.getAsText();
                if (this.getComponents().contains(referringComponentIdString)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDeploymentInfoShortName() {
        return this.diShortName;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public void setInstalled(boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDeployConfig() throws Exception {
        JarFile componentJarFile = null;
        InputStream is = null;
        try {
            componentJarFile = new JarFile(this.diURL.getFile());
            JarEntry deployInfoXML = componentJarFile.getJarEntry("META-INF/deploy-config.xml");
            InputStream inputStream = is = deployInfoXML != null ? componentJarFile.getInputStream(deployInfoXML) : null;
            if (is != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                NodeList raEntities = doc.getElementsByTagName("ra-entity");
                String raId = null;
                ArrayList<Object[]> cPostInstallActions = new ArrayList<Object[]>();
                ArrayList<Object[]> cPreUninstallActions = new ArrayList<Object[]>();
                for (int i = 0; i < raEntities.getLength(); ++i) {
                    Element raEntity = (Element)raEntities.item(i);
                    ComponentIDPropertyEditor cidpe = new ComponentIDPropertyEditor();
                    cidpe.setAsText(raEntity.getAttribute("resource-adaptor-id"));
                    raId = cidpe.getValue().toString();
                    String entityName = raEntity.getAttribute("entity-name");
                    NodeList propsNodeList = raEntity.getElementsByTagName("properties");
                    if (propsNodeList.getLength() > 1) {
                        logger.warn((Object)"Invalid ra-entity element, has more than one properties child. Reading only first.");
                    }
                    ConfigProperties props = new ConfigProperties();
                    cidpe.setAsText(raEntity.getAttribute("resource-adaptor-id"));
                    ResourceAdaptorID componentID = (ResourceAdaptorID)cidpe.getValue();
                    cPostInstallActions.add(new Object[]{"createResourceAdaptorEntity", componentID, entityName, props});
                    cPostInstallActions.add(new Object[]{"activateResourceAdaptorEntity", entityName});
                    NodeList links = raEntity.getElementsByTagName("ra-link");
                    for (int j = 0; j < links.getLength(); ++j) {
                        String linkName = ((Element)links.item(j)).getAttribute("name");
                        cPostInstallActions.add(new Object[]{"bindLinkName", entityName, linkName});
                        cPreUninstallActions.add(new Object[]{"unbindLinkName", linkName});
                        ComponentRepositoryImpl componentRepository = SleeContainer.lookupFromJndi().getComponentRepositoryImpl();
                        ResourceAdaptorComponent raComponent = componentRepository.getComponentByID(componentID);
                        if (raComponent == null) continue;
                        for (ResourceAdaptorTypeID resourceAdaptorTypeID : raComponent.getSpecsDescriptor().getResourceAdaptorTypes()) {
                            this.componentIDs.add(linkName + "_@_" + resourceAdaptorTypeID);
                        }
                    }
                    cPreUninstallActions.add(new Object[]{"deactivateResourceAdaptorEntity", entityName});
                    cPreUninstallActions.add(new Object[]{"removeResourceAdaptorEntity", entityName});
                    if (raId != null) {
                        if (this.postInstallActions.containsKey(raId)) {
                            this.postInstallActions.get(raId).addAll(cPostInstallActions);
                        } else {
                            this.postInstallActions.put(raId, cPostInstallActions);
                        }
                        if (this.preUninstallActions.containsKey(raId)) {
                            this.preUninstallActions.get(raId).addAll(cPreUninstallActions);
                        } else {
                            this.preUninstallActions.put(raId, cPreUninstallActions);
                        }
                    }
                    cPostInstallActions = new ArrayList();
                    cPreUninstallActions = new ArrayList();
                    raId = null;
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                is = null;
            }
            try {
                if (componentJarFile != null) {
                    componentJarFile.close();
                }
            }
            finally {
                componentJarFile = null;
            }
        }
    }
}

