/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public class DeployableUnitWrapper {
    private URL url;
    private boolean isDirectory;
    private String fileName;
    private String fullPath;
    private DeploymentUnit du;

    public DeployableUnitWrapper(URL url) {
        try {
            this.gatherInfoFromURL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public DeployableUnitWrapper(DeploymentUnit du) {
        try {
            this.du = du;
            this.gatherInfoFromURL(new URL(du.getName()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void gatherInfoFromURL(URL url) throws MalformedURLException {
        this.url = url.getProtocol().equals("jar") ? new URL(url.getFile().replaceFirst("!/", "/")) : url;
        this.fullPath = this.url.getFile();
        this.fileName = this.getFileNameInternal(this.fullPath);
        this.isDirectory = this.isDirectoryInternal(url);
    }

    private boolean isDirectoryInternal(URL url) {
        return new File(url.getFile()).isDirectory();
    }

    private String getFileNameInternal(String fullPath) {
        String fileName = fullPath;
        if (fileName.endsWith("/")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        return fileName;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.du;
    }

    public URL getEntry(String path) {
        URL retURL = null;
        if (this.du != null) {
            retURL = this.du.getResourceLoader().getResource(path);
        } else {
            try {
                retURL = new URL(this.url + "/" + path);
                try {
                    retURL.openStream().close();
                }
                catch (IOException e) {
                    retURL = null;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return retURL;
    }
}

