/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceController;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.mobicents.slee.container.deployment.jboss.SLEEDeploymentMetaData;
import org.mobicents.slee.container.deployment.jboss.SLEESubDeployer;
import org.mobicents.slee.container.deployment.jboss.SleeStateJMXMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLEEDeployer
extends AbstractSimpleVFSRealDeployer<SLEEDeploymentMetaData> {
    private static Logger logger = Logger.getLogger(SLEEDeployer.class);
    private ArrayList<URL> waitingList = new ArrayList();
    private ArrayList<URL> deployableUnits = new ArrayList();
    private HashMap<URL, VFSDeploymentUnit> vfsDUs = new HashMap();
    private HashMap<URL, SLEEDeploymentMetaData> metadata = new HashMap();
    private final SleeStateJMXMonitor jmxMonitor;

    public SLEEDeployer(ServiceController serviceController) {
        super(SLEEDeploymentMetaData.class);
        this.setOutput(SLEEDeploymentMetaData.class);
        this.jmxMonitor = new SleeStateJMXMonitor(this);
        this.jmxMonitor.getSleeStateAsInt();
        logger.info((Object)"Mobicents SLEE Real Deployer initialized.");
    }

    public void deploy(VFSDeploymentUnit vfsDU, SLEEDeploymentMetaData sdmd) throws DeploymentException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SLEEParserDeployer 'deploy' called:");
            logger.trace((Object)("vfsDeploymentUnit.." + vfsDU));
            logger.trace((Object)("sdmd..............." + sdmd));
        }
        if (sdmd != null) {
            try {
                URL deployableUnitURL = VFSUtils.getCompatibleURL((VirtualFile)vfsDU.getRoot());
                this.vfsDUs.put(deployableUnitURL, vfsDU);
                this.metadata.put(deployableUnitURL, sdmd);
                if (!this.jmxMonitor.isSleeRunning()) {
                    logger.warn((Object)("Unable to INSTALL " + vfsDU.getSimpleName() + " right now. Waiting for SLEE to be in RUNNING state."));
                    this.waitingList.add(deployableUnitURL);
                    return;
                }
                this.callSubDeployer(deployableUnitURL);
            }
            catch (Exception e) {
                logger.error((Object)("Failure while deploying " + vfsDU.getName()), (Throwable)e);
            }
        }
    }

    public void undeploy(VFSDeploymentUnit vfsDU, SLEEDeploymentMetaData sdmd) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"SLEEParserDeployer 'undeploy' called:");
            logger.trace((Object)("vfsDeploymentUnit.." + vfsDU));
            logger.trace((Object)("sdmd..............." + sdmd));
        }
        if (sdmd != null) {
            try {
                this.doUndeployActions(VFSUtils.getCompatibleURL((VirtualFile)vfsDU.getRoot()));
            }
            catch (Exception e) {
                logger.error((Object)("Failure while undeploying " + vfsDU.getName()), (Throwable)e);
            }
        }
    }

    private void doUndeployActions(URL deployableUnitURL) throws Exception {
        SLEESubDeployer ssdeployer = SLEESubDeployer.INSTANCE;
        ssdeployer.stop(deployableUnitURL);
    }

    private void callSubDeployer(URL deployableUnitURL) throws Exception {
        SLEESubDeployer ssdeployer = SLEESubDeployer.INSTANCE;
        ssdeployer.accepts(deployableUnitURL);
        ssdeployer.init(deployableUnitURL);
        SLEEDeploymentMetaData sdmd = this.metadata.remove(deployableUnitURL);
        VFSDeploymentUnit vfsDU = this.vfsDUs.get(deployableUnitURL);
        for (String componentJar : sdmd.duContents) {
            URL componentURL = null;
            try {
                componentURL = VFSUtils.getCompatibleURL((VirtualFile)vfsDU.getFile(componentJar));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to locate " + componentJar + " in DU. Does it exists?", e);
            }
            ssdeployer.accepts(componentURL);
            ssdeployer.init(componentURL);
            ssdeployer.start(componentURL);
        }
        ssdeployer.start(deployableUnitURL);
    }

    public void sleeIsRunning() {
        int failCount = 0;
        for (URL deployableUnitURL : this.waitingList) {
            try {
                this.callSubDeployer(deployableUnitURL);
                this.deployableUnits.add(deployableUnitURL);
            }
            catch (Exception e) {
                ++failCount;
                logger.error((Object)"Failure during deployment procedures.", (Throwable)e);
            }
        }
        if (this.waitingList.size() > 0) {
            logger.info((Object)("><><><><><><><><>< Deployment of JAIN SLEE deployable-units complete. " + (failCount == 0 ? "No" : Integer.valueOf(failCount)) + " failures. ><><><><><><><><><"));
        }
        this.waitingList.clear();
    }
}

