/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.mobicents.slee.container.deployment.jboss.SLEEDeployerEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SLEEDeploymentMetaData {
    private static final Logger logger = Logger.getLogger(SLEEDeploymentMetaData.class);
    protected ComponentType componentType = ComponentType.UNKNOWN;
    protected ArrayList<String> duContents = new ArrayList();

    public SLEEDeploymentMetaData(DeploymentUnit du) {
        InputStream is = null;
        is = du.getResourceClassLoader().getResourceAsStream("META-INF/deployable-unit.xml");
        if (is != null) {
            this.componentType = ComponentType.DU;
            this.parseDUContents(is);
        } else if (du.getResourceClassLoader().getResourceAsStream("META-INF/event-jar.xml") != null) {
            this.componentType = ComponentType.EVENT;
        } else if (du.getResourceClassLoader().getResourceAsStream("META-INF/sbb-jar.xml") != null) {
            this.componentType = ComponentType.SBB;
        } else if (du.getResourceClassLoader().getResourceAsStream("META-INF/profile-spec-jar.xml") != null) {
            this.componentType = ComponentType.PROFILE;
        } else if (du.getResourceClassLoader().getResourceAsStream("META-INF/resource-adaptor-type-jar.xml") != null) {
            this.componentType = ComponentType.RATYPE;
        } else if (du.getResourceClassLoader().getResourceAsStream("META-INF/resource-adaptor-jar.xml") != null) {
            this.componentType = ComponentType.RA;
        } else if (du.getResourceClassLoader().getResourceAsStream("META-INF/library-jar.xml") != null) {
            this.componentType = ComponentType.LIBRARY;
        }
    }

    private void parseDUContents(InputStream is) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(SLEEDeployerEntityResolver.INSTANCE);
            Document doc = docBuilder.parse(is);
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element)) continue;
                Element elem = (Element)nodeList.item(i);
                this.duContents.add(elem.getTextContent());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error parsing Deployable Unit to build SLEE Deployer MetaData.", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ComponentType {
        UNKNOWN(-1),
        EVENT(1),
        SBB(2),
        PROFILE(3),
        RATYPE(4),
        RA(5),
        SERVICE(6),
        LIBRARY(7),
        DU(9);

        int value;

        private ComponentType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

